/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;

public class ShapeNode
extends AbstractGraphicsNode {
    protected Shape shape;
    protected ShapePainter shapePainter;
    private Rectangle2D primitiveBounds;
    private Rectangle2D geometryBounds;
    private Shape paintedArea;
    private Shape sensitiveArea;

    public void setShape(Shape newShape) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shape = newShape;
        if (this.shapePainter != null) {
            if (newShape != null) {
                this.shapePainter.setShape(newShape);
            } else {
                this.shapePainter = null;
            }
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShapePainter(ShapePainter newShapePainter) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.shapePainter = newShapePainter;
        if (this.shapePainter != null && this.shape != this.shapePainter.getShape()) {
            this.shapePainter.setShape(this.shape);
        }
        this.fireGraphicsNodeChangeCompleted();
    }

    public ShapePainter getShapePainter() {
        return this.shapePainter;
    }

    public void paint(Graphics2D g2d) {
        if (this.isVisible) {
            super.paint(g2d);
        }
    }

    public void primitivePaint(Graphics2D g2d) {
        if (this.shapePainter != null) {
            this.shapePainter.paint(g2d);
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.paintedArea = null;
        this.sensitiveArea = null;
    }

    public boolean contains(Point2D p) {
        Rectangle2D b = this.getBounds();
        if (b == null || !b.contains(p)) {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: {
                Shape s = this.getSensitiveArea();
                if (s != null) {
                    return this.isVisible && s.contains(p);
                }
                return false;
            }
            case 3: {
                return this.isVisible;
            }
            case 4: 
            case 5: 
            case 6: {
                Shape s = this.getSensitiveArea();
                if (s != null) {
                    return s.contains(p);
                }
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        Rectangle2D b = this.getBounds();
        if (b != null) {
            return b.intersects(r) && this.paintedArea != null && this.paintedArea.intersects(r);
        }
        return false;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null) {
            if (this.shape == null || this.shapePainter == null) {
                return null;
            }
            this.primitiveBounds = this.shapePainter.getPaintedBounds2D();
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.primitiveBounds;
    }

    public Shape getSensitiveArea() {
        if (this.sensitiveArea == null) {
            ShapePainter strokeShapePainter = null;
            ShapePainter fillShapePainter = null;
            if (this.shapePainter instanceof StrokeShapePainter) {
                strokeShapePainter = this.shapePainter;
            } else if (this.shapePainter instanceof FillShapePainter) {
                fillShapePainter = this.shapePainter;
            } else {
                CompositeShapePainter cp = (CompositeShapePainter)this.shapePainter;
                int i = 0;
                while (i < cp.getShapePainterCount()) {
                    ShapePainter sp = cp.getShapePainter(i);
                    if (sp instanceof StrokeShapePainter) {
                        strokeShapePainter = sp;
                    } else if (sp instanceof FillShapePainter) {
                        fillShapePainter = sp;
                    }
                    ++i;
                }
            }
            switch (this.pointerEventType) {
                case 0: 
                case 4: {
                    this.sensitiveArea = this.shapePainter.getPaintedArea();
                    break;
                }
                case 1: 
                case 5: {
                    if (fillShapePainter == null) break;
                    this.sensitiveArea = fillShapePainter.getPaintedArea();
                    break;
                }
                case 2: 
                case 6: {
                    if (strokeShapePainter == null) break;
                    this.sensitiveArea = strokeShapePainter.getPaintedArea();
                    break;
                }
            }
        }
        return this.sensitiveArea;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            if (this.shape == null) {
                return null;
            }
            this.geometryBounds = this.normalizeRectangle(this.shape.getBounds2D());
        }
        return this.geometryBounds;
    }

    public Shape getOutline() {
        return this.shape;
    }
}

