/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.fop0205;

import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.svg.SVGArea;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.BarcodeCanvasSetupException;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BarcodeArea
extends Area {
    private BarcodeGenerator bargen;
    private String msg;
    private String renderMode;

    public BarcodeArea(FontState fontState, float width, float height) {
        super(fontState, (int)width, (int)height);
        this.currentHeight = (int)height;
        this.contentRectangleWidth = (int)width;
    }

    public void setBarcode(BarcodeGenerator bargen, String msg, String renderMode) {
        this.bargen = bargen;
        this.msg = msg;
        this.renderMode = renderMode;
    }

    public BarcodeGenerator getBarcodeGenerator() {
        return this.bargen;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getRenderMode() {
        return this.renderMode;
    }

    public int getWidth() {
        return this.contentRectangleWidth;
    }

    public double mpt2mm(double mpt) {
        return UnitConv.pt2mm(mpt / 1000.0);
    }

    public void render(Renderer renderer) {
        this.renderBarcodeUsingSVG(renderer);
    }

    protected SVGArea createSVGArea() throws BarcodeCanvasSetupException {
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        SVGCanvasProvider svgout = new SVGCanvasProvider(domImpl, true);
        this.getBarcodeGenerator().generateBarcode(svgout, this.getMessage());
        Document dom = svgout.getDOM();
        SVGArea svgarea = new SVGArea(this.getFontState(), (float)this.getWidth(), (float)this.getHeight());
        svgarea.setSVGDocument(dom);
        return svgarea;
    }

    protected void renderBarcodeUsingSVG(Renderer renderer) {
        try {
            renderer.renderSVGArea(this.createSVGArea());
        }
        catch (BarcodeCanvasSetupException bcse) {
            MessageHandler.errorln((String)("Couldn't render barcode due to BarcodeCanvasSetupException: " + bcse.getMessage()));
        }
    }
}

