/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.Time;

public class DatatypeHandler {
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String DATE_TYPE = "date";
    public static final String DATETIME_TYPE = "dateTime";
    public static final String DOUBLE_TYPE = "double";
    public static final String FLOAT_TYPE = "float";
    public static final String INTEGER_TYPE = "integer";
    public static final String LONG_TYPE = "long";
    public static final String STRING_TYPE = "string";
    public static final String TIME_TYPE = "time";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss";

    private DatatypeHandler() {
    }

    public static String guessType(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return STRING_TYPE;
        }
        try {
            Integer.parseInt(value);
            return INTEGER_TYPE;
        }
        catch (NumberFormatException nfe) {
            try {
                Long.parseLong(value);
                return LONG_TYPE;
            }
            catch (NumberFormatException nfe2) {
                try {
                    Float.valueOf(value);
                    return FLOAT_TYPE;
                }
                catch (NumberFormatException nfe3) {
                    try {
                        Double.valueOf(value);
                        return DOUBLE_TYPE;
                    }
                    catch (NumberFormatException nfe4) {
                        if (value.equals(TRUE) || value.equals(FALSE)) {
                            return BOOLEAN_TYPE;
                        }
                        try {
                            Date.parseDate(value);
                            return DATE_TYPE;
                        }
                        catch (ParseException px) {
                            try {
                                Time.parseTime(value);
                                return TIME_TYPE;
                            }
                            catch (ParseException px2) {
                            }
                            catch (IllegalArgumentException ex) {
                                // empty catch block
                            }
                            SimpleDateFormat df = null;
                            df = value.indexOf(46) < 0 ? new SimpleDateFormat(DATE_FORMAT) : new SimpleDateFormat(DATE_FORMAT_2);
                            try {
                                df.parse(value);
                                return DATETIME_TYPE;
                            }
                            catch (ParseException parseException) {
                                return STRING_TYPE;
                            }
                        }
                    }
                }
            }
        }
    }

    protected static String whichType(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        if (type1.equals(STRING_TYPE) || type2.equals(STRING_TYPE)) {
            return STRING_TYPE;
        }
        if (INTEGER_TYPE.equals(type1)) {
            if (LONG_TYPE.equals(type2)) {
                return LONG_TYPE;
            }
            if (FLOAT_TYPE.equals(type2)) {
                return FLOAT_TYPE;
            }
            if (DOUBLE_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
        } else if (LONG_TYPE.equals(type1)) {
            if (INTEGER_TYPE.equals(type2)) {
                return LONG_TYPE;
            }
            if (FLOAT_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
            if (DOUBLE_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
        } else if (FLOAT_TYPE.equals(type1)) {
            if (INTEGER_TYPE.equals(type2)) {
                return FLOAT_TYPE;
            }
            if (LONG_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
            if (DOUBLE_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
        } else if (DOUBLE_TYPE.equals(type1)) {
            if (INTEGER_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
            if (LONG_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
            if (FLOAT_TYPE.equals(type2)) {
                return DOUBLE_TYPE;
            }
        }
        return STRING_TYPE;
    }
}

