/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class GYearMonth
extends DateTimeBase {
    private static final long serialVersionUID = -8864050276805766473L;
    private static final String YEARMONTH_FORMAT = "yyyy-MM";
    private static final String BAD_GYEARMONTH = "Bad gYearMonth format: ";

    public GYearMonth() {
    }

    public GYearMonth(short century, short year, short month) {
        this.setCentury(century);
        this.setYear(year);
        this.setMonth(month);
    }

    public GYearMonth(int year, int month) {
        short century = (short)(year / 100);
        this.setCentury(century);
        this.setYear((short)(year %= 100));
        this.setMonth((short)month);
    }

    public GYearMonth(short[] values) {
        this.setValues(values);
    }

    public GYearMonth(String gyearMonth) throws ParseException {
        GYearMonth.parseGYearMonthInternal(gyearMonth, this);
    }

    public void setValues(short[] values) {
        if (values.length != 3) {
            throw new IllegalArgumentException("GYearMonth#setValues: not the right number of values");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
    }

    public short[] getValues() {
        short[] result = new short[]{this.getCentury(), this.getYear(), this.getMonth()};
        return result;
    }

    public Date toDate() {
        SimpleDateFormat df = new SimpleDateFormat(YEARMONTH_FORMAT);
        this.setDateFormatTimeZone(df);
        Date date = null;
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isNegative()) {
            result.append('-');
        }
        if (this.getCentury() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getCentury());
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        result.append('-');
        if (this.getMonth() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getMonth());
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GYearMonth.parseGYearMonth(str);
    }

    public static GYearMonth parseGYearMonth(String str) throws ParseException {
        GYearMonth result = new GYearMonth();
        return GYearMonth.parseGYearMonthInternal(str, result);
    }

    private static GYearMonth parseGYearMonthInternal(String str, GYearMonth result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GYearMonth();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            result.setNegative();
            ++idx;
        }
        if (!(Character.isDigit(chars[idx]) && Character.isDigit(chars[idx + 1]) && Character.isDigit(chars[idx + 2]) && Character.isDigit(chars[idx + 3]))) {
            throw new ParseException(BAD_GYEARMONTH + str + "\nA gYearMonth must follow the pattern CCYY(Z|((+|-)hh:mm)).", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        short value2 = (short)((chars[idx + 2] - 48) * 10 + (chars[idx + 3] - 48));
        if (value1 == 0 && value2 == 0) {
            throw new ParseException(BAD_GYEARMONTH + str + "\n'0000' is not allowed as a year.", idx);
        }
        result.setCentury(value1);
        result.setYear(value2);
        if (chars[idx += 4] != '-') {
            throw new ParseException(BAD_GYEARMONTH + str + "\nA gYearMonth must follow the pattern CCYY(Z|((+|-)hh:mm)).", idx);
        }
        if (!Character.isDigit(chars[++idx]) || !Character.isDigit(chars[idx + 1])) {
            throw new ParseException(BAD_GYEARMONTH + str + "\nThe Month must be 2 digits long", idx);
        }
        value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        result.setMonth(value1);
        GYearMonth.parseTimeZone(str, result, chars, idx += 2, BAD_GYEARMONTH);
        return result;
    }

    public boolean hasDay() {
        return false;
    }

    public short getDay() {
        String err = "org.exolab.castor.types.GYearMonth does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short day) {
        String err = "org.exolab.castor.types.GYearMonth does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasHour() {
        return false;
    }

    public short getHour() {
        String err = "org.exolab.castor.types.GYearMonth does not have an Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) {
        String err = "org.exolab.castor.types.GYearMonth does not have an Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasMinute() {
        return false;
    }

    public short getMinute() {
        String err = "org.exolab.castor.types.GYearMonth does not have a Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) {
        String err = "org.exolab.castor.types.GYearMonth does not have a Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasSeconds() {
        return false;
    }

    public short getSeconds() {
        String err = "org.exolab.castor.types.GYearMonth does not have a Seconds field.";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second) {
        String err = "org.exolab.castor.types.GYearMonth does not have a Seconds field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasMilli() {
        return false;
    }

    public short getMilli() {
        String err = "org.exolab.castor.types.GYearMonth does not have a Milliseconds field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMilliSecond(short millisecond) {
        String err = "org.exolab.castor.types.GYearMonth does not have a Milliseconds field.";
        throw new OperationNotSupportedException(err);
    }
}

