/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLUpdateRequestHandler
extends XSQLActionHandlerImpl {
    private static final int MINBATCH = 0;
    private static final String TABLE = "table";
    private static final String TRANSFORM = "transform";
    private static final String DATEFORMAT = "date-format";
    private static final String KEYCOLUMNS = "key-columns";
    private static final String COLUMNS = "columns";
    private static final String INS_STATUS_ELT = "update-request";
    private static final String BATCHSIZE = "commit-batch-size";
    private static final String COMMIT = "commit";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAction(Node node) throws SQLException {
        Object object;
        OracleXMLSave oracleXMLSave = null;
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        Element element = this.getActionElement();
        XSQLPageRequest xSQLPageRequest = this.getPageRequest();
        String string = this.getAttributeAllowingParam(TABLE, element);
        String string2 = this.getAttributeAllowingParam(TRANSFORM, element);
        String string3 = this.getAttributeAllowingParam(DATEFORMAT, element);
        String string4 = this.getAttributeAllowingParam(KEYCOLUMNS, element);
        String string5 = this.getAttributeAllowingParam(COLUMNS, element);
        String string6 = this.getAttributeAllowingParam(BATCHSIZE, element);
        String string7 = this.getAttributeAllowingParam(COMMIT, element);
        if (string2 != null && !string2.equals("")) {
            if (XSQLUtil.untrustedAbsoluteStylesheetURL(string2)) {
                this.reportError(node, Res.format(25118, string2));
                return;
            }
            object = xSQLPageRequest.translateURL(string2);
            if (object == null) {
                this.reportError(node, Res.format(25123, string2));
                return;
            }
            string2 = object;
        } else {
            string2 = null;
        }
        if (string == null || string.equals("")) {
            this.reportMissingAttribute(node, TABLE);
            return;
        }
        if (string4 == null || string4.equals("")) {
            this.reportMissingAttribute(node, KEYCOLUMNS);
            return;
        }
        object = this.getPageRequest().getPostedDocument();
        Object object2 = null;
        if (object != null) {
            try {
                String[] stringArray;
                object2 = string2 != null && !string2.equals("") ? XSQLStylesheetProcessor.processToDocument((Document)object, string2, this.getPageRequest()) : object;
                oracleXMLSave = new OracleXMLSave(this.getPageRequest().getJDBCConnection(), string);
                oracleXMLSave.setIgnoreCase(true);
                if (string4 != null && !string4.equals("") && (stringArray = XSQLUtil.tokenizeIntoArray(string4)) != null) {
                    oracleXMLSave.setKeyColumnList(stringArray);
                }
                if (string5 != null && !string5.equals("") && (stringArray = XSQLUtil.tokenizeIntoArray(string5)) != null) {
                    oracleXMLSave.setUpdateColumnList(stringArray);
                }
                if (string3 != null && !string3.equals("")) {
                    oracleXMLSave.setDateFormat(string3);
                }
                if (string6 != null && !string6.equals("")) {
                    try {
                        int n = Integer.parseInt(string6);
                        if (n > 0) {
                            oracleXMLSave.setCommitBatch(n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int n = oracleXMLSave.updateXML((Document)object2);
                if (string7 == null || !string7.equalsIgnoreCase("NO")) {
                    this.getPageRequest().getJDBCConnection().commit();
                }
                this.reportStatus(node, "rows", "" + n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportError(node, Res.format(25113, string2));
            }
            catch (IOException iOException) {
                this.reportError(node, Res.format(25113, string2));
            }
            catch (SQLException sQLException) {
                this.reportError(node, sQLException.getMessage());
            }
            catch (OracleXMLSQLException oracleXMLSQLException) {
                this.reportError(node, oracleXMLSQLException.getMessage());
            }
            catch (Exception exception) {
            }
            finally {
                if (oracleXMLSave != null) {
                    oracleXMLSave.close();
                }
            }
        } else {
            this.reportStatus(node, "result", Res.getString(25115));
        }
    }
}

