/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLError;
import oracle.xml.xsql.XSQLErrorHandler;
import oracle.xml.xsql.XSQLPageProcessor;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.xml.sax.SAXParseException;

public class XSQLErrorHandlerImpl
implements XSQLErrorHandler {
    public void handleError(XSQLError xSQLError, XSQLPageRequest xSQLPageRequest) {
        Object[] objectArray = xSQLError.getSupplementalErrorInfo();
        if (objectArray == null) {
            this.print(xSQLPageRequest, new String[]{xSQLError.getMessage()});
        } else {
            Object object;
            int n;
            Vector<Object> vector = new Vector<Object>(4);
            vector.addElement(xSQLError.getMessage());
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    object = objectArray[n];
                    if (object == null) continue;
                    if (object instanceof String) {
                        vector.addElement(object);
                        continue;
                    }
                    if (object instanceof SAXParseException) {
                        vector.addElement(this.xmlErrorLineInfo((SAXParseException)object));
                        vector.addElement(this.xmlErrorMessage((SAXParseException)object));
                        continue;
                    }
                    if (object instanceof Throwable) {
                        vector.addElement(this.dumpThrowableToString((Throwable)object));
                        continue;
                    }
                    String string = null;
                    try {
                        string = object.toString();
                    }
                    catch (Throwable throwable) {
                        vector.addElement(Res.getString(25124));
                    }
                    vector.addElement(string == null ? "(null)" : string);
                }
            }
            n = vector.size();
            object = new String[n];
            for (int i = 0; i < n; ++i) {
                object[i] = (String)vector.elementAt(i);
            }
            this.print(xSQLPageRequest, (String[])object);
        }
    }

    private void print(XSQLPageRequest xSQLPageRequest, String[] stringArray) {
        if (xSQLPageRequest.useHTMLErrors()) {
            xSQLPageRequest.setContentType("text/html");
        } else {
            xSQLPageRequest.setContentType("text/plain");
        }
        PrintWriter printWriter = xSQLPageRequest.getErrorWriter();
        if (xSQLPageRequest.useHTMLErrors()) {
            if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println("<H2>" + XSQLPageProcessor.getVersion() + "</H2>");
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].equals("")) continue;
                printWriter.println("<font size='-1' face='monospace'>" + this.crlfToBr(stringArray[i]) + "</font><BR>");
            }
        } else {
            if (!xSQLPageRequest.printedErrorHeader()) {
                printWriter.println(XSQLPageProcessor.getVersion());
                xSQLPageRequest.setPrintedErrorHeader(true);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].equals("")) continue;
                printWriter.println(stringArray[i]);
            }
        }
        printWriter.flush();
    }

    private String crlfToBr(String string) {
        string = XSQLUtil.quoteLessThanSigns(string);
        int n = 0;
        boolean bl = false;
        while ((n = string.indexOf("\n")) >= 0) {
            string = string.substring(0, n) + "<BR>" + string.substring(n + 1);
        }
        return string;
    }

    private String name(XSQLPageRequest xSQLPageRequest) {
        return "Oracle XSQL " + xSQLPageRequest.getRequestType() + " Error";
    }

    private String xmlErrorLineInfo(SAXParseException sAXParseException) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        String string = sAXParseException.getSystemId();
        return "XML parse error at line " + n + ", char " + n2;
    }

    private String xmlErrorMessage(SAXParseException sAXParseException) {
        return sAXParseException.getMessage();
    }

    private String dumpThrowableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

