/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.comp.CXMLParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;

public class CompressReaderProcess
extends Process {
    public void initialize() {
        Input input = this.getInput("compxml");
        input.supportType(3);
        input.supportType(8);
        Output output = this.getOutput("xml");
        output.supportType(4);
        output.supportType(5);
        output.supportType(8);
    }

    public void execute() throws PipelineException {
        Source source = this.getInputSource("compxml");
        Output output = this.getOutput("xml");
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            try {
                InputStream inputStream = streamSource.getInputStream();
                if (inputStream == null) {
                    throw new PipelineException("Error reading input compressed stream");
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                if (output.isXMLType(4)) {
                    XMLDocument xMLDocument = new XMLDocument();
                    xMLDocument.readExternal((ObjectInput)objectInputStream);
                    objectInputStream.close();
                    DOMResult dOMResult = new DOMResult((Node)xMLDocument);
                    this.setOutputResult("xml", dOMResult);
                    this.convertFromDOM(dOMResult, output);
                } else if (output.isXMLType(5)) {
                    ContentHandler contentHandler = this.getSAXContentHandler(output);
                    CXMLParser cXMLParser = new CXMLParser();
                    cXMLParser.setContentHandler(contentHandler);
                    ErrorHandler errorHandler = this.getSAXErrorHandler(output);
                    cXMLParser.setErrorHandler(errorHandler);
                    cXMLParser.parse((ObjectInput)objectInputStream);
                    SAXResult sAXResult = new SAXResult(contentHandler);
                    this.setOutputResult("xml", sAXResult);
                    this.convertFromSAX(sAXResult, output);
                }
            }
            catch (Exception exception) {
                if (!this.ignoreError("xml")) {
                    this.error(30001, 17, exception);
                }
                try {
                    this.info(30000, new String[]{"CompressReaderProcess", exception.getMessage()});
                    XMLDocument xMLDocument = this.getErrorDocument("xml", true);
                    if (output.isXMLType(4)) {
                        DOMResult dOMResult = new DOMResult((Node)xMLDocument);
                        this.setOutputResult("xml", dOMResult);
                        this.convertFromDOM(dOMResult, output);
                    } else if (output.isXMLType(5)) {
                        ContentHandler contentHandler = this.getSAXContentHandler(output);
                        xMLDocument.reportSAXEvents(contentHandler);
                        SAXResult sAXResult = new SAXResult(contentHandler);
                        this.setOutputResult("xml", sAXResult);
                        this.convertFromSAX(sAXResult, output);
                    }
                }
                catch (Exception exception2) {
                    this.error(30006, 17, exception2);
                }
            }
        } else {
            this.error(30002, 17, new String[]{"StreamSource"});
        }
    }
}

