/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdeveloper.cm.AbstractConnectionWrapper;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

public class JdbcConnectionWrapper
extends AbstractConnectionWrapper {
    private Connection _connection;

    protected JdbcConnectionWrapper(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter, ConnectionManager connectionManager) throws CMException {
        super(connectionDescriptor, connectInfoPrompter, connectionManager);
        this._connTypes = new ArrayList(1);
        this._connTypes.add("JDBC");
    }

    void createConnection(ConnectionDescriptor connectionDescriptor) throws CMException {
        String string;
        String string2;
        if (null != this._prompter) {
            this._prompter.promptUser(connectionDescriptor);
        }
        Properties properties = new Properties();
        String string3 = connectionDescriptor.getRole();
        if (null != string3 && !string3.equals("") && !string3.equals("Normal")) {
            properties.put("internal_logon", string3);
        }
        if (null != (string2 = connectionDescriptor.getUsername())) {
            properties.put("user", string2);
        }
        if (null != (string = connectionDescriptor.getPassword())) {
            properties.put("password", string);
        }
        String string4 = CMUtils.getUrl("JDBC", connectionDescriptor);
        String string5 = connectionDescriptor.getJdbcDriver();
        if (string5 == null) {
            throw new CMException("No driver specified.");
        }
        try {
            this._connection = this.createConnectionImpl(string5, string4, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CMException("Unable to find driver: " + string5);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CMException("Unable to register driver: " + string5);
        }
        catch (InstantiationException instantiationException) {
            throw new CMException("Unable to instantiate driver: " + string5);
        }
        catch (SQLException sQLException) {
            throw new CMException(sQLException);
        }
    }

    protected Connection createConnectionImpl(String string, String string2, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        DriverManager.registerDriver((Driver)Class.forName(string).newInstance());
        return DriverManager.getConnection(string2, properties);
    }

    public Object getPresentation(String string) throws CMException {
        if (!string.equals("JDBC")) {
            throw new CMException("Cannot find presentation for " + string + " in this ConnectionWrapper instance");
        }
        return this.getJdbcConnection();
    }

    public Connection getJdbcConnection() throws CMException {
        if (this._connection == null) {
            this.createConnection(this._descriptor);
        }
        return this._connection;
    }

    public void closeConnection() {
        if (this._connection == null) {
            return;
        }
        try {
            this._connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean containsPresentation(String string) {
        return string.equals("JDBC");
    }
}

