/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.multi;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.inspector.multi.SelectionEvent;
import oracle.bali.inspector.multi.SelectionListener;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.share.event.ListenerManager;

public class ArraySelectionModel
implements SelectionModel {
    private ListenerManager _manager;
    private Vector _items;

    public ArraySelectionModel() {
        this(null);
    }

    public ArraySelectionModel(Vector vector) {
        this._items = vector != null ? (Vector)vector.clone() : new Vector();
    }

    public final void addItem(int n, Object object) {
        this.addItems(n, new Object[]{object});
    }

    public void addItems(int n, Object[] objectArray) {
        int n2;
        if (objectArray != null && (n2 = objectArray.length) > 0) {
            Vector vector = this._items;
            synchronized (vector) {
                int n3 = 0;
                while (n3 < n2) {
                    this._items.insertElementAt(objectArray[n3], n + n3);
                    ++n3;
                }
                this._fireSelectionEvent(0, n, n2);
            }
        }
    }

    public void removeItems(int n, int n2) {
        if (n2 > 0) {
            Vector vector = this._items;
            synchronized (vector) {
                int n3 = n + n2 - 1;
                this._fireSelectionEvent(1, n, n2);
                int n4 = n3;
                while (n4 >= n) {
                    this._items.removeElementAt(n4);
                    --n4;
                }
                this._fireSelectionEvent(2, n, n2);
            }
        }
    }

    public int getSelectedItemCount() {
        return this._items.size();
    }

    public Object getSelectedItem(int n) {
        return this._items.elementAt(n);
    }

    public SelectionModel copyContents() {
        return new ArraySelectionModel(this._items);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)selectionListener);
        }
    }

    private void _fireSelectionEvent(int n, int n2, int n3) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        SelectionEvent selectionEvent = new SelectionEvent(this, n, n2, n3);
        switch (n) {
            case 0: {
                while (enumeration.hasMoreElements()) {
                    SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
                    selectionListener.itemsAdded(selectionEvent);
                }
                break;
            }
            case 1: {
                while (enumeration.hasMoreElements()) {
                    SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
                    selectionListener.itemsRemoving(selectionEvent);
                }
                break;
            }
            case 2: {
                while (enumeration.hasMoreElements()) {
                    SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
                    selectionListener.itemsRemoved(selectionEvent);
                }
                break;
            }
        }
    }
}

