/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editors.CharField;

public class CharEditor
extends PropertyEditorSupport
implements PropertyEditorFactory {
    private TableCellRenderer _renderer;
    private TableCellEditor _cellEditor;

    public String getJavaInitializationString() {
        return "" + this.getValue();
    }

    public void setValue(Object object) {
        super.setValue((Character)object);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this._setAsText(string));
    }

    private Character _setAsText(String string) {
        int n;
        int n2 = n = string != null ? string.length() : 0;
        if (n != 0) {
            if (n == 1) {
                return new Character(string.charAt(0));
            }
            if (n > 2 && string.charAt(0) == '0' && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                try {
                    int n3 = Integer.valueOf(string.substring(2), 16);
                    if (n3 <= 65535 && n3 >= 0) {
                        return new Character((char)n3);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object object) {
        this.setValue(object);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new ValueRenderer();
        }
        return this._renderer;
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale locale) {
        if (this._cellEditor == null) {
            this._cellEditor = new CharCellEditor();
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return false;
    }

    public Component getTearOffEditor() {
        return null;
    }

    public boolean hasAdvancedEditor() {
        return false;
    }

    public Component getAdvancedEditor() {
        return null;
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        private ValueRenderer() {
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            super.paintComponent(graphics);
        }
    }

    private class CharCellEditor
    extends DefaultCellEditor {
        public CharCellEditor() {
            super(new CharField());
        }

        public Object getCellEditorValue() {
            String string = (String)super.getCellEditorValue();
            if (string == null || string.length() == 0) {
                return null;
            }
            return new Character(string.charAt(0));
        }
    }
}

