/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class PropertyInspectorContainer
extends JComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COMPONENT = "selectedComponent";
    private static final String __RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_PROPERTIES = "PROPERTIES";
    private boolean _nameDefaulted;
    private UIListener _listener;
    private JTabbedPane _tabPane;

    public PropertyInspectorContainer() {
        this(null);
    }

    public PropertyInspectorContainer(PropertyInspector propertyInspector) {
        if (propertyInspector == null) {
            propertyInspector = new PropertyInspector();
        }
        this._listener = new UIListener();
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIManager.getColor(LookAndFeel.DARK_INTENSITY));
        this.setOpaque(true);
        this._tabPane = new JTabbedPane(3);
        this._tabPane.addChangeListener(this._listener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
        jPanel.add("Center", this._tabPane);
        this.add("Center", jPanel);
        String string = this._getTranslatedString(_KEY_PROPERTIES);
        this._nameDefaulted = true;
        this.addInspector(propertyInspector, StringUtils.stripMnemonic((String)string));
    }

    public final void addInspector(Component component, String string) {
        this.addInspector(component, string, this.getInspectorCount());
    }

    public void addInspector(Component component, String string, int n) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= this.getInspectorCount()) {
            n = this.getInspectorCount();
        }
        this._tabPane.insertTab(string, null, component, null, n);
        this.invalidate();
        this.repaint();
    }

    public void removeInspector(Component component) {
        int n = this._tabPane.indexOfComponent(component);
        if (n != -1) {
            if (component instanceof PropertyInspector) {
                this._commitEdit((PropertyInspector)component);
            }
            this._tabPane.removeTabAt(n);
            this.invalidate();
            this.repaint();
        }
    }

    public void removeAllInspectors() {
        int n = this.getInspectorCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.removeInspector(this.getInspector(n2));
            --n2;
        }
    }

    public int getInspectorCount() {
        return this._tabPane.getTabCount();
    }

    public Component getInspector(int n) {
        if (n < 0 || n >= this.getInspectorCount()) {
            return null;
        }
        return this._tabPane.getComponentAt(n);
    }

    public Component getSelectedComponent() {
        return this._tabPane.getSelectedComponent();
    }

    public void setSelectedComponent(Component component) {
        int n;
        Component component2 = this._tabPane.getSelectedComponent();
        if (component2 instanceof PropertyInspector) {
            this._commitEdit((PropertyInspector)component2);
        }
        if ((n = this._tabPane.indexOfComponent(component)) != -1) {
            this._tabPane.setSelectedIndex(n);
        }
    }

    public final PropertyInspector getSelectedInspector() {
        Component component = this.getSelectedComponent();
        return component instanceof PropertyInspector ? (PropertyInspector)component : null;
    }

    public String getComponentTitle(Component component) {
        int n = this._tabPane.indexOfComponent(component);
        if (n != -1) {
            return this._tabPane.getTitleAt(n);
        }
        return null;
    }

    public void setComponentTitle(Component component, String string) {
        int n = this._tabPane.indexOfComponent(component);
        if (n != -1) {
            this._tabPane.setTitleAt(n, string);
            this._nameDefaulted = false;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._tabPane.setEnabled(bl);
        int n = 0;
        while (n < this._tabPane.getTabCount()) {
            this._tabPane.setEnabledAt(n, bl);
            this._tabPane.getComponentAt(n).setEnabled(bl);
            ++n;
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateLabels();
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    private void _updateLabels() {
        if (this._nameDefaulted) {
            String string = this._getTranslatedString(_KEY_PROPERTIES);
            this._tabPane.setTitleAt(0, StringUtils.stripMnemonic((String)string));
        }
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(__RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        return resourceBundle.getString(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private void _commitEdit(PropertyInspector propertyInspector) {
        propertyInspector.__commitEdit();
    }

    private class UIListener
    implements ChangeListener {
        private UIListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Component component = PropertyInspectorContainer.this._tabPane.getSelectedComponent();
            PropertyInspectorContainer.this.firePropertyChange(PropertyInspectorContainer.PROPERTY_SELECTED_COMPONENT, null, PropertyInspectorContainer.this.getSelectedComponent());
        }
    }
}

