/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class InspectorGroup {
    private static boolean _sMethodInitialized = false;
    private static Method _sGetCauseMethod;
    private static final String _OK_COMMAND = "OK";
    private static final String _CANCEL_COMMAND = "Cancel";
    private static final String _HELP_COMMAND = "Help";
    private static final String _SIMULATE_HELP_COMMAND = "SimulateHelp";
    private static final String _KEY_HELP = "HELP";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_SHORT_ERROR = "SHORT_ERROR";
    private static final String _KEY_LONG_ERROR = "LONG_ERROR";
    private static final String _KEY_SHORT_ERROR_REASON = "SHORT_ERROR_REASON";
    private static final String _KEY_LONG_ERROR_REASON = "LONG_ERROR_REASON";
    private SelectionModel _selectionModel;
    private PropertyModel _model;
    private Vector _inspectors = new Vector();
    private Hashtable _isPinned = new Hashtable(7);
    private Hashtable _tearOffEditors = new Hashtable(7);
    private Hashtable _propertyIDs = new Hashtable(7);
    private Hashtable _listeners = new Hashtable(7);
    private Object _advancedID;
    private PropertyEditorFactory _advancedFactory;
    private PropertyInspector _advancedInspector;
    private int _tearOffVisibleCount = 0;
    private boolean _inShowAdvancedEditor;
    private CustomDialogHandler _dialogHandler;
    private JDialog _advancedDialog;
    private boolean _ok;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static void showErrorMessage(Object object, PropertyEditorFactory propertyEditorFactory, JTable jTable, Throwable throwable, Object object2) {
        boolean bl;
        Throwable throwable2 = InspectorGroup._getCause(throwable);
        TaskScheduler taskScheduler = new TaskScheduler();
        taskScheduler.setName("Error thread");
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)jTable);
        int n = propertyModel.getPropertyIndex(object);
        String string = propertyModel.getPropertyDisplayName(n, locale);
        String string2 = object2 != null ? object2.toString() : null;
        String string3 = throwable2.getLocalizedMessage();
        if (string3 == null || "".equals(string3)) {
            string3 = throwable2.getMessage();
        }
        boolean bl2 = bl = string3 == null || "".equals(string3);
        String string4 = string2 == null ? (bl ? _KEY_SHORT_ERROR : _KEY_SHORT_ERROR_REASON) : (bl ? _KEY_LONG_ERROR : _KEY_LONG_ERROR_REASON);
        String string5 = InspectorGroup._getTranslatedString(locale, string4);
        MessageFormat messageFormat = new MessageFormat(string5);
        Object[] objectArray = string2 == null ? (bl ? new Object[]{string} : new Object[]{string, string3}) : (bl ? new Object[]{string, string2} : new Object[]{string, string2, string3});
        final String string6 = messageFormat.format(objectArray);
        final JTable jTable2 = jTable;
        taskScheduler.schedule(new Task(){

            public void runTask(TaskEvent taskEvent) {
                JOptionPane.showOptionDialog(jTable2, string6, null, -1, 0, null, null, null);
            }
        }, 100);
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        if (selectionModel != this._selectionModel) {
            this._model = this.createPropertyModel(selectionModel);
        }
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setInspectorPinned(PropertyInspector propertyInspector, boolean bl) {
        boolean bl2 = (Boolean)this._isPinned.get(propertyInspector);
        if (bl != bl2) {
            this._isPinned.put(propertyInspector, bl ? Boolean.TRUE : Boolean.FALSE);
            PropertyModel propertyModel = this.getPropertyModel();
            if (bl) {
                SelectionModel selectionModel = this.getSelectionModel();
                SelectionModel selectionModel2 = selectionModel != null ? selectionModel.copyContents() : null;
                propertyModel = this.createPropertyModel(selectionModel2);
            }
            propertyInspector.setUnderlyingPropertyModel(propertyModel);
        }
    }

    public boolean isInspectorPinned(PropertyInspector propertyInspector) {
        Object v = this._isPinned.get(propertyInspector);
        return v == null ? false : Boolean.TRUE.equals(v);
    }

    public PropertyModel getPropertyModel() {
        return this._model;
    }

    public void showTearOffEditor(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        Object object2;
        Container container = (Container)this._tearOffEditors.get(object);
        if (container != null) {
            object2 = (TearOffListener)this._listeners.remove(container);
            ((TearOffListener)object2).dispose();
        }
        if (container == null) {
            object2 = propertyInspector.getPropertyModel();
            int n = ((PropertyModel)object2).getColumnIndex(PropertyModel.COLUMN_VALUE);
            Object object3 = ((PropertyModel)object2).getPropertyByID(n, object);
            propertyEditorFactory.setEditorValue(object3);
            Component component = propertyEditorFactory.getTearOffEditor();
            SwingUtilities.updateComponentTreeUI(component);
            container = this.createEditorParent(propertyInspector, component);
            container.setLocale(LocaleUtils.getDefaultableLocale((Component)propertyInspector));
            this._tearOffEditors.put(object, container);
            this._propertyIDs.put(container, object);
            this.sizeAndPositionTearOffEditor(container, propertyInspector);
            container.setVisible(true);
        }
        object2 = this.getTearOffTitle(object, propertyEditorFactory, propertyInspector);
        if (container instanceof Frame) {
            ((Frame)container).setTitle((String)object2);
        } else if (container instanceof Dialog) {
            ((Dialog)container).setTitle((String)object2);
        }
        TearOffListener tearOffListener = new TearOffListener(object, propertyEditorFactory, propertyInspector);
        this._listeners.put(container, tearOffListener);
        ++this._tearOffVisibleCount;
        this.sizeAndPositionTearOffEditor(container, propertyInspector);
        this.raiseTearOffEditor(container);
    }

    protected void addInspector(PropertyInspector propertyInspector) {
        if (propertyInspector == null) {
            throw new IllegalArgumentException();
        }
        if (this._inspectors.indexOf(propertyInspector) == -1) {
            this._inspectors.addElement(propertyInspector);
            this._isPinned.put(propertyInspector, Boolean.FALSE);
        }
    }

    protected void removeInspector(PropertyInspector propertyInspector) {
        if (propertyInspector == null) {
            throw new IllegalArgumentException();
        }
        if (this._inspectors.indexOf(propertyInspector) != -1) {
            this._inspectors.removeElement(propertyInspector);
            this._isPinned.remove(propertyInspector);
        }
    }

    protected boolean isHelpDisplayed(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        return false;
    }

    protected PropertyModel createPropertyModel(SelectionModel selectionModel) {
        if (selectionModel != null) {
            MultiObjectModel multiObjectModel = new MultiObjectModel();
            multiObjectModel.setSelectionModel(selectionModel);
            return multiObjectModel;
        }
        return null;
    }

    protected String getAdvancedEditorTitle(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        int n;
        PropertyModel propertyModel = propertyInspector.getPropertyModel();
        Object object2 = propertyModel.getPropertyByID(n = propertyModel.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME), object);
        return object2 == null || object2 == PropertyModel.DOES_NOT_EXIST ? null : object2.toString();
    }

    protected boolean showAdvancedEditor(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        this._ok = true;
        this.showAdvancedEditorDialog(object, propertyEditorFactory, propertyInspector);
        return this._ok;
    }

    protected void showAdvancedEditorDialog(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        if (this._inShowAdvancedEditor) {
            return;
        }
        this._ok = false;
        this._inShowAdvancedEditor = true;
        try {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)propertyInspector);
            Frame frame = WindowUtils.parentFrame((Component)propertyInspector);
            JDialog jDialog = new JDialog(frame, this.getAdvancedEditorTitle(object, propertyEditorFactory, propertyInspector), true);
            PropertyModel propertyModel = propertyInspector.getPropertyModel();
            int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
            Object object2 = propertyModel.getPropertyByID(n, object);
            propertyEditorFactory.setEditorValue(object2);
            Component component = propertyEditorFactory.getAdvancedEditor();
            DialogButtonBar dialogButtonBar = new DialogButtonBar();
            CustomDialogHandler customDialogHandler = new CustomDialogHandler(object, propertyEditorFactory, propertyInspector, component);
            String string = InspectorGroup._getTranslatedString(locale, "OK");
            PushButton pushButton = new PushButton(string);
            pushButton.setActionCommand("OK");
            pushButton.addActionListener(customDialogHandler);
            pushButton.setDefaultCapable(true);
            jDialog.getRootPane().setDefaultButton((JButton)pushButton);
            dialogButtonBar.add((Component)pushButton, DialogButtonBar.CONSTRAINT_YES);
            string = InspectorGroup._getTranslatedString(locale, _KEY_CANCEL);
            PushButton pushButton2 = new PushButton(string);
            pushButton2.addActionListener(customDialogHandler);
            pushButton2.setActionCommand(_CANCEL_COMMAND);
            pushButton2.registerKeyboardAction(customDialogHandler, _CANCEL_COMMAND, KeyStroke.getKeyStroke(27, 0), 2);
            dialogButtonBar.add((Component)pushButton2, DialogButtonBar.CONSTRAINT_CANCEL);
            PushButton pushButton3 = null;
            if (this.isHelpDisplayed(object, propertyEditorFactory, propertyInspector)) {
                String string2 = InspectorGroup._getTranslatedString(locale, _KEY_HELP);
                pushButton3 = new PushButton(StringUtils.stripMnemonic((String)string2));
                pushButton3.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
                pushButton3.setActionCommand(_HELP_COMMAND);
                pushButton3.addActionListener(customDialogHandler);
                pushButton3.registerKeyboardAction(customDialogHandler, _SIMULATE_HELP_COMMAND, KeyStroke.getKeyStroke(112, 0), 2);
                pushButton3.registerKeyboardAction(customDialogHandler, _SIMULATE_HELP_COMMAND, KeyStroke.getKeyStroke(156, 0), 2);
                dialogButtonBar.add((Component)pushButton3, DialogButtonBar.CONSTRAINT_HELP);
            }
            SwingUtilities.updateComponentTreeUI(component);
            jDialog.getContentPane().add("Center", component);
            jDialog.getContentPane().add("South", (Component)dialogButtonBar);
            jDialog.addWindowListener(customDialogHandler);
            jDialog.setLocale(locale);
            jDialog.pack();
            WindowUtils.centerWindow((Window)jDialog, (Component)propertyInspector);
            this._advancedInspector = propertyInspector;
            this._advancedFactory = propertyEditorFactory;
            this._advancedID = object;
            this._dialogHandler = customDialogHandler;
            this._advancedDialog = jDialog;
            ((Component)jDialog).setVisible(true);
            pushButton2.removeActionListener(customDialogHandler);
            pushButton2.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            pushButton.removeActionListener(customDialogHandler);
            if (pushButton3 != null) {
                pushButton3.removeActionListener(customDialogHandler);
                pushButton3.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
                pushButton3.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
            }
            customDialogHandler.dispose();
            this._dialogHandler = null;
            this._advancedDialog = null;
            this._advancedInspector = null;
            this._advancedFactory = null;
            this._advancedID = null;
            Object var19_18 = null;
            this._inShowAdvancedEditor = false;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this._inShowAdvancedEditor = false;
            throw throwable;
        }
    }

    protected void hideAdvancedEditorDialog(boolean bl) {
        if (this._dialogHandler != null && this._advancedDialog != null) {
            this._dialogHandler._dismissDialog(this._advancedDialog, bl);
        }
    }

    protected String getTearOffTitle(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
        int n;
        PropertyModel propertyModel = propertyInspector.getPropertyModel();
        Object object2 = propertyModel.getPropertyByID(n = propertyModel.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME), object);
        return object2 == null || object2 == PropertyModel.DOES_NOT_EXIST ? null : object2.toString();
    }

    protected Container createEditorParent(PropertyInspector propertyInspector, Component component) {
        Frame frame = WindowUtils.parentFrame((Component)propertyInspector);
        JDialog jDialog = new JDialog(frame, false);
        jDialog.addWindowListener(new WindowCloser());
        jDialog.getContentPane().add("Center", component);
        return jDialog;
    }

    protected void disposeEditorParent(Container container) {
        if (container instanceof Window) {
            ((Window)container).dispose();
        }
    }

    protected void sizeAndPositionTearOffEditor(Container container, PropertyInspector propertyInspector) {
        Window window = (Window)container;
        window.pack();
        WindowUtils.centerWindow((Window)window, (Component)propertyInspector);
    }

    protected void raiseTearOffEditor(Container container) {
        if (container instanceof Window) {
            ((Window)container).toFront();
        }
    }

    protected final void closeTearOffEditor(Container container) {
        Object v = this._propertyIDs.remove(container);
        this._tearOffEditors.remove(v);
        TearOffListener tearOffListener = (TearOffListener)this._listeners.remove(container);
        container.setVisible(false);
        this.disposeEditorParent(container);
        tearOffListener.dispose();
        --this._tearOffVisibleCount;
    }

    protected void showErrorMessage(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector, Throwable throwable, Object object2) {
        InspectorGroup.showErrorMessage(object, propertyEditorFactory, propertyInspector.getPropertyTable(), throwable, object2);
    }

    boolean __isAdvancedEditorVisible() {
        return this._advancedInspector != null;
    }

    boolean __isTearOffEditorVisible() {
        return this._tearOffVisibleCount > 0;
    }

    private static String _getTranslatedString(Locale locale, String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle");
        return resourceBundle.getString(string);
    }

    private static Throwable _getCause(Throwable serializable) {
        Serializable serializable2;
        if (!_sMethodInitialized) {
            try {
                serializable2 = class$java$lang$Throwable == null ? (class$java$lang$Throwable = InspectorGroup.class$("java.lang.Throwable")) : class$java$lang$Throwable;
                _sGetCauseMethod = serializable2.getMethod("getCause", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _sMethodInitialized = true;
        }
        if (_sGetCauseMethod != null) {
            try {
                serializable2 = (Throwable)_sGetCauseMethod.invoke((Object)serializable, null);
                if (serializable2 != null) {
                    serializable = serializable2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return serializable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CustomDialogHandler
    extends WindowAdapter
    implements ActionListener {
        private PropertyEditorFactory _editorFactory;
        private Object _editedProperty;
        private PropertyInspector _editingInspector;
        private Component _helpComponent;

        public CustomDialogHandler(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector, Component component) {
            this._editedProperty = object;
            this._editorFactory = propertyEditorFactory;
            this._editingInspector = propertyInspector;
            this._helpComponent = component;
        }

        public void dispose() {
            this._editedProperty = null;
            this._editorFactory = null;
            this._helpComponent = null;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this._dismissDialog(windowEvent.getWindow(), false);
        }

        public void windowClosed(WindowEvent windowEvent) {
            windowEvent.getWindow().removeWindowListener(this);
            this._editingInspector.getPropertyTable().requestFocus();
            this._editingInspector = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("OK".equals(string) || InspectorGroup._CANCEL_COMMAND.equals(string)) {
                this._dismissDialog(WindowUtils.getWindow((Component)((Component)actionEvent.getSource())), string == "OK");
            } else if (InspectorGroup._SIMULATE_HELP_COMMAND.equals(string)) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    ((AbstractButton)actionEvent.getSource()).doClick();
                }
            } else if (InspectorGroup._HELP_COMMAND.equals(string)) {
                try {
                    HelpUtils.showHelp((Component)this._helpComponent);
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        private void _dismissDialog(Window window, boolean bl) {
            InspectorGroup.this._ok = bl;
            ((Component)window).setVisible(false);
            if (bl) {
                PropertyInspector propertyInspector = this._editingInspector;
                PropertyModel propertyModel = propertyInspector.getPropertyModel();
                Object object = this._editedProperty;
                PropertyEditorFactory propertyEditorFactory = this._editorFactory;
                Object object2 = propertyEditorFactory.getEditorValue();
                int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
                TableCellEditor tableCellEditor = propertyInspector.getPropertyTable().getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                SwingUtilities.invokeLater(new Runnable(this, propertyModel, n, object, object2, propertyEditorFactory, propertyInspector){
                    private final /* synthetic */ PropertyModel val$model;
                    private final /* synthetic */ int val$columnIndex;
                    private final /* synthetic */ Object val$property;
                    private final /* synthetic */ Object val$newValue;
                    private final /* synthetic */ PropertyEditorFactory val$factory;
                    private final /* synthetic */ PropertyInspector val$inspector;
                    private final /* synthetic */ CustomDialogHandler this$1;
                    {
                        this.this$1 = customDialogHandler;
                        this.val$model = propertyModel;
                        this.val$columnIndex = n;
                        this.val$property = object;
                        this.val$newValue = object2;
                        this.val$factory = propertyEditorFactory;
                        this.val$inspector = propertyInspector;
                    }

                    public void run() {
                        try {
                            this.val$model.setPropertyByID(this.val$columnIndex, this.val$property, this.val$newValue);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            CustomDialogHandler.access$600(this.this$1).showErrorMessage(this.val$property, this.val$factory, this.val$inspector, throwable, this.val$newValue);
                        }
                    }
                });
            }
            window.dispose();
        }

        static /* synthetic */ InspectorGroup access$600(CustomDialogHandler customDialogHandler) {
            return customDialogHandler.InspectorGroup.this;
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            InspectorGroup.this.closeTearOffEditor(windowEvent.getWindow());
            windowEvent.getWindow().removeWindowListener(this);
        }
    }

    private class TearOffListener
    implements PropertyChangeListener {
        private PropertyEditorFactory _editorFactory;
        private Object _editedProperty;
        private PropertyInspector _editingInspector;

        public TearOffListener(Object object, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
            this._editedProperty = object;
            this._editorFactory = propertyEditorFactory;
            this._editingInspector = propertyInspector;
            this._editorFactory.addPropertyChangeListener(this);
        }

        public void dispose() {
            this._editorFactory.removePropertyChangeListener(this);
            PropertyInspector propertyInspector = this._editingInspector;
            SwingUtilities.invokeLater(new Runnable(this, propertyInspector){
                private final /* synthetic */ PropertyInspector val$pi;
                private final /* synthetic */ TearOffListener this$1;
                {
                    this.this$1 = tearOffListener;
                    this.val$pi = propertyInspector;
                }

                public void run() {
                    this.val$pi.getPropertyTable().requestFocus();
                }
            });
            this._editedProperty = null;
            this._editorFactory = null;
            this._editingInspector = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (InspectorGroup.this._advancedInspector == this._editingInspector && InspectorGroup.this._advancedFactory == this._editorFactory && this._editedProperty == InspectorGroup.this._advancedID) {
                return;
            }
            PropertyModel propertyModel = this._editingInspector.getPropertyModel();
            PropertyEditorFactory propertyEditorFactory = (PropertyEditorFactory)propertyChangeEvent.getSource();
            Object object = propertyEditorFactory.getEditorValue();
            int n = propertyModel.getColumnIndex(PropertyModel.COLUMN_VALUE);
            try {
                TableCellEditor tableCellEditor = this._editingInspector.getPropertyTable().getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                propertyModel.setPropertyByID(n, this._editedProperty, object);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                InspectorGroup.this.showErrorMessage(this._editedProperty, this._editorFactory, this._editingInspector, throwable, object);
            }
        }
    }
}

