/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;

class ColumnModel
extends DefaultTableColumnModel {
    private Hashtable _columnCache = new Hashtable(13);
    private Object[] _visibleColumns = new Object[]{PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE};
    private PropertyModel _model;
    private ColumnSetListener _propertyModelListener = new ColumnSetListener();

    public void setPropertyModel(PropertyModel propertyModel) {
        if (propertyModel != this._model) {
            if (this._model != null) {
                this._model.removeTableModelListener(this._propertyModelListener);
            }
            this._model = propertyModel;
            if (propertyModel != null) {
                this._model.addTableModelListener(this._propertyModelListener);
            }
            this._updateVisibleColumns();
        }
    }

    public void setVisibleColumnIDs(Object[] objectArray) {
        if (!this._equals(this._visibleColumns, objectArray)) {
            this._visibleColumns = objectArray;
            this._updateVisibleColumns();
        }
    }

    public Object[] getVisibleColumnIDs() {
        return this._visibleColumns;
    }

    public TableColumn getTableColumn(Object object) {
        int n = this._model != null ? this._model.getColumnIndex(object) : -1;
        return this._getColumn(object, n);
    }

    private void _updateVisibleColumns() {
        int n = this.getColumnCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.removeColumn(this.getColumn(n2));
            --n2;
        }
        PropertyModel propertyModel = this._model;
        if (propertyModel != null) {
            int n3 = 0;
            while (n3 < this._visibleColumns.length) {
                Object object = this._visibleColumns[n3];
                int n4 = propertyModel.getColumnIndex(object);
                if (n4 != -1) {
                    this.addColumn(this._getColumn(object, n4));
                }
                ++n3;
            }
        }
    }

    private TableColumn _getColumn(Object object, int n) {
        TableColumn tableColumn = (TableColumn)this._columnCache.get(object);
        if (tableColumn == null) {
            tableColumn = new TableColumn(n);
            tableColumn.setIdentifier(object);
            this._columnCache.put(object, tableColumn);
        } else {
            tableColumn.setModelIndex(n);
        }
        return tableColumn;
    }

    private boolean _equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != objectArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private class ColumnSetListener
    implements TableModelListener {
        private ColumnSetListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getFirstRow() == -1) {
                ColumnModel.this._updateVisibleColumns();
            }
        }
    }
}

