/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

class UserDefinedTypeCompiler
extends BaseTypeCompiler {
    UserDefinedTypeCompiler() {
    }

    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        if (this.getTypeId().getBaseTypeId().isAnsiUDT()) {
            if (!typeId.getBaseTypeId().isAnsiUDT()) {
                return false;
            }
            UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
            UserDefinedTypeIdImpl userDefinedTypeIdImpl2 = (UserDefinedTypeIdImpl)typeId.getBaseTypeId();
            return userDefinedTypeIdImpl.getSQLTypeName().equals(userDefinedTypeIdImpl2.getSQLTypeName());
        }
        return true;
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (!typeId.isUserDefinedTypeId()) {
            return false;
        }
        UserDefinedTypeIdImpl userDefinedTypeIdImpl = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
        UserDefinedTypeIdImpl userDefinedTypeIdImpl2 = (UserDefinedTypeIdImpl)typeId.getBaseTypeId();
        if (userDefinedTypeIdImpl.isAnsiUDT() != userDefinedTypeIdImpl2.isAnsiUDT()) {
            return false;
        }
        if (userDefinedTypeIdImpl.isAnsiUDT()) {
            return userDefinedTypeIdImpl.getSQLTypeName().equals(userDefinedTypeIdImpl2.getSQLTypeName());
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), this.getTypeId().getCorrespondingJavaTypeName());
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.UserDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return this.getTypeId().getCorrespondingJavaTypeName();
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return -1;
    }

    @Override
    String nullMethodName() {
        return "getNullObject";
    }

    @Override
    public void generateDataValue(MethodBuilder methodBuilder, int n, LocalField localField) {
        methodBuilder.upCast("java.lang.Object");
        super.generateDataValue(methodBuilder, n, localField);
    }
}

