/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;
import oracle.sqlj.runtime.sqlmonitor.SQLMonitor;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.RuntimeContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.ref.ProfileGroup;

public abstract class ConnectionContextImpl
implements ConnectionContext {
    private ExecutionContext m_execCtx = new ExecutionContext();
    private Hashtable m_savepoints = new Hashtable();
    private static boolean m_hasStatementCache = false;
    private OracleConnection m_oconn;
    public static int STMT_CACHE_NOT_ENABLED;
    public static int STMT_CACHE_EXCEPTION;
    private SQLException m_stmtCacheException;
    private static int m_default_stmt_cache_size;
    private ProfileGroup.ConnectedGroup m_connProfiles;
    private ProfileGroup m_profileGroup;
    private boolean m_isClosed = false;
    private Connection m_conn;
    private static int m_noOpenedContexts;
    static /* synthetic */ Class class$oracle$jdbc$OracleConnection;
    static /* synthetic */ Class class$java$lang$String;

    static boolean hasStatementCache() {
        return m_hasStatementCache;
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, Connection connection) throws SQLException {
        this.initConnectionContext(profileGroup, connection, false);
    }

    private void initConnectionContext(ProfileGroup profileGroup, Connection connection, boolean bl) throws SQLException {
        if (connection == null) {
            RuntimeRefErrors.raise_NULL_CONNECTION();
        }
        this.m_conn = connection;
        this.m_connProfiles = null;
        this.m_profileGroup = profileGroup;
        if (this.m_conn instanceof OracleConnection) {
            this.m_oconn = (OracleConnection)this.m_conn;
            int n = this.getStmtCacheSize();
            if (n == STMT_CACHE_EXCEPTION) {
                throw this.getStmtCacheException();
            }
            if (n == STMT_CACHE_NOT_ENABLED || n < m_default_stmt_cache_size) {
                try {
                    if (bl) {
                        this.setStmtCacheSize(m_default_stmt_cache_size);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        ++m_noOpenedContexts;
    }

    public OracleConnection getOracleConnection() {
        if (this.m_oconn == null) {
            throw new IllegalArgumentException("SQLJ programs translated with the option -codegen=oracle must be run under Oracle JDBC 9.0.0 or higher.  If the Oracle JDBC driver is wrapped, then the wrapper must implement all of the oracle.jdbc.OracleXxxx interfaces. Alternatively, you can translate SQLJ programs either with -codegen=iso.");
        }
        return this.m_oconn;
    }

    public SQLException getStmtCacheException() {
        return this.m_stmtCacheException;
    }

    public int getStmtCacheSize() {
        this.m_stmtCacheException = null;
        if (m_hasStatementCache) {
            try {
                if (this.m_oconn.getExplicitCachingEnabled()) {
                    return this.m_oconn.getStatementCacheSize();
                }
                return STMT_CACHE_NOT_ENABLED;
            }
            catch (SQLException sQLException) {
                this.m_stmtCacheException = sQLException;
                return STMT_CACHE_EXCEPTION;
            }
        }
        return this.m_oconn.getStmtCacheSize();
    }

    public void setStmtCacheSize(int n) throws SQLException {
        int n2 = this.getStmtCacheSize();
        if (n2 == STMT_CACHE_EXCEPTION) {
            throw this.getStmtCacheException();
        }
        if (n2 == STMT_CACHE_NOT_ENABLED) {
            if (n > 0) {
                if (m_hasStatementCache) {
                    this.m_oconn.setExplicitCachingEnabled(true);
                    this.m_oconn.setStatementCacheSize(n);
                } else {
                    this.m_oconn.setStmtCacheSize(n);
                }
            }
        } else if (n2 != n) {
            if (m_hasStatementCache) {
                this.m_oconn.setStatementCacheSize(n);
            } else {
                this.m_oconn.setStmtCacheSize(n);
            }
        }
    }

    public static int getDefaultStmtCacheSize() {
        return m_default_stmt_cache_size;
    }

    public static void setDefaultStmtCacheSize(int n) {
        m_default_stmt_cache_size = n;
    }

    private ConnectionContextImpl(ProfileGroup profileGroup, Connection connection, boolean bl) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.initAutoCommit(connection, bl), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection initAutoCommit(Connection connection, boolean bl) throws SQLException {
        try {
            connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            try {
                if (!connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            finally {
                throw sQLException;
            }
        }
        return connection;
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3, boolean bl) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.initAutoCommit(DriverManager.getConnection(string, string2, string3), bl), true);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, Properties properties, boolean bl) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.initAutoCommit(DriverManager.getConnection(string, properties), bl), true);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, boolean bl) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.initAutoCommit(DriverManager.getConnection(string), bl), true);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, ConnectionContext connectionContext) throws SQLException {
        this.initConnectionContext(profileGroup, connectionContext == null ? null : connectionContext.getConnection(), false);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.getDataSourceConnection(string, null, null), false);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3) throws SQLException {
        this.initConnectionContext(profileGroup, ConnectionContextImpl.getDataSourceConnection(string, string2, string3), false);
    }

    private static Connection getDataSourceConnection(String string, String string2, String string3) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.Context");
            Class<?> clazz2 = Class.forName("javax.sql.DataSource");
            Object obj = Class.forName("javax.naming.InitialContext").newInstance();
            Object object = clazz.getMethod("lookup", class$java$lang$String == null ? (class$java$lang$String = ConnectionContextImpl.class$("java.lang.String")) : class$java$lang$String).invoke(obj, string);
            if (string2 == null) {
                return (Connection)clazz2.getMethod("getConnection", new Class[0]).invoke(object, new Object[0]);
            }
            return (Connection)clazz2.getMethod("getConnection", class$java$lang$String == null ? (class$java$lang$String = ConnectionContextImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConnectionContextImpl.class$("java.lang.String")) : class$java$lang$String).invoke(object, string2, string3);
        }
        catch (Exception exception) {
            RuntimeRefErrors.raise_NULL_DATASOURCE(string, exception.toString());
            return null;
        }
    }

    public ConnectedProfile getConnectedProfile(Object object) throws SQLException {
        if (this.m_connProfiles == null) {
            this.m_connProfiles = this.m_profileGroup.addConnection(this);
            this.m_profileGroup = null;
        }
        return this.m_connProfiles.getProfile(object);
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean bl) throws SQLException {
        block11: {
            this.m_isClosed = true;
            if (this.m_conn != null && !this.m_conn.isClosed()) {
                try {
                    if (this.m_connProfiles != null) {
                        this.m_connProfiles.close();
                    }
                    if (this.m_execCtx != null) {
                        this.m_execCtx.close();
                    }
                    Object var3_2 = null;
                    if (!bl || this.m_conn == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (bl && this.m_conn != null) {
                        this.m_conn.close();
                    }
                    throw throwable;
                }
                this.m_conn.close();
            } else {
                if (this.m_connProfiles != null) {
                    this.m_connProfiles.close();
                }
                if (this.m_execCtx != null) {
                    this.m_execCtx.close();
                }
                if (bl && this.m_conn != null) {
                    RuntimeRefErrors.raise_CLOSED_CONNECTION();
                }
            }
        }
        if (--m_noOpenedContexts == 0) {
            SQLMonitor.dump();
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.m_execCtx;
    }

    public static Properties loadProps(Class clazz, String string) {
        InputStream inputStream;
        Object object;
        if (string == null) {
            return null;
        }
        Loader loader = RuntimeContext.getRuntime().getLoaderForClass(clazz);
        if (!string.startsWith("/")) {
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            object = clazz.getName();
            int n = ((String)object).lastIndexOf(46);
            if (n != -1) {
                string = ((String)object).substring(0, n + 1).replace('.', '/') + string;
            }
        } else {
            string = string.substring(1);
        }
        if ((inputStream = loader.getResourceAsStream(string)) == null) {
            return null;
        }
        object = new Properties();
        try {
            ((Properties)object).load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return object;
    }

    public static Hashtable loadTypeMap(Class clazz, String string) {
        Hashtable<Object, Serializable> hashtable = new Hashtable<Object, Serializable>();
        Loader loader = RuntimeContext.getRuntime().getLoaderForClass(clazz);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            Properties properties;
            ResourceBundle resourceBundle;
            String string2;
            block23: {
                string2 = stringTokenizer.nextToken().trim();
                resourceBundle = null;
                properties = null;
                try {
                    resourceBundle = ResourceBundle.getBundle(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    properties = ConnectionContextImpl.loadProps(clazz, string2);
                    if (properties != null) break block23;
                    try {
                        RuntimeRefErrors.raise_INVALID_TYPEMAP(string2);
                    }
                    catch (Throwable throwable) {
                        throw new ExceptionInInitializerError(throwable);
                    }
                    return null;
                }
            }
            Enumeration<Object> enumeration = resourceBundle == null ? properties.propertyNames() : resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2;
                Object object;
                String string3;
                String string4 = (String)enumeration.nextElement();
                if (resourceBundle == null) {
                    string3 = properties.getProperty(string4);
                } else {
                    try {
                        string3 = (String)resourceBundle.getObject(string4);
                    }
                    catch (Exception exception) {
                        try {
                            RuntimeRefErrors.raise_INVALID_TYPEMAP(string2, exception.toString());
                        }
                        catch (Throwable throwable) {
                            throw new ExceptionInInitializerError(throwable);
                        }
                        return null;
                    }
                }
                if (string4.startsWith("class.")) {
                    Class clazz2;
                    string4 = string4.substring(6);
                    try {
                        clazz2 = loader.loadClass(string4);
                    }
                    catch (Exception exception) {
                        try {
                            RuntimeRefErrors.raise_INVALID_TYPEMAP(string2, exception.toString());
                        }
                        catch (Throwable throwable) {
                            throw new ExceptionInInitializerError(throwable);
                        }
                        return null;
                    }
                    object = new StringTokenizer(string3);
                    hashtable2 = ((StringTokenizer)object).nextToken();
                    if (((String)((Object)hashtable2)).equalsIgnoreCase("STRUCT")) {
                        string3 = string3.substring(6).trim();
                    } else if (((String)((Object)hashtable2)).equalsIgnoreCase("DISTINCT")) {
                        string3 = string3.substring(8).trim();
                    } else if (((String)((Object)hashtable2)).equalsIgnoreCase("JAVA_OBJECT")) {
                        string3 = string3.substring(11).trim();
                    }
                    hashtable.put(string3, clazz2);
                    continue;
                }
                int n = string4.indexOf(".");
                object = string4.substring(0, n);
                string4 = string4.substring(n + 1);
                hashtable2 = (Hashtable)hashtable.get(object);
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable();
                    hashtable.put(object, hashtable2);
                }
                hashtable2.put(string4, string3);
            }
        }
        return hashtable;
    }

    public void setSavepoint(String string, Object object) {
        this.m_savepoints.put(string, object);
    }

    public Object getSavepoint(String string) {
        return this.m_savepoints.get(string);
    }

    public Object releaseSavepoint(String string) {
        return this.m_savepoints.remove(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            m_hasStatementCache = (class$oracle$jdbc$OracleConnection == null ? (class$oracle$jdbc$OracleConnection = ConnectionContextImpl.class$("oracle.jdbc.OracleConnection")) : class$oracle$jdbc$OracleConnection).getMethod("getStatementCacheSize", new Class[0]) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        STMT_CACHE_NOT_ENABLED = -1;
        STMT_CACHE_EXCEPTION = -9;
        m_default_stmt_cache_size = 5;
        m_noOpenedContexts = 0;
    }
}

