/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime.error;

import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sqlj.runtime.error.Errors;

public class OraCustomizationErrors
extends Errors {
    private static final String RESOURCE_NAME = "oracle.sqlj.runtime.error.OraCustomizationErrorsText";
    private static ResourceBundle m_bundle = null;
    static final String INVALID_ITERATOR = "ORT-0002";
    public static final String INVALID_COLUMN_NAME = "ORT-0004";
    public static final String MISSING_CONNECT_KEY = "ORT-0006";
    public static final String CANNOT_LOAD_CONNECT_PROPS = "ORT-0007";
    public static final String ONLY_FETCH_FORWARD_SUPPORTED = "ORT-0008";
    public static final String INVALID_SQL_SERIALIZATION_TYPE = "ORT-0010";
    public static final String NO_BLOB_STREAMING = "ORT-0011";

    public static void raise_INVALID_COLUMN_NAME(String columnName) throws SQLException {
        OraCustomizationErrors.raiseError(null, m_bundle, INVALID_COLUMN_NAME);
    }

    public static void raise_MISSING_CONNECT_KEY(String keyName) throws SQLException {
        OraCustomizationErrors.raiseError(null, m_bundle, MISSING_CONNECT_KEY, keyName);
    }

    public static void raise_CANNOT_LOAD_CONNECT_PROPS(String propName) throws SQLException {
        OraCustomizationErrors.raiseError("08000", m_bundle, CANNOT_LOAD_CONNECT_PROPS, propName);
    }

    public static void raise_ONLY_FETCH_FORWARD_SUPPORTED() throws SQLException {
        OraCustomizationErrors.raiseError("46110", m_bundle, ONLY_FETCH_FORWARD_SUPPORTED);
    }

    public static void raise_INVALID_SQL_SERIALIZATION_TYPE(int type) throws SQLException {
        OraCustomizationErrors.raiseError("08000", m_bundle, INVALID_SQL_SERIALIZATION_TYPE, Integer.toString(type));
    }

    public static void raise_NO_BLOB_STREAMING() throws SQLException {
        OraCustomizationErrors.raiseError("46110", m_bundle, NO_BLOB_STREAMING);
    }

    static {
        try {
            m_bundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

