/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.sqlj.runtime.OraTypeClosureImpl;
import sqlj.runtime.error.ProfileRefErrors;

public abstract class OraDynamicClosure
extends OraTypeClosureImpl {
    protected static final Class INT_CLASS = Integer.TYPE;
    private static final String newPack = "oracle.jdbc.";
    private static final String oldPack = "oracle.jdbc.driver.";
    private static final String jdbcPack = "java.sql.";
    public static final Class RESULT_SET_CLASS = OraDynamicClosure.getClass("ResultSet");
    public static final Class STMT_CLASS = OraDynamicClosure.getClass("Statement");
    public static final Class PREPARED_STMT_CLASS = OraDynamicClosure.getClass("PreparedStatement");
    public static final Class CALLABLE_STMT_CLASS = OraDynamicClosure.getClass("CallableStatement");
    public static final Class CONNECTION_CLASS = OraDynamicClosure.getClass("Connection");
    protected static final Class TYPES_CLASS = OraDynamicClosure.getClass("Types");
    protected static final Class[] GET_PARAMS = new Class[]{INT_CLASS};
    public static final Object[] NO_ARGS = new Object[0];
    protected static final Class[] NO_PARAMS = new Class[0];
    private static final int INT_MAP_SIZE = 32;
    private static final Integer[] INT_MAP = new Integer[32];
    private static final Boolean TRUE;
    private static final Boolean FALSE;
    static /* synthetic */ Class class$java$lang$String;

    private static Class getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.jdbc.Oracle" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("oracle.jdbc.driver.Oracle" + string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    clazz = Class.forName(jdbcPack + string);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    throw new ExceptionInInitializerError("No JDBC API found: " + classNotFoundException3);
                }
            }
        }
        return clazz;
    }

    public static Integer toInteger(int n) {
        return n < 32 && 0 <= n ? INT_MAP[n] : new Integer(n);
    }

    public static final Boolean toBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static String baseName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static int getSQLType(String string) {
        try {
            return TYPES_CLASS.getField(string).getInt(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldError(noSuchFieldException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
    }

    public static Class classForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    public static Method getMethodRecurse(Class clazz, String string, Class[] classArray) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodError(string);
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) throws SQLException {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            ProfileRefErrors.raise_EXCEPTION_IN_METHOD(method.toString(), throwable);
            return null;
        }
    }

    public static Object invokeStaticRecurse(Class clazz, String string, Class[] classArray, Object[] objectArray) throws SQLException {
        return OraDynamicClosure.invoke(OraDynamicClosure.getMethodRecurse(clazz, string, classArray), null, objectArray);
    }

    public static Method getMethodInstance(Class clazz, String string, Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Method getMethodInstance(String string, String string2, Class[] classArray) {
        try {
            Class<?> clazz = Class.forName(string);
            return OraDynamicClosure.getMethodInstance(clazz, string2, classArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static Class[] getParams(String[] stringArray) {
        Class[] classArray = new Class[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = stringArray[i].equals("int") ? Integer.TYPE : (stringArray[i].equals("String") ? (class$java$lang$String == null ? OraDynamicClosure.class$("java.lang.String") : class$java$lang$String) : Class.forName(stringArray[i]));
            }
            return classArray;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < 32; ++i) {
            OraDynamicClosure.INT_MAP[i] = new Integer(i);
        }
        TRUE = new Boolean(true);
        FALSE = new Boolean(false);
    }
}

