/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.sqlj.runtime.OraClosureFactory;
import oracle.sqlj.runtime.OraConsts;
import oracle.sqlj.runtime.OraProfile;
import oracle.sqlj.runtime.OraProfileData;
import oracle.sqlj.runtime.OraTypeClosure;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ref.CachedDynamicProfile;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.ParamRegProfile;
import sqlj.runtime.profile.ref.StatementCacheCustomization;
import sqlj.runtime.profile.ref.TransactionControlProfile;
import sqlj.runtime.profile.ref.UntypedSelectProfile;

public class OraCustomization
implements Customization,
OraConsts {
    private OraProfileData m_oraCustomData;
    private int m_version;
    private boolean m_isNativeSQL;
    private int m_cacheSize;
    static final long serialVersionUID = 5740130550701849285L;

    public OraCustomization(OraProfileData oraProfileData, int n, boolean bl, int n2) {
        this.m_oraCustomData = oraProfileData;
        this.m_version = n;
        this.m_isNativeSQL = bl;
        this.m_cacheSize = n2;
    }

    public boolean isNativeSQL() {
        return this.m_isNativeSQL;
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public int getVersion() {
        return this.m_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acceptsConnection(Connection connection) {
        try {
            Loader loader = this.m_oraCustomData.getProfileData().getProfile().getLoader();
            Class clazz = loader.loadClass("oracle.jdbc.OracleConnection");
            if (clazz.isAssignableFrom(connection.getClass())) {
                return true;
            }
            clazz = loader.loadClass("oracle.jdbc.OracleConnection");
            if (clazz.isAssignableFrom(connection.getClass())) {
                return true;
            }
            if (!connection.getMetaData().getDriverName().startsWith("Oracle JDBC")) return false;
            Statement statement = null;
            try {
                statement = connection.createStatement();
                if (loader.loadClass("oracle.jdbc.OracleStatement").isAssignableFrom(statement.getClass())) {
                    boolean bl = true;
                    return bl;
                }
                if (!loader.loadClass("oracle.jdbc.OracleStatement").isAssignableFrom(statement.getClass())) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public ConnectedProfile getProfile(ConnectionContext connectionContext, Profile profile) throws SQLException {
        return new OraStatementCache(this.m_cacheSize).getProfile(connectionContext, profile);
    }

    public ConnectedProfile getProfile(ConnectionContext connectionContext, OraProfileData oraProfileData) throws SQLException {
        return this.getCachedProfile(connectionContext, oraProfileData);
    }

    public CachedStatementProfile getCachedProfile(ConnectionContext connectionContext, OraProfileData oraProfileData) throws SQLException {
        OraTypeClosure[] oraTypeClosureArray = OraClosureFactory.FACTORY.getTypeClosures(connectionContext.getConnection().getMetaData());
        CachedDynamicProfile cachedDynamicProfile = new OraProfile(connectionContext, oraProfileData, oraTypeClosureArray, this.isNativeSQL());
        cachedDynamicProfile = new UntypedSelectProfile(cachedDynamicProfile);
        CachedStatementProfile cachedStatementProfile = cachedDynamicProfile = new ParamRegProfile(cachedDynamicProfile);
        cachedStatementProfile = new TransactionControlProfile(cachedStatementProfile);
        return cachedStatementProfile;
    }

    public String toString() {
        return "OracleCustomization { version=" + this.getVersion() + "; cache size " + this.getCacheSize() + "; native SQL " + (this.isNativeSQL() ? "enabled" : "disabled") + " }";
    }

    static class OraClientDataSupport
    implements sqlj.runtime.profile.ref.ClientDataSupport {
        ClientDataSupport m_conn;

        OraClientDataSupport(Connection connection) {
            this.m_conn = (ClientDataSupport)connection;
        }

        public Object getClientData(Object object) {
            return this.m_conn.getClientData(object);
        }

        public Object setClientData(Object object, Object object2) {
            return this.m_conn.setClientData(object, object2);
        }

        public Object removeClientData(Object object) {
            return this.m_conn.removeClientData(object);
        }
    }

    private class OraStatementCache
    extends StatementCacheCustomization {
        OraStatementCache(int n) {
            super(n);
        }

        protected CachedStatementProfile createCachedStatementProfile(sqlj.runtime.profile.ref.ClientDataSupport clientDataSupport, ConnectionContext connectionContext, Profile profile) throws SQLException {
            return OraCustomization.this.getCachedProfile(connectionContext, OraCustomization.this.m_oraCustomData);
        }

        protected sqlj.runtime.profile.ref.ClientDataSupport getClientDataSupport(Connection connection) {
            if (connection instanceof sqlj.runtime.profile.ref.ClientDataSupport) {
                return (sqlj.runtime.profile.ref.ClientDataSupport)((Object)connection);
            }
            if (connection instanceof ClientDataSupport) {
                return new OraClientDataSupport(connection);
            }
            return null;
        }
    }
}

