/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jpub.reflect.RClass;
import oracle.jpub.reflect.RMethod;
import oracle.jpub.reflect.RObject;
import oracle.jpub.reflect.ServerSideException;
import oracle.sqlj.runtime.Oracle;
import sqlj.runtime.ref.DefaultContext;

public class Client {
    private static Boolean sysPriv = null;
    static /* synthetic */ Class class$oracle$jpub$reflect$Client;

    private Client() {
    }

    public static Object invoke(Connection conn, String klass, String name, Class[] sig, Object[] args) throws Throwable {
        return Client.invoke(conn, null, klass, name, sig, args);
    }

    public static Object invoke(Connection conn, Long handle, String klass, String name, Class[] sig, Object[] args) throws Throwable {
        DefaultContext ctx = new DefaultContext(conn);
        Object ret = Client.invoke(ctx, handle, klass, name, sig, args);
        ctx.close(false);
        return ret;
    }

    public static Object invoke(DefaultContext ctx, String klass, String name, Class[] sig, Object[] args) throws Throwable {
        return Client.invoke(ctx, null, klass, name, sig, args);
    }

    public static Object invoke(DefaultContext ctx, Long handle, String klass, String name, Class[] sig, Object[] args) throws Throwable {
        return Client.invoke(ctx, handle, klass, name, Client.getSignature(sig), args);
    }

    public static Object invoke(Connection conn, Long handle, String klass, String name, String sig, Object[] args) throws Throwable {
        DefaultContext ctx = new DefaultContext(conn);
        Object ret = Client.invoke(ctx, handle, klass, name, sig, args);
        ctx.close(false);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public static Object invoke(DefaultContext ctx, Long handle, String klass, String name, String sig, Object[] args) throws Throwable {
        try {
            void var7_20;
            Object o;
            block39: {
                byte[] ca;
                CallableStatement stmt;
                byte[] ba;
                block40: {
                    block37: {
                        ba = Client.serialize(args);
                        if (sysPriv == null) {
                            sysPriv = Boolean.FALSE;
                            ResultSet rs = null;
                            Statement stmt2 = null;
                            stmt2 = ctx.getConnection().createStatement();
                            rs = stmt2.executeQuery("select count(*) into :tmp from java$policy$");
                            rs.next();
                            rs.getInt(1);
                            sysPriv = Boolean.TRUE;
                            Object var12_12 = null;
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            try {
                                if (stmt2 != null) {
                                    stmt2.close();
                                }
                                break block37;
                            }
                            catch (Exception e2) {}
                            break block37;
                            {
                                catch (Exception e) {
                                    Object var12_13 = null;
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                    try {
                                        if (stmt2 != null) {
                                            stmt2.close();
                                        }
                                        break block37;
                                    }
                                    catch (Exception e2) {}
                                }
                            }
                            catch (Throwable throwable) {
                                Object var12_14 = null;
                                try {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                                try {
                                    if (stmt2 != null) {
                                        stmt2.close();
                                    }
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    }
                    if (sysPriv.booleanValue()) {
                        throw new SQLException("Cannot invoke a stored procedure with SYS privileges");
                    }
                    if (handle != null) break block40;
                    stmt = null;
                    try {
                        stmt = ctx.getConnection().prepareCall("BEGIN :1 := SYS.SQLJUTL2.INVOKE(:2, :3, :4, :5); END;");
                        stmt.setString(2, klass);
                        stmt.setString(3, name);
                        stmt.setString(4, sig);
                        stmt.setBytes(5, ba);
                        stmt.registerOutParameter(1, -3);
                        stmt.executeUpdate();
                        ca = stmt.getBytes(1);
                        Object var15_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_22 = null;
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception _) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block39;
                    }
                    catch (Exception _) {}
                    break block39;
                }
                stmt = null;
                try {
                    stmt = ctx.getConnection().prepareCall("BEGIN :1 := SYS.SQLJUTL2.INVOKE(:2, :3, :4, :5, :6); END;");
                    stmt.setLong(2, (long)handle);
                    stmt.setString(3, klass);
                    stmt.setString(4, name);
                    stmt.setString(5, sig);
                    stmt.setBytes(6, ba);
                    stmt.registerOutParameter(1, -3);
                    stmt.executeUpdate();
                    ca = stmt.getBytes(1);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            if ((o = Client.deserialize((byte[])var7_20)) instanceof ServerSideException) {
                throw ((ServerSideException)o).getCause();
            }
            return o;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SQLException(ioe.toString());
        }
        catch (ClassNotFoundException cnf) {
            cnf.printStackTrace();
            throw new SQLException(cnf.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static Object evaluate(DefaultContext ctx, RObject ro) throws SQLException, InvocationTargetException {
        try {
            byte[] ba = Client.serialize(ro);
            Connection conn = ctx.getConnection();
            CallableStatement stmt = conn.prepareCall("BEGIN :1 := SYS.SQLJUTL2.EVALUATE(:2); END;");
            stmt.setBytes(2, ba);
            stmt.registerOutParameter(1, -3);
            stmt.executeUpdate();
            byte[] ca = stmt.getBytes(1);
            stmt.close();
            Object o = Client.deserialize(ca);
            if (o instanceof Exception) {
                throw new InvocationTargetException((Exception)o);
            }
            return o;
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.toString());
        }
        catch (ClassNotFoundException cnf) {
            throw new SQLException(cnf.toString());
        }
    }

    public static String getSignature(RClass[] ca) throws ClassNotFoundException {
        if (ca == null || ca.length == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < ca.length; ++i) {
            res.append(ca[i].getInternalName());
        }
        return res.toString();
    }

    public static String getSignature(Class[] ca) {
        if (ca == null || ca.length == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < ca.length; ++i) {
            Class<?> c;
            for (c = ca[i]; c != null && c.isArray(); c = c.getComponentType()) {
                res.append("[");
            }
            if (c == null || c == Void.TYPE) {
                res.append('V');
                continue;
            }
            if (c == Boolean.TYPE) {
                res.append('Z');
                continue;
            }
            if (c == Byte.TYPE) {
                res.append('B');
                continue;
            }
            if (c == Short.TYPE) {
                res.append('S');
                continue;
            }
            if (c == Integer.TYPE) {
                res.append('I');
                continue;
            }
            if (c == Long.TYPE) {
                res.append('J');
                continue;
            }
            if (c == Double.TYPE) {
                res.append('D');
                continue;
            }
            if (c == Float.TYPE) {
                res.append('F');
                continue;
            }
            res.append('L');
            res.append(c.getName().replace('.', '/'));
            res.append(';');
        }
        return res.toString();
    }

    public static String getSignature(String[] ca) {
        if (ca == null || ca.length == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < ca.length; ++i) {
            String c;
            for (c = ca[i]; c != null && c.endsWith("[]"); c = c.substring(0, c.length() - 2)) {
                res.append("[");
            }
            if (c != null && c.startsWith("[")) {
                res.append(c);
                continue;
            }
            if (c == null || c.equals("void") || c.equals("Void")) {
                res.append('V');
                continue;
            }
            if (c.equals("boolean")) {
                res.append('Z');
                continue;
            }
            if (c.equals("byte")) {
                res.append('B');
                continue;
            }
            if (c.equals("short")) {
                res.append('S');
                continue;
            }
            if (c.equals("int")) {
                res.append('I');
                continue;
            }
            if (c.equals("long")) {
                res.append('J');
                continue;
            }
            if (c.equals("double")) {
                res.append('D');
                continue;
            }
            if (c.equals("float")) {
                res.append('F');
                continue;
            }
            res.append('L');
            res.append(c.replace('.', '/'));
            res.append(';');
        }
        return res.toString();
    }

    static Object deserialize(byte[] ba) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ba));
        Object res = ois.readObject();
        ois.close();
        return res;
    }

    static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        byte[] ba = bos.toByteArray();
        return ba;
    }

    public static void main(String[] argv) throws SQLException, Throwable {
        RClass c;
        if (!Client.debug_internal()) {
            return;
        }
        DefaultContext ctx = Oracle.getConnection("jdbc:oracle:oci:@", "scott", "tiger");
        System.out.println("*** Test1: Invoking through the SQLJUTL2.INVOKE method.");
        String klass = "oracle.sqlj.checker.JdbcVersion";
        String method = "to_string";
        Class[] sig = new Class[]{};
        String sigString = Client.getSignature(sig);
        Object[] args = new Object[]{};
        Object o = null;
        try {
            o = Client.invoke(ctx, klass, method, sig, args);
        }
        catch (Exception e) {
            o = e;
        }
        System.out.println("Invoking " + method + " returns " + o);
        System.out.println("*** Test2: Invoking through the SQLJUTL2.EVALUATE method.");
        RObject ro = new RObject(ctx, klass, method, sigString, args, null, false);
        try {
            o = Client.evaluate(ctx, ro);
        }
        catch (Exception e) {
            o = e;
        }
        System.out.println("Invoking " + klass + "." + method + "(" + sigString + ")  returns " + o);
        System.out.println("*** Test3: Multiple invocations through SQLJUTL2.EVALUATE method.");
        klass = "sqlj.mesg.JavaVersion";
        ro = new RObject(ctx, new RObject[]{new RObject(ctx, klass, "getJavaVersion", sigString, args, null, false), new RObject(ctx, klass, "getJavaVersionName", sigString, args, null, false), new RObject(ctx, klass, "getRecommendedRuntimeZip", sigString, args, null, false), new RObject(ctx, klass, "getVersion", sigString, args, null, false), new RObject(ctx, klass, "isEnterpriseEdition", sigString, args, null, false), new RObject(ctx, klass, "isJava20", sigString, args, null, false), new RObject(ctx, klass, "isSqlj20", sigString, args, null, false), new RObject(ctx, klass, "NoSuchMethod", sigString, args, null, false), new RObject(ctx, "NoSuchClass", "getName", sigString, args, null, false)});
        Object[] oa = null;
        try {
            o = Client.evaluate(ctx, ro);
            oa = (Object[])o;
        }
        catch (InvocationTargetException e) {
            o = e.getTargetException();
            System.out.println("TARGET EXCEPTION: " + o);
        }
        catch (Throwable t) {
            o = t;
        }
        if (oa == null) {
            System.out.println("Invoking " + klass + " and various methods returns " + o);
        } else {
            for (int i = 0; i < oa.length; ++i) {
                System.out.println("oa[" + i + "] = " + oa[i] + "  [type is: " + (oa[i] == null ? "N/A" : oa[i].getClass().getName()) + "]");
            }
        }
        System.out.println("*** Test4: Invocation using reflection.");
        try {
            c = RClass.forName(ctx, "oracle.sqlj.checker.JdbcVersion");
            RMethod m = c.getMethod("to_string", new Class[0]);
            RObject r = m.invoke(null, new Object[0]);
            o = r.evaluate();
            System.out.println("Result is: " + o);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.out.println("Results in error: " + t);
        }
        System.out.println("*** Test5: Check getSignature.");
        try {
            c = RClass.forName(ctx, "oracle.sqlj.checker.JdbcVersion");
            System.out.println("Signagure with RClass[]: " + Client.getSignature(new RClass[]{c}));
            String tmp = null;
            tmp = Client.getSignature(new Class[]{Integer.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Byte.TYPE, Void.TYPE, Short.TYPE, new String[0].getClass(), class$oracle$jpub$reflect$Client == null ? (class$oracle$jpub$reflect$Client = Client.class$("oracle.jpub.reflect.Client")) : class$oracle$jpub$reflect$Client});
            System.out.println("Signature with Class[]: " + tmp);
            tmp = Client.getSignature(new String[]{"String", "Void", "[String", "boolean", "long", "double", "float", "byte", "void", "short", "String[]", "oracle.jpub.reflect.Client"});
            System.out.println("Signagure with String[]: " + tmp);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.out.println("Results in error: " + t);
        }
        ctx.close();
    }

    private static boolean debug_internal() {
        return System.getProperty("jpub.debug.internal") != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

