/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.OperationData;

public abstract class AbstractBatchOperation
extends AbstractOperation {
    private static final BigInteger EMPTY_IGNORE_MAPPING = new BigInteger("0");
    protected boolean _reverseRowOrder = false;

    static ITableMetaData getOperationMetaData(IDatabaseConnection connection, ITableMetaData metaData) throws DatabaseUnitException, SQLException {
        IDataSet databaseDataSet = connection.createDataSet();
        String tableName = metaData.getTableName();
        ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
        Column[] databaseColumns = databaseMetaData.getColumns();
        Column[] columns = metaData.getColumns();
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (int j = 0; j < columns.length; ++j) {
            String columnName = columns[j].getColumnName();
            Column column = DataSetUtils.getColumn(columnName, databaseColumns);
            if (column == null) {
                throw new NoSuchColumnException(tableName + "." + columnName);
            }
            columnList.add(column);
        }
        return new DefaultTableMetaData(databaseMetaData.getTableName(), columnList.toArray(new Column[0]), databaseMetaData.getPrimaryKeys());
    }

    static boolean isEmpty(ITable table) throws DataSetException {
        Column[] columns = table.getTableMetaData().getColumns();
        if (columns.length == 0) {
            return true;
        }
        try {
            table.getValue(0, columns[0].getColumnName());
            return false;
        }
        catch (RowOutOfBoundsException e) {
            return true;
        }
    }

    protected ITableIterator iterator(IDataSet dataSet) throws DatabaseUnitException {
        return dataSet.iterator();
    }

    BigInteger getIngnoreMapping(ITable table, int row) throws DataSetException {
        return EMPTY_IGNORE_MAPPING;
    }

    boolean equalsIgnoreMapping(BigInteger ignoreMapping, ITable table, int row) throws DataSetException {
        return true;
    }

    abstract OperationData getOperationData(ITableMetaData var1, BigInteger var2, IDatabaseConnection var3) throws DataSetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        DatabaseConfig databaseConfig = connection.getConfig();
        IStatementFactory factory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
        ITableIterator iterator = this.iterator(dataSet);
        while (iterator.next()) {
            ITable table = iterator.getTable();
            if (AbstractBatchOperation.isEmpty(table)) continue;
            ITableMetaData metaData = AbstractBatchOperation.getOperationMetaData(connection, table.getTableMetaData());
            BigInteger ignoreMapping = null;
            OperationData operationData = null;
            IPreparedBatchStatement statement = null;
            try {
                int start = this._reverseRowOrder ? table.getRowCount() - 1 : 0;
                int increment = this._reverseRowOrder ? -1 : 1;
                try {
                    int i = start;
                    while (true) {
                        int row = i;
                        if (ignoreMapping == null || !this.equalsIgnoreMapping(ignoreMapping, table, row)) {
                            if (statement != null) {
                                statement.executeBatch();
                                statement.clearBatch();
                                statement.close();
                            }
                            ignoreMapping = this.getIngnoreMapping(table, row);
                            operationData = this.getOperationData(metaData, ignoreMapping, connection);
                            statement = factory.createPreparedBatchStatement(operationData.getSql(), connection);
                        }
                        Column[] columns = operationData.getColumns();
                        for (int j = 0; j < columns.length; ++j) {
                            if (ignoreMapping.testBit(j)) continue;
                            Column column = columns[j];
                            statement.addValue(table.getValue(row, column.getColumnName()), column.getDataType());
                        }
                        statement.addBatch();
                        i += increment;
                    }
                }
                catch (RowOutOfBoundsException e) {
                    statement.executeBatch();
                    statement.clearBatch();
                    statement.close();
                }
            }
            catch (Throwable throwable) {
                statement.close();
                throw throwable;
            }
        }
    }
}

