/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class FlatDtdProducer
implements IDataSetProducer,
EntityResolver,
DeclHandler,
LexicalHandler {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String XML_CONTENT = "<?xml version=\"1.0\"?><!DOCTYPE dataset SYSTEM \"urn:/dummy.dtd\"><dataset/>";
    private static final String DECL_HANDLER_PROPERTY_NAME = "http://xml.org/sax/properties/declaration-handler";
    private static final String LEXICAL_HANDLER_PROPERTY_NAME = "http://xml.org/sax/properties/lexical-handler";
    private static final String REQUIRED = "#REQUIRED";
    private static final String IMPLIED = "#IMPLIED";
    private InputSource _inputSource;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private String _rootName;
    private String _rootModel;
    private final Map _columnListMap = new HashMap();

    public FlatDtdProducer() {
    }

    public FlatDtdProducer(InputSource inputSource) {
        this._inputSource = inputSource;
    }

    public static void setDeclHandler(XMLReader xmlReader, DeclHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        xmlReader.setProperty(DECL_HANDLER_PROPERTY_NAME, handler);
    }

    public static void setLexicalHandler(XMLReader xmlReader, LexicalHandler handler) throws SAXNotRecognizedException, SAXNotSupportedException {
        xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY_NAME, handler);
    }

    private List createColumnList() {
        return new LinkedList();
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            FlatDtdProducer.setDeclHandler(xmlReader, this);
            FlatDtdProducer.setLexicalHandler(xmlReader, this);
            xmlReader.setEntityResolver(this);
            xmlReader.parse(new InputSource(new StringReader(XML_CONTENT)));
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            Exception exception = e.getException() == null ? e : e.getException();
            throw new DataSetException(exception);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return this._inputSource;
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (name.equals(this._rootName)) {
            this._rootModel = model;
        } else if (!this._columnListMap.containsKey(name)) {
            this._columnListMap.put(name, this.createColumnList());
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String value) throws SAXException {
        Column.Nullable nullable = REQUIRED.equals(mode) ? Column.NO_NULLS : Column.NULLABLE;
        Column column = new Column(attributeName, DataType.UNKNOWN, nullable);
        if (!this._columnListMap.containsKey(elementName)) {
            this._columnListMap.put(elementName, this.createColumnList());
        }
        List columnList = (List)this._columnListMap.get(elementName);
        columnList.add(column);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this._rootName = name;
            this._consumer.startDataSet();
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    public void endDTD() throws SAXException {
        try {
            if (this._rootModel != null) {
                String rootModel = this._rootModel.substring(1, this._rootModel.length() - 1);
                String delim = rootModel.indexOf(",") != -1 ? "," : "|";
                StringTokenizer tokenizer = new StringTokenizer(rootModel, delim);
                while (tokenizer.hasMoreTokens()) {
                    String tableName = tokenizer.nextToken();
                    if (tableName.endsWith("*") || tableName.endsWith("?") || tableName.endsWith("+")) {
                        tableName = tableName.substring(0, tableName.length() - 1);
                    }
                    List columnList = (List)this._columnListMap.get(tableName);
                    Column[] columns = columnList.toArray(new Column[0]);
                    this._consumer.startTable(new DefaultTableMetaData(tableName, columns));
                    this._consumer.endTable();
                }
            }
            this._consumer.endDataSet();
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

