/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.excel;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;

class XlsTable
extends AbstractTable {
    private final ITableMetaData _metaData;
    private final HSSFSheet _sheet;

    public XlsTable(String sheetName, HSSFSheet sheet) throws DataSetException {
        int rowCount = sheet.getLastRowNum();
        this._metaData = rowCount > 0 ? XlsTable.createMetaData(sheetName, sheet.getRow(0)) : new DefaultTableMetaData(sheetName, new Column[0]);
        this._sheet = sheet;
    }

    static ITableMetaData createMetaData(String tableName, HSSFRow sampleRow) {
        HSSFCell cell;
        ArrayList<Column> columnList = new ArrayList<Column>();
        int i = 0;
        while ((cell = sampleRow.getCell((short)i)) != null) {
            Column column = new Column(cell.getStringCellValue(), DataType.UNKNOWN);
            columnList.add(column);
            ++i;
        }
        Column[] columns = columnList.toArray(new Column[0]);
        return new DefaultTableMetaData(tableName, columns);
    }

    public int getRowCount() {
        return this._sheet.getLastRowNum();
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public Object getValue(int row, String column) throws DataSetException {
        this.assertValidRowIndex(row);
        int columnIndex = this.getColumnIndex(column);
        HSSFCell cell = this._sheet.getRow(row + 1).getCell((short)columnIndex);
        if (cell == null) {
            return null;
        }
        int type = cell.getCellType();
        switch (type) {
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    return cell.getDateCellValue();
                }
                return new BigDecimal(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                throw new DataTypeException("Formula not supported at row=" + row + ", column=" + column);
            }
            case 3: {
                return null;
            }
            case 4: {
                return cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                throw new DataTypeException("Error at row=" + row + ", column=" + column);
            }
        }
        throw new DataTypeException("Unsupported type at row=" + row + ", column=" + column);
    }
}

