/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.Base64;

public class StringDataType
extends AbstractDataType {
    static /* synthetic */ Class class$java$lang$String;

    public StringDataType(String name, int sqlType) {
        super(name, sqlType, class$java$lang$String == null ? (class$java$lang$String = StringDataType.class$("java.lang.String")) : class$java$lang$String, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Number) {
            try {
                return value.toString();
            }
            catch (NumberFormatException e) {
                throw new TypeCastException(e);
            }
        }
        if (value instanceof byte[]) {
            return Base64.encodeBytes((byte[])value);
        }
        if (value instanceof Blob) {
            try {
                Blob blob = (Blob)value;
                byte[] blobValue = blob.getBytes(1L, (int)blob.length());
                return this.typeCast(blobValue);
            }
            catch (SQLException e) {
                throw new TypeCastException(e);
            }
        }
        if (value instanceof Clob) {
            try {
                Clob clobValue = (Clob)value;
                int length = (int)clobValue.length();
                if (length > 0) {
                    return clobValue.getSubString(1L, length);
                }
                return "";
            }
            catch (SQLException e) {
                throw new TypeCastException(e);
            }
        }
        throw new TypeCastException(value.toString());
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setString(column, DataType.asString(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

