/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;

public class CompositeDataSet
extends AbstractDataSet {
    private ITable[] _tables;

    public CompositeDataSet(IDataSet[] dataSets) throws DataSetException {
        this(dataSets, true);
    }

    public CompositeDataSet(IDataSet[] dataSets, boolean combine) throws DataSetException {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        for (int i = 0; i < dataSets.length; ++i) {
            ITable[] tables = DataSetUtils.getTables(dataSets[i]);
            for (int j = 0; j < tables.length; ++j) {
                ITable table = tables[j];
                tableList.add(table);
            }
        }
        this._tables = tableList.toArray(new ITable[0]);
        if (combine) {
            this._tables = this.combineTables(this._tables);
        }
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2});
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2}, combine);
    }

    public CompositeDataSet(IDataSet dataSet, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet}, combine);
    }

    public CompositeDataSet(ITable[] tables) throws DataSetException {
        this._tables = this.combineTables(tables);
    }

    private ITable[] combineTables(ITable[] tables) {
        ArrayList<ITable> tableList = new ArrayList<ITable>();
        for (int j = 0; j < tables.length; ++j) {
            ITable table = tables[j];
            int index = this.getTableIndex(table.getTableMetaData().getTableName(), tableList);
            if (index == -1) {
                tableList.add(table);
                continue;
            }
            table = new CompositeTable((ITable)tableList.get(index), table);
            tableList.set(index, table);
        }
        return tableList.toArray(new ITable[0]);
    }

    private int getTableIndex(String tableName, List list) {
        for (int i = 0; i < list.size(); ++i) {
            ITable table = (ITable)list.get(i);
            if (!tableName.equalsIgnoreCase(table.getTableMetaData().getTableName())) continue;
            return i;
        }
        return -1;
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new DefaultTableIterator(this._tables, reversed);
    }
}

