/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.statement.PreparedStatementFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;

public class DatabaseConfig {
    public static final String PROPERTY_STATEMENT_FACTORY = "http://www.dbunit.org/properties/statementFactory";
    public static final String PROPERTY_RESULTSET_TABLE_FACTORY = "http://www.dbunit.org/properties/resultSetTableFactory";
    public static final String PROPERTY_DATATYPE_FACTORY = "http://www.dbunit.org/properties/datatypeFactory";
    public static final String PROPERTY_ESCAPE_PATTERN = "http://www.dbunit.org/properties/escapePattern";
    public static final String PROPERTY_TABLE_TYPE = "http://www.dbunit.org/properties/tableType";
    public static final String FEATURE_QUALIFIED_TABLE_NAMES = "http://www.dbunit.org/features/qualifiedTableNames";
    public static final String FEATURE_BATCHED_STATEMENTS = "http://www.dbunit.org/features/batchedStatements";
    public static final String FEATURE_DATATYPE_WARNING = "http://www.dbunit.org/features/datatypeWarning";
    private static final DefaultDataTypeFactory DEFAULT_DATA_TYPE_FACTORY = new DefaultDataTypeFactory();
    private static final PreparedStatementFactory PREPARED_STATEMENT_FACTORY = new PreparedStatementFactory();
    private static final CachedResultSetTableFactory RESULT_SET_TABLE_FACTORY = new CachedResultSetTableFactory();
    private static final String DEFAULT_ESCAPE_PATTERN = null;
    private static final String[] DEFAULT_TABLE_TYPE = new String[]{"TABLE"};
    private Set _featuresSet = new HashSet();
    private Map _propertyMap = new HashMap();

    public DatabaseConfig() {
        this.setFeature(FEATURE_BATCHED_STATEMENTS, false);
        this.setFeature(FEATURE_QUALIFIED_TABLE_NAMES, false);
        this.setFeature(FEATURE_DATATYPE_WARNING, true);
        this.setProperty(PROPERTY_STATEMENT_FACTORY, PREPARED_STATEMENT_FACTORY);
        this.setProperty(PROPERTY_RESULTSET_TABLE_FACTORY, RESULT_SET_TABLE_FACTORY);
        this.setProperty(PROPERTY_DATATYPE_FACTORY, DEFAULT_DATA_TYPE_FACTORY);
        this.setProperty(PROPERTY_ESCAPE_PATTERN, DEFAULT_ESCAPE_PATTERN);
        this.setProperty(PROPERTY_TABLE_TYPE, DEFAULT_TABLE_TYPE);
    }

    public void setFeature(String name, boolean value) {
        if (value) {
            this._featuresSet.add(name);
        } else {
            this._featuresSet.remove(name);
        }
    }

    public boolean getFeature(String name) {
        return this._featuresSet.contains(name);
    }

    public void setProperty(String name, Object value) {
        this._propertyMap.put(name, value);
    }

    public Object getProperty(String name) {
        return this._propertyMap.get(name);
    }
}

