/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public abstract class AbstractResultSetTable
extends AbstractTable
implements IResultSetTable {
    protected ITableMetaData _metaData;
    private Statement _statement;
    protected ResultSet _resultSet;

    public AbstractResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        this._metaData = metaData;
        this._resultSet = resultSet;
    }

    public AbstractResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        this._statement = jdbcConnection.createStatement();
        DatabaseConfig config = connection.getConfig();
        IDataTypeFactory dataTypeFactory = (IDataTypeFactory)config.getProperty("http://www.dbunit.org/properties/datatypeFactory");
        try {
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = AbstractResultSetTable.createTableMetaData(tableName, this._resultSet, dataTypeFactory);
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    public AbstractResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        Connection jdbcConnection = connection.getConnection();
        String escapePattern = (String)connection.getConfig().getProperty("http://www.dbunit.org/properties/escapePattern");
        this._statement = jdbcConnection.createStatement();
        try {
            String schema = connection.getSchema();
            String selectStatement = AbstractResultSetTable.getSelectStatement(schema, metaData, escapePattern);
            this._resultSet = this._statement.executeQuery(selectStatement);
            this._metaData = metaData;
        }
        catch (SQLException e) {
            this._statement.close();
            this._statement = null;
            throw e;
        }
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        return DatabaseDataSet.getSelectStatement(schema, metaData, escapePattern);
    }

    static ITableMetaData createTableMetaData(String name, ResultSet resultSet, IDataTypeFactory dataTypeFactory) throws DataSetException, SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Column[] columns = new Column[metaData.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            int columnType = metaData.getColumnType(i + 1);
            String columnTypeName = metaData.getColumnTypeName(i + 1);
            DataType dataType = dataTypeFactory.createDataType(columnType, columnTypeName);
            columns[i] = new Column(metaData.getColumnName(i + 1), dataType, columnTypeName, Column.nullableValue(metaData.isNullable(i + 1)));
        }
        return new DefaultTableMetaData(name, columns);
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public void close() throws DataSetException {
        try {
            if (this._statement != null) {
                this._statement.close();
                this._statement = null;
            }
            if (this._resultSet != null) {
                this._resultSet.close();
                this._resultSet = null;
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    public abstract /* synthetic */ Object getValue(int var1, String var2) throws DataSetException;

    public abstract /* synthetic */ int getRowCount();
}

