/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.XmlDataSet;

public class Export
implements DbUnitTaskStep {
    private static final String FORMAT_FLAT = "flat";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_DTD = "dtd";
    private File _dest;
    private String _format = "flat";
    private List _tables = new ArrayList();

    private String getAbsolutePath(File filename) {
        return filename != null ? filename.getAbsolutePath() : "null";
    }

    public File getDest() {
        return this._dest;
    }

    public String getFormat() {
        return this._format;
    }

    public List getTables() {
        return this._tables;
    }

    public void setDest(File dest) {
        this._dest = dest;
    }

    public void setFormat(String format) {
        if (!(format.equalsIgnoreCase(FORMAT_FLAT) || format.equalsIgnoreCase(FORMAT_XML) || format.equalsIgnoreCase(FORMAT_DTD))) {
            throw new IllegalArgumentException("Type must be one of: 'flat'(default), 'xml', or 'dtd' but was: " + format);
        }
        this._format = format;
    }

    public void addTable(Table table) {
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        this._tables.add(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        try {
            IDataSet dataset = null;
            if (this._dest == null) {
                throw new DatabaseUnitException("'_dest' is a required attribute of the <export> step.");
            }
            if (this._tables.size() == 0) {
                dataset = connection.createDataSet();
            } else {
                QueryDataSet queryDataset = new QueryDataSet(connection);
                Iterator it = this._tables.iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (item instanceof Query) {
                        Query queryItem = (Query)item;
                        queryDataset.addTable(queryItem.getName(), queryItem.getSql());
                        continue;
                    }
                    Table tableItem = (Table)item;
                    queryDataset.addTable(tableItem.getName());
                }
                dataset = queryDataset;
            }
            FileOutputStream out = new FileOutputStream(this._dest);
            try {
                if (this._format.equalsIgnoreCase(FORMAT_FLAT)) {
                    FlatXmlDataSet.write(dataset, out);
                } else if (this._format.equalsIgnoreCase(FORMAT_XML)) {
                    XmlDataSet.write(dataset, out);
                } else if (this._format.equalsIgnoreCase(FORMAT_DTD)) {
                    FlatDtdDataSet.write(dataset, out);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    public String getLogMessage() {
        return "Executing export: \n      in _format: " + this._format + " to datafile: " + this.getAbsolutePath(this._dest);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Export: ");
        result.append(" _dest=" + this.getAbsolutePath(this._dest));
        result.append(", _format= " + this._format);
        result.append(", _tables= " + this._tables);
        return result.toString();
    }
}

