/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import junit.framework.TestCase;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;

public abstract class DatabaseTestCase
extends TestCase {
    public DatabaseTestCase() {
    }

    public DatabaseTestCase(String name) {
        super(name);
    }

    protected abstract IDatabaseConnection getConnection() throws Exception;

    protected abstract IDataSet getDataSet() throws Exception;

    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        connection.close();
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOperation(DatabaseOperation operation) throws Exception {
        if (operation != DatabaseOperation.NONE) {
            IDatabaseConnection connection = this.getConnection();
            try {
                operation.execute(connection, this.getDataSet());
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.executeOperation(this.getSetUpOperation());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.executeOperation(this.getTearDownOperation());
    }
}

