/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.binding.PermissionBinding;
import oracle.adf.model.binding.PermissionHelper;
import oracle.adf.share.ADFContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrSetValException;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidDefNameException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoDefException;
import oracle.jbo.Row;
import oracle.jbo.ScrollEvent;
import oracle.jbo.StructureDef;
import oracle.jbo.ValidationException;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.domain.MutableDomainInterface;
import oracle.jbo.domain.Struct;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.format.Formatter;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlInputValueHandler;
import oracle.jbo.uicli.binding.JUCtrlValueDef;
import oracle.jbo.uicli.binding.JUCtrlValueHandler;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.binding.JUVariableIteratorBinding;

public abstract class JUCtrlValueBinding
extends JUControlBinding
implements JUCtrlValueHandler,
StructureDef {
    private String[] mAttrNames;
    private AttributeDef[] mAttrs;
    final byte BIND_INIT;
    final byte BIND_OBJ_ATTR;
    final byte BIND_VO_ATTR;
    byte mObjAttrBinding;
    final byte TYPE_ROW_ITERATOR;
    final byte TYPE_ARRAY_ITERATOR;
    byte mIteratorBindingType;
    private JUCtrlInputValueHandler mInputHandler;
    private int mLookupInputHandler;
    private static int IH_UNINIT = -1;
    private static int IH_READWRITE = 0;
    private static int IH_WRITEONLY = 1;
    private boolean mAttributeUpdated;
    private String mNullValueString;
    protected boolean mHasInputVal;
    protected Object mInputVal;
    ArrayList mErrExc;
    private int[] mReadAuthorized;
    private int[] mUpdateAuthorized;
    public static final String SEP_LIST_DISPLAY = " ";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABELS = "labels";
    public static final String ATTR_LABELSET = "labelSet";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_FORMATS = "formats";
    public static final String ATTR_TOOLTIP = "tooltip";
    public static final String ATTR_DISPLAY_HINT = "displayHint";
    public static final String ATTR_DISPLAY_HEIGHT = "displayHeight";
    public static final String ATTR_DISPLAY_WIDTH = "displayWidth";
    public static final String ATTR_ATTRIBUTE = "attribute";
    public static final String ATTR_ATTRIBUTES = "attributes";
    public static final String ATTR_ATTRIBUTE_DEF = "attributeDef";
    public static final String ATTR_ATTRIBUTE_DEFS = "attributeDefs";
    public static final String ATTR_ATTRIBUTE_VALUE = "attributeValue";
    public static final String ATTR_ATTRIBUTE_VALUES = "attributeValues";
    public static final String ATTR_INPUT_VALUE = "inputValue";
    public static final String ATTR_UPDATEABLE = "updateable";
    public static final String ATTR_MANDATORY = "mandatory";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_VIEWABLE = "viewable";
    static final char VALUE_PATH_DIVIDER = '#';
    private static /* synthetic */ Class class$oracle$jbo$uicli$binding$JUVariableIteratorBinding;
    private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;

    private /* synthetic */ void $init$() {
        this.BIND_INIT = (byte)-1;
        this.BIND_OBJ_ATTR = 1;
        this.BIND_VO_ATTR = 0;
        this.mObjAttrBinding = (byte)-1;
        this.TYPE_ROW_ITERATOR = 0;
        this.TYPE_ARRAY_ITERATOR = 1;
        this.mIteratorBindingType = 0;
        this.mLookupInputHandler = IH_UNINIT;
        this.mReadAuthorized = null;
        this.mUpdateAuthorized = null;
    }

    protected JUCtrlValueBinding() {
        this.$init$();
        this.mInputHandler = this;
    }

    public JUCtrlValueBinding(Object object, DCIteratorBinding dCIteratorBinding, String[] stringArray) {
        super(object, dCIteratorBinding);
        this.$init$();
        this.mAttrNames = stringArray;
        this.mAttrs = null;
        if (dCIteratorBinding != null) {
            ((JUIteratorBinding)dCIteratorBinding).addValueBinding(this);
        }
        this.mInputHandler = this;
    }

    public void updateValuesFromRow(Row row) {
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
    }

    protected void initResources() {
        if (this.getDef() != null) {
            this.setNullValueString(this.getCtrlValueDef().initializeNullValue(this.getBindingContainer()));
        }
    }

    public abstract void updateValuesFromRows(Row[] var1, boolean var2);

    public abstract void updateRangeScrolled(ScrollEvent var1);

    public abstract void updateNavigated(NavigationEvent var1);

    public void updateRowInserted(InsertEvent insertEvent) {
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
    }

    public String[] getAttributeNames() {
        return this.mAttrNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDef[] getAttributeDefs() {
        if (this.mAttrs == null) {
            DCIteratorBinding dCIteratorBinding = this.getDCIteratorBinding();
            if (dCIteratorBinding == null) {
                if (this.hasVariables() && this.mAttrNames != null) {
                    String string = this.mAttrNames.length > 0 ? this.mAttrNames[0] : this.getName();
                    Variable variable = this.ensureVariableManager().lookupVariable(string);
                    if (variable != null) {
                        this.mAttrs = new AttributeDef[]{variable};
                    }
                }
                if (this.mAttrs == null) {
                    this.mAttrs = new AttributeDef[0];
                }
                return this.mAttrs;
            }
            Object object = dCIteratorBinding.getSyncLock();
            synchronized (object) {
                try {
                    if (this.isAttributeBindingType()) {
                        this.mAttrs = dCIteratorBinding.getAttributeDefs(this.mAttrNames);
                        if (this.mAttrNames == null) {
                            this.mAttrNames = new String[this.mAttrs.length];
                            int n = 0;
                            while (n < this.mAttrNames.length) {
                                this.mAttrNames[n] = this.mAttrs[n].getName();
                                ++n;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    this.reportException(exception);
                }
            }
        }
        return this.mAttrs;
    }

    public AttributeDef getAttributeDef(int n) {
        return this.getAttributeDef(n, false);
    }

    AttributeDef getAttributeDef(int n, boolean bl) {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        if (attributeDefArray != null && attributeDefArray.length > n) {
            return attributeDefArray[n];
        }
        if (bl) {
            String string = "<null>";
            if (this.mAttrNames != null && this.mAttrNames.length > n) {
                string = this.mAttrNames[n];
            }
            throw new NoDefException(131, string, this.getName());
        }
        return null;
    }

    public AttributeDef lookupAttributeDef(String string) {
        try {
            AttributeDef attributeDef = this.findAttributeDef(string, false);
            return attributeDef;
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("JUCtrlValueBinding.lookupAttributeDef ignoring exception :" + (Object)((Object)jboException)));
            }
            return null;
        }
    }

    public AttributeDef findAttributeDef(String string) {
        return this.findAttributeDef(string, true);
    }

    AttributeDef findAttributeDef(String string, boolean bl) {
        try {
            if (string == null && bl) {
                throw new InvalidDefNameException(131, string);
            }
            AttributeDef[] attributeDefArray = this.getAttributeDefs();
            if (attributeDefArray != null) {
                int n = 0;
                while (n < attributeDefArray.length) {
                    if (attributeDefArray[n] != null && attributeDefArray[n].getName().equals(string)) {
                        AttributeDef attributeDef = attributeDefArray[n];
                        return attributeDef;
                    }
                    ++n;
                }
            }
            if (bl) {
                throw new NoDefException(131, string, this.getName());
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
        return null;
    }

    public Object getAttributeFromRow(int n, int n2) {
        try {
            Row row = this.getRowAtRangeIndex(n);
            if (row == null) {
                Object var5_4 = null;
                return var5_4;
            }
            if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
                this.resolveObjectAttributeDefs(row);
            }
            Object object = this.getAttributeFromRow(row, this.getAttributeDef(n2), true);
            return object;
        }
        catch (Exception exception) {
            this.reportException(exception);
            return null;
        }
    }

    public Object getAttributeFromRow(int n, String string) {
        return this.getAttributeFromRow(n, this.getAttributeIndexOf(string));
    }

    public Object getAttributeFromRow(Row row, AttributeDef attributeDef) {
        return this.getAttributeFromRow(row, attributeDef, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttributeFromRow(Row row, AttributeDef attributeDef, boolean bl) {
        Object object;
        if (attributeDef == null) {
            if (attributeDef == null && this.getDCIteratorBinding() == null && this.mAttrNames != null && this.mAttrNames.length == 1 && this.mAttrNames[0].endsWith(".result")) {
                return this.getBindingContainer().findNamedObject(this.mAttrNames[0]);
            }
            return null;
        }
        if (!this.isAttributeViewable(attributeDef.getIndex())) {
            return null;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        Object object2 = object = jUIteratorBinding != null ? jUIteratorBinding.getSyncLock() : this;
        synchronized (object2) {
            LocaleContext localeContext = this.getLocaleContext();
            try {
                Object object3;
                block14: {
                    boolean bl2;
                    object3 = null;
                    AttributeHints attributeHints = attributeDef.getUIHelper();
                    boolean bl3 = bl2 = jUIteratorBinding != null ? jUIteratorBinding.isFindMode() ^ true : true;
                    if (bl && bl2 && attributeHints != null && attributeHints.hasFormatInformation(localeContext)) {
                        try {
                            object3 = attributeDef.getUIHelper().getFormattedAttribute((AttributeList)row, localeContext);
                        }
                        catch (Exception exception) {
                            if (!Diagnostic.isOn()) break block14;
                            Diagnostic.print((String)("A formatting exception occured:  " + attributeDef.getName()));
                            Diagnostic.print((String)exception.getMessage());
                        }
                    }
                }
                if (object3 == null && this.isObjectAttributeBindingType()) {
                    object3 = Struct.getStructAttribute((AttributeList)row, (StructureDef)this.getViewObject(), (String)this.mAttrNames[this.getDefIndex(attributeDef)]);
                } else if (object3 == null) {
                    object3 = this.internalGetAttributeValueFromRow(row, attributeDef);
                }
                Object object4 = object3;
                return object4;
            }
            catch (Exception exception) {
                this.reportException(exception);
                Object var14_14 = null;
                return var14_14;
            }
        }
    }

    public Object getAttributeFromRow(Row row, int n) {
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        return this.getAttributeFromRow(row, this.getAttributeDef(n), true);
    }

    public Object getAttributeFromRow(Row row, String string) {
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        return this.getAttributeFromRow(row, this.findAttributeDef(string), true);
    }

    public void setAttributeInRow(int n, int n2, Object object, boolean bl) {
        try {
            Row row = this.getRowAtRangeIndex(n);
            if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
                this.resolveObjectAttributeDefs(row);
            }
            this.setAttributeInRow(row, this.getAttributeDef(n2), object, bl);
        }
        catch (JboException jboException) {
            if (bl) {
                this.reportException((Exception)((Object)jboException));
            }
            throw jboException;
        }
    }

    public String getNullValueString() {
        return this.mNullValueString;
    }

    protected void setNullValueString(String string) {
        this.mNullValueString = string;
    }

    public void setAttributeInRow(int n, String string, Object object, boolean bl) {
        this.setAttributeInRow(n, this.getAttributeIndexOf(string), object, bl);
    }

    public void setAttributeInRow(Row row, AttributeDef attributeDef, Object object) {
        this.setAttributeInRow(row, attributeDef, object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeInRow(Row row, AttributeDef attributeDef, Object object, boolean bl) {
        LocaleContext localeContext = this.getLocaleContext();
        if (attributeDef != null) {
            Object object2;
            JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
            Object object3 = object2 = jUIteratorBinding != null ? jUIteratorBinding.getSyncLock() : this;
            synchronized (object3) {
                try {
                    boolean bl2;
                    boolean bl3 = bl2 = jUIteratorBinding != null ? jUIteratorBinding.isFindMode() ^ true : true;
                    if (bl2) {
                        if (object != null) {
                            Object object4 = null;
                            AttributeHints attributeHints = attributeDef.getUIHelper();
                            if (attributeHints != null && attributeHints.hasFormatInformation(localeContext)) {
                                if (!(object instanceof String)) {
                                    object = this.formatValue(attributeDef, object);
                                }
                                object4 = attributeDef.getUIHelper().parseFormattedAttribute(object.toString(), localeContext);
                            }
                            object = object4 != null ? object4 : object;
                        }
                    } else if (!this.isControlQueriable()) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println((String)("Warning! setInputValue ignores the value:" + object + " set for:" + this.getName()));
                            Diagnostic.println((String)"Binding subclass should return true for isControlQueriable to support findMode.");
                        }
                        return;
                    }
                    this.resetInputState();
                    object = this.callBeforeSetAttribute(row, attributeDef, object);
                    if (this.mErrExc != null && this.mErrExc.size() > 0) {
                        if (this.mErrExc.size() == 1) {
                            throw (JboException)((Object)this.mErrExc.get(0));
                        }
                        Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$uicli$UIMessageBundle = JUCtrlValueBinding.class$("oracle.jbo.uicli.UIMessageBundle");
                        }
                        throw new AttrSetValException(181, clazz, "34005", this.getName(), attributeDef.getName(), object, (Exception[])this.mErrExc.toArray(new JboException[this.mErrExc.size()]), true);
                    }
                    if (row != null) {
                        if (this.isAttributeBindingType()) {
                            DCDataControl dCDataControl = jUIteratorBinding.getDataControl();
                            if (dCDataControl != null) {
                                dCDataControl.setAttributeInRow(jUIteratorBinding, row, attributeDef, object);
                            } else {
                                row.setAttribute(attributeDef.getName(), object);
                            }
                        } else {
                            Struct.setStructAttribute((AttributeList)row, (StructureDef)this.getViewObject(), (String)this.mAttrNames[this.getDefIndex(attributeDef)], (Object)object);
                            if (!jUIteratorBinding.isFindMode() && !jUIteratorBinding.getDataControl().isTransactionModified()) {
                                jUIteratorBinding.getDataControl().setTransactionModified();
                            }
                        }
                        this.mAttributeUpdated = true;
                    } else {
                        this.internalSetAttribute(object);
                    }
                }
                catch (JboException jboException) {
                    if (bl) {
                        this.reportException((Exception)((Object)jboException));
                    }
                    throw jboException;
                }
            }
        }
    }

    Object internalGetAttributeValueFromRow(Row row, AttributeDef attributeDef) {
        AttributeDef[] attributeDefArray;
        int n = attributeDef.getIndex();
        if (row != null) {
            return row.getAttribute(n);
        }
        if (this.hasVariables() && (attributeDefArray = this.getAttributeDefs()).length > 0) {
            VariableValueManager variableValueManager = this.ensureVariableManager();
            return variableValueManager.getVariableValue(attributeDefArray[0].getName());
        }
        return null;
    }

    void internalSetAttribute(Object object) {
        AttributeDef[] attributeDefArray;
        if (this.hasVariables() && (attributeDefArray = this.getAttributeDefs()).length > 0) {
            VariableValueManager variableValueManager = this.ensureVariableManager();
            variableValueManager.setVariableValue(attributeDefArray[0].getName(), object);
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println((String)("internalSetAttribute: Attempt to update attribute in null row with value:" + object));
        }
    }

    public void setAttributeInRow(Row row, int n, Object object, boolean bl) {
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        this.setAttributeInRow(row, this.getAttributeDef(n), object, bl);
    }

    public void setAttributeInRow(Row row, String string, Object object, boolean bl) {
        this.setAttributeInRow(row, this.findAttributeDef(string), object, bl);
    }

    private boolean validateAttributeValue(Row row, AttributeDef attributeDef, Object object, boolean bl) {
        boolean bl2;
        boolean bl3 = true;
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        boolean bl4 = bl2 = jUIteratorBinding != null ? jUIteratorBinding.isFindMode() : this.getBindingContainer().isFindMode();
        if (!bl2) {
            JUCtrlValueDef jUCtrlValueDef = this.getCtrlValueDef();
            if ((jUIteratorBinding == null || jUIteratorBinding.isOperationSupported((byte)4) && jUCtrlValueDef != null) && jUCtrlValueDef.isApplyValidation()) {
                ArrayList arrayList;
                if (object == null || !object.equals(this.mNullValueString)) {
                    try {
                        object = TypeFactory.convertAttributeValueToType((AttributeDef)attributeDef, (Class)attributeDef.getJavaType(), (Object)object, (int)181, (String)jUCtrlValueDef.getFullName());
                    }
                    catch (JboException jboException) {
                        ApplicationModule applicationModule;
                        jboException.setNeedsEntityToVOMapping(false);
                        ApplicationModule applicationModule2 = applicationModule = jUIteratorBinding != null ? jUIteratorBinding.getApplicationModule() : null;
                        if (bl || applicationModule == null || !applicationModule.getTransaction().isBundledExceptionMode()) {
                            bl3 = false;
                            throw jboException;
                        }
                        this.setError(jboException, object, false);
                    }
                }
                if ((arrayList = jUCtrlValueDef.getValidatorsForAttribute(attributeDef)) != null) {
                    JboValidatorContext jboValidatorContext = new JboValidatorContext(181, (Object)row, jUCtrlValueDef.getFullName(), attributeDef, this.internalGetAttributeValueFromRow(row, attributeDef), object);
                    AttrValException attrValException = RulesBeanUtils.validate(arrayList.iterator(), (Row)row, (JboValidatorContext)jboValidatorContext, (boolean)false);
                    if (attrValException != null) {
                        bl3 = false;
                        attrValException.setNeedsEntityToVOMapping(false);
                        ApplicationModule applicationModule = jUIteratorBinding.getApplicationModule();
                        if (bl || applicationModule == null || !applicationModule.getTransaction().isBundledExceptionMode()) {
                            throw attrValException;
                        }
                        this.setError((JboException)attrValException, object, false);
                    }
                }
            }
        }
        return bl3;
    }

    Object callBeforeSetAttribute(Row row, AttributeDef attributeDef, Object object) {
        this.validateAttributeValue(row, attributeDef, object, false);
        return this.getBindingContainer().callBeforeSetAttribute(this, row, attributeDef, object);
    }

    Object internalGetConvertedValue(Object object) {
        return object;
    }

    protected Row internalGetRow() {
        return this.getCurrentRow();
    }

    public Object getAttribute(int n) {
        Row row = this.internalGetRow();
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        return this.getAttributeFromRow(row, this.getAttributeDef(n), true);
    }

    public Object getAttribute(String string) {
        return this.getAttributeFromRow(this.internalGetRow(), this.findAttributeDef(string), true);
    }

    public Object getAttribute() {
        return this.getAttribute(0);
    }

    public Object[] getAttributes() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    protected ArrayList getAttributes(Row row, AttributeDef[] attributeDefArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(attributeDefArray.length);
        int n = 0;
        while (n < attributeDefArray.length) {
            arrayList.add(this.getAttributeFromRow(row, attributeDefArray[n], true));
            ++n;
        }
        return arrayList;
    }

    public void setAttribute(int n, Object object) {
        Row row = this.internalGetRow();
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        this.setAttributeInRow(row, this.getAttributeDef(n), object, false);
    }

    public void setAttribute(String string, Object object) {
        Row row = this.internalGetRow();
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        this.setAttributeInRow(row, this.findAttributeDef(string), object, false);
    }

    public int getAttributeCount() {
        if (this.mAttrs != null) {
            return this.mAttrs.length;
        }
        this.getAttributeDefs();
        return this.mAttrs != null ? this.mAttrs.length : 0;
    }

    public int getAttributeIndexOf(String string) {
        try {
            if (string == null) {
                throw new InvalidDefNameException(131, string);
            }
            AttributeDef[] attributeDefArray = this.getAttributeDefs();
            int n = 0;
            while (n < attributeDefArray.length) {
                if (attributeDefArray[n].getName().equals(string)) {
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
            throw new NoDefException(131, string);
        }
        catch (Exception exception) {
            this.reportException(exception);
            return -1;
        }
    }

    public Object getAttributeValue() {
        Row row = this.internalGetRow();
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        return this.getAttributeFromRow(row, this.getAttributeDef(0), false);
    }

    public Object getAttributeValue(int n) {
        Row row = this.internalGetRow();
        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
            this.resolveObjectAttributeDefs(row);
        }
        return this.getAttributeFromRow(row, this.getAttributeDef(n), false);
    }

    public void setAttributeValue(Object object) {
        this.setAttribute(0, object);
    }

    protected ArrayList getAttributeValues(Row row, AttributeDef[] attributeDefArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(attributeDefArray.length);
        int n = 0;
        while (n < attributeDefArray.length) {
            arrayList.add(this.getAttributeFromRow(row, attributeDefArray[n], false));
            ++n;
        }
        return arrayList;
    }

    protected Object getAttributeValueFromRow(int n, int n2) {
        try {
            Row row = this.getRowAtRangeIndex(n);
            if (row == null) {
                Object var5_4 = null;
                return var5_4;
            }
            if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
                this.resolveObjectAttributeDefs(row);
            }
            Object object = this.getAttributeFromRow(row, this.getAttributeDef(n2), false);
            return object;
        }
        catch (Exception exception) {
            this.reportException(exception);
            return null;
        }
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttributeValue(n);
            ++n;
        }
        return objectArray;
    }

    protected static String getMergedAttributeValues(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            Object e;
            if (n > 0) {
                stringBuffer.append(SEP_LIST_DISPLAY);
            }
            if ((e = list.get(n)) != null) {
                stringBuffer.append(list.get(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isAttributeMandatory(int n) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null && jUIteratorBinding.isFindMode()) {
            return false;
        }
        AttributeDef attributeDef = this.getAttributeDef(n);
        return attributeDef != null ? attributeDef.isMandatory() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAttributeUpdateable(Row row, int n) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            Object object = jUIteratorBinding.getSyncLock();
            synchronized (object) {
                try {
                    boolean bl = jUIteratorBinding.isFindMode();
                    if (bl) {
                        if (!jUIteratorBinding.isOperationSupported((byte)3)) {
                            boolean bl2 = false;
                            return bl2;
                        }
                    } else {
                        if (!jUIteratorBinding.isOperationSupported((byte)0)) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        if (!this.isInternalAttributeUpdateable(n)) {
                            boolean bl4 = false;
                            return bl4;
                        }
                    }
                    if (row == null) {
                        row = this.internalGetRow();
                    }
                    if (row != null) {
                        DCBindingContainer dCBindingContainer = jUIteratorBinding.getBindingContainer();
                        if (bl) {
                            if (this.isObjectAttributeBindingType() || !jUIteratorBinding.isFindModeAllowed()) {
                                boolean bl5 = false;
                                return bl5;
                            }
                            boolean bl6 = row.isAttributeUpdateable(this.getAttributeDef(n).getIndex()) && this.isControlQueriable();
                            return bl6;
                        }
                        if (this.mAttrs == null && this.isObjectAttributeBindingType()) {
                            this.resolveObjectAttributeDefs(row);
                        }
                        boolean bl7 = this.isAttributeBindingType() ? row.isAttributeUpdateable(this.getAttributeDef(n).getIndex()) : true;
                        return bl7;
                    }
                }
                catch (Exception exception) {
                    this.reportException(exception);
                }
            }
        }
        if (this.hasVariables()) {
            return this.getAttributeDef(0).getUpdateableFlag() != 0;
        }
        return false;
    }

    public boolean isAttributeUpdateable(int n) {
        return this.isAttributeUpdateable(null, n);
    }

    public void stopEditing() {
    }

    final void resolveAttributeBindingType() {
        if (this.mObjAttrBinding == -1) {
            String[] stringArray = this.mAttrNames;
            if (stringArray != null && this.getDCIteratorBinding() != null) {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null && stringArray[n].indexOf(46) > 0) {
                        this.mObjAttrBinding = 1;
                        break;
                    }
                    ++n;
                }
            }
            if (this.mObjAttrBinding == -1) {
                this.mObjAttrBinding = 0;
            }
        }
    }

    final boolean isObjectAttributeBindingType() {
        if (this.mObjAttrBinding == -1) {
            this.resolveAttributeBindingType();
        }
        return this.mObjAttrBinding == 1;
    }

    final boolean isAttributeBindingType() {
        if (this.mObjAttrBinding == -1) {
            this.resolveAttributeBindingType();
        }
        return this.mObjAttrBinding == 0;
    }

    final void resolveObjectAttributeDefs(Row row) {
        this.mAttrs = new AttributeDef[this.mAttrNames.length];
        Struct.fillObjectAttributeDefs((AttributeList)row, (StructureDef)this.getViewObject(), (String[])this.mAttrNames, (AttributeDef[])this.mAttrs);
    }

    final int getDefIndex(AttributeDef attributeDef) {
        int n = 0;
        while (n < this.mAttrs.length) {
            if (attributeDef == this.mAttrs[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setArrayIteratorType() {
        this.mIteratorBindingType = 1;
    }

    public boolean isArrayIteratorType() {
        return this.mIteratorBindingType == 1;
    }

    public void release(int n) {
        JUIteratorBinding jUIteratorBinding;
        if (n == DCDataControl.REL_ALL_REFS && (jUIteratorBinding = this.getIteratorBinding()) != null) {
            jUIteratorBinding.removeValueBinding(this);
        }
        super.release(n);
    }

    public final LocaleContext getLocaleContext() {
        if (this.getBindingContainer() != null) {
            return this.getBindingContainer().getLocaleContext();
        }
        return new 1();
    }

    protected final AttributeHints getAttributeUIHelper(String string) {
        AttributeDef attributeDef;
        AttributeDef attributeDef2 = attributeDef = string != null ? this.findAttributeDef(string, false) : this.getAttributeDef(0, true);
        if (attributeDef != null) {
            return attributeDef.getUIHelper();
        }
        return null;
    }

    public String[] getLabelSet() {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        if (attributeDefArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[attributeDefArray.length];
        int n = 0;
        while (n < attributeDefArray.length) {
            stringArray[n] = attributeDefArray[n].getUIHelper().getLabel(this.getLocaleContext());
            ++n;
        }
        return stringArray;
    }

    public Map getLabels() {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        if (attributeDefArray != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(attributeDefArray.length + 3);
            int n = 0;
            while (n < attributeDefArray.length) {
                if (attributeDefArray[n] != null) {
                    hashMap.put(attributeDefArray[n].getName(), attributeDefArray[n].getUIHelper().getLabel(this.getLocaleContext()));
                }
                ++n;
            }
            return hashMap;
        }
        return null;
    }

    public String getLabel() {
        AttributeDef attributeDef = this.getAttributeDef(0, true);
        if (attributeDef == null) {
            return "";
        }
        return attributeDef.getUIHelper().getLabel(this.getLocaleContext());
    }

    public Map getFormats() {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        if (attributeDefArray != null) {
            JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
            LocaleContext localeContext = this.getLocaleContext();
            HashMap<String, String> hashMap = new HashMap<String, String>(attributeDefArray.length);
            if (jUIteratorBinding != null) {
                int n = 0;
                while (n < attributeDefArray.length) {
                    AttributeDef attributeDef = attributeDefArray[n];
                    if (attributeDef != null) {
                        hashMap.put(attributeDef.getName(), attributeDef.getUIHelper().getFormat(localeContext));
                    }
                    ++n;
                }
            }
            return hashMap;
        }
        return null;
    }

    public String getFormat() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        AttributeDef attributeDef = this.getAttributeDef(0, true);
        if (attributeDef == null) {
            return null;
        }
        return attributeDef.getUIHelper().getFormat(this.getLocaleContext());
    }

    public String getTooltip() {
        return this.getAttributeDef(0, true).getUIHelper().getTooltip(this.getLocaleContext());
    }

    public String getDisplayHint() {
        return this.getAttributeDef(0, true).getUIHelper().getDisplayHint(this.getLocaleContext());
    }

    public int getControlType() {
        return this.getAttributeDef(0, true).getUIHelper().getControlType(this.getLocaleContext());
    }

    public int getDisplayWidth() {
        return this.getAttributeDef(0, true).getUIHelper().getDisplayWidth(this.getLocaleContext());
    }

    public int getDisplayHeight() {
        return this.getAttributeDef(0, true).getUIHelper().getDisplayHeight(this.getLocaleContext());
    }

    public String getHint(String string) {
        return this.getAttributeDef(0, true).getUIHelper().getHint(this.getLocaleContext(), string);
    }

    public boolean hasFormatInformation() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null && jUIteratorBinding.isFindMode()) {
            return false;
        }
        return this.getAttributeDef(0, true).getUIHelper().hasFormatInformation(this.getLocaleContext());
    }

    public boolean displayInShortForm() {
        return this.getAttributeDef(0, true).getUIHelper().displayInShortForm(this.getLocaleContext());
    }

    public String getLabel(String string, String string2) {
        String string3 = this.getHint(string, string2, "LABEL");
        if (string3 == null) {
            int n = string2.lastIndexOf(46);
            string3 = n > -1 ? string2.substring(n + 1) : string2;
        }
        return string3;
    }

    public String getTooltip(String string, String string2) {
        return this.getHint(string, string2, "TOOLTIP");
    }

    public String getHint(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2.replace('.', '_')).append('_');
        }
        stringBuffer.append(string3);
        return this.findAttributeDef(string, true).getUIHelper().getHint(this.getLocaleContext(), stringBuffer.toString());
    }

    StructureDef getStructureDef() {
        return this;
    }

    JUCtrlValueDef getCtrlValueDef() {
        return (JUCtrlValueDef)this.getDef();
    }

    public final ArrayList getAttributeValidators() {
        return this.getAttributeValidators(0);
    }

    public ArrayList getAttributeValidators(int n) {
        return this.getDef() != null ? this.getCtrlValueDef().getValidatorsForAttribute(this.getAttributeDef(n)) : null;
    }

    protected Object internalGet(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef == null) {
            attributeDef = this.lookupAttributeDef(JboNameUtil.toUpperCaseFirstChar((String)string));
        }
        if (attributeDef != null) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributeFromRow(this.internalGetRow(), attributeDef, true);
        }
        if (ATTR_ATTRIBUTE_VALUE == (string = string.intern())) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributeValue();
        }
        if (ATTR_INPUT_VALUE == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getInputValue();
        }
        if (ATTR_UPDATEABLE == string) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isUpdateable());
        }
        if (ATTR_MANDATORY == string) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isMandatory());
        }
        if (string == ATTR_PATH) {
            this.mInternalGet_KeyResolved = true;
            return this.getPath();
        }
        if (ATTR_ATTRIBUTE_VALUES == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributeValues();
        }
        if (ATTR_ATTRIBUTE == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttribute();
        }
        if (ATTR_ATTRIBUTES == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributes();
        }
        if (ATTR_LABEL == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getLabel();
        }
        if (ATTR_FORMAT == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getFormat();
        }
        if (ATTR_TOOLTIP == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getTooltip();
        }
        if (ATTR_ATTRIBUTE_DEF == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributeDef();
        }
        if (ATTR_ATTRIBUTE_DEFS == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getAttributeDefs();
        }
        if (ATTR_DISPLAY_HINT == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getDisplayHint();
        }
        if (ATTR_LABELS == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getLabels();
        }
        if (ATTR_FORMATS == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getFormats();
        }
        if (ATTR_LABELSET == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getLabelSet();
        }
        if (string == ATTR_VIEWABLE) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isViewable());
        }
        if (ATTR_DISPLAY_HEIGHT == string) {
            this.mInternalGet_KeyResolved = true;
            return new Integer(this.getDisplayHeight());
        }
        if (ATTR_DISPLAY_WIDTH == string) {
            this.mInternalGet_KeyResolved = true;
            return new Integer(this.getDisplayWidth());
        }
        return super.internalGet(string);
    }

    public Object put(Object object, Object object2) {
        if (object instanceof String) {
            String string = ((String)object).intern();
            if (ATTR_ATTRIBUTE_VALUE == string) {
                Object object3 = this.getAttributeValue();
                this.setAttributeValue(object2);
                return object3;
            }
            if (ATTR_INPUT_VALUE == string) {
                Object object4 = this.getInputValue();
                this.setInputValue(object2);
                return object4;
            }
        }
        return super.put(object, object2);
    }

    protected void resetInputState() {
        this.removeFromDCExceptions();
        this.mErrExc = null;
        this.mInputVal = null;
        this.mHasInputVal = false;
        this.mAttributeUpdated = false;
    }

    protected void processInputException(ValidationException validationException) {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            if (validationException.hasAttributeException(attributeDefArray[n].getName())) {
                this.setError((JboException)((Object)validationException.getAttributeException(null, attributeDefArray[n].getName())), null, false);
                break;
            }
            ++n;
        }
    }

    protected void setError(JboException jboException, Object object) {
        this.setError(jboException, object, true);
    }

    void setError(JboException jboException, Object object, boolean bl) {
        if (this.mErrExc == null) {
            this.mErrExc = new ArrayList(3);
        }
        if (jboException == null) {
            this.mHasInputVal = false;
        } else if (!this.mErrExc.contains((Object)jboException)) {
            DCDataControl dCDataControl;
            boolean bl2;
            block15: {
                if (jboException.hasPeerExceptions() && this.mErrExc.contains(jboException.getExceptions()[0])) {
                    return;
                }
                this.mErrExc.add(jboException);
                bl2 = jboException instanceof AttrValException;
                if (this.mInputVal == null) {
                    this.mInputVal = object != null ? object : (bl2 ? ((AttrValException)jboException).getAttrValue() : null);
                    JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
                    if (this.mInputVal != null && jUIteratorBinding != null && !jUIteratorBinding.isFindMode()) {
                        try {
                            this.mInputVal = this.formatValue(this.getAttributeDef(), this.mInputVal);
                        }
                        catch (Exception exception) {
                            if (!Diagnostic.isOn()) break block15;
                            Diagnostic.print((String)("A formatting exception occured:  " + this.getName()));
                            Diagnostic.print((String)exception.getMessage());
                        }
                    }
                }
            }
            this.mHasInputVal = true;
            if (bl2 && this.mAttributeUpdated) {
                this.resetAttributeExceptionInRow(this.getCurrentRow(), this.getAttributeDef(), (AttrValException)jboException);
                this.mAttributeUpdated = false;
            }
            this.addToDCExceptions(jboException);
            DCDataControl dCDataControl2 = dCDataControl = this.getIteratorBinding() != null ? this.getIteratorBinding().getDataControl() : this.getBindingContainer().getDataControl();
            if (bl) {
                if (dCDataControl != null) {
                    dCDataControl.reportException(this.getBindingContainer(), (Exception)((Object)jboException));
                } else if (this.getBindingContainer() != null) {
                    this.getBindingContainer().reportException(jboException);
                }
            } else {
                this.getBindingContainer().cacheException(jboException);
            }
        }
    }

    public boolean isUpdateable() {
        return this.isAttributeUpdateable(0);
    }

    public boolean isMandatory() {
        return this.isAttributeMandatory(0);
    }

    public AttributeDef getAttributeDef() {
        return this.getAttributeDef(0, true);
    }

    public String getPath() {
        StringBuffer stringBuffer = new StringBuffer().append("VB_").append(this.getFullName().replace('.', '#'));
        return stringBuffer.toString();
    }

    public boolean resolvePath(Map map) {
        String string;
        if (map != null && map.containsKey(string = this.getPath())) {
            Object object = map.get(string);
            if (object != null && object.getClass().isArray() && object instanceof String[]) {
                object = ((String[])object)[0];
            }
            if (this.processNewInputValue(object)) {
                JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
                if (jUIteratorBinding != null) {
                    jUIteratorBinding.internalReserveCurrentRow();
                }
                return true;
            }
        }
        return false;
    }

    public Object getInputValue() {
        Object object;
        this.getError();
        if (this.mErrExc != null) {
            object = this.mInputVal;
        } else {
            if (this.mLookupInputHandler == IH_UNINIT) {
                this.resolveInputHandler();
            }
            object = this.mLookupInputHandler == IH_READWRITE ? ((JUCtrlValueHandler)this.mInputHandler).getInputValue(this, 0) : this.getInputValue(this, 0);
        }
        return object;
    }

    public Object getInputValue(JUCtrlValueBinding jUCtrlValueBinding, int n) {
        return this.getInputValueInRow(jUCtrlValueBinding, this.internalGetRow(), this.getAttributeDef(n));
    }

    public void setInputValue(Object object) {
        try {
            this.resetInputState();
            this.mInputVal = object;
            this.mHasInputVal = true;
            if (this.mLookupInputHandler == IH_UNINIT) {
                this.resolveInputHandler();
            }
            this.mInputHandler.setInputValue(this, 0, object);
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("CtrlAttrs: Caching exception :" + (Object)((Object)jboException)));
            }
            this.setError(jboException, object);
        }
    }

    public Object validateInputValue(Object object) {
        try {
            this.validateAttributeValue(this.getCurrentRow(), this.getAttributeDef(), object, true);
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("Failed to validate :" + object + " for binding:" + this.getName()));
            }
            Exception exception2 = exception;
            return exception2;
        }
        return null;
    }

    public void setInputValue(JUCtrlValueBinding jUCtrlValueBinding, int n, Object object) {
        this.setInputValueInRow(jUCtrlValueBinding, this.internalGetRow(), this.getAttributeDef(n, true), object, false);
    }

    protected void setInputValueInRow(JUCtrlValueBinding jUCtrlValueBinding, Row row, AttributeDef attributeDef, Object object, boolean bl) {
        JUIteratorBinding jUIteratorBinding;
        if (object != null && object.equals(this.getNullValueString()) && (jUIteratorBinding = this.getIteratorBinding()) != null && !jUIteratorBinding.isFindMode()) {
            object = null;
        }
        jUCtrlValueBinding.setAttributeInRow(row, attributeDef, object, bl);
    }

    protected Object getInputValueInRow(JUCtrlValueBinding jUCtrlValueBinding, Row row, AttributeDef attributeDef) {
        JUIteratorBinding jUIteratorBinding;
        Object object = this.getAttributeFromRow(row, attributeDef, true);
        if (object == null && (jUIteratorBinding = this.getIteratorBinding()) != null && !jUIteratorBinding.isFindMode()) {
            return this.mNullValueString;
        }
        return object;
    }

    public boolean processNewInputValue(Object object) {
        if (this.mLookupInputHandler == IH_UNINIT) {
            this.resolveInputHandler();
        }
        return this.mInputHandler.isNewInputValue(this, 0, object);
    }

    void lookupInputHandler() {
        this.mLookupInputHandler = IH_UNINIT;
    }

    void resolveInputHandler() {
        JUCtrlValueDef jUCtrlValueDef = (JUCtrlValueDef)this.getDef();
        String string = null;
        if (jUCtrlValueDef != null && "DEFAULT".equals(string = jUCtrlValueDef.getCustomInputHandler())) {
            string = this.getAttributeDef(0).getJavaType().getName();
        }
        if (string != null) {
            DCDataControl dCDataControl = this.getIteratorBinding() != null ? this.getIteratorBinding().getDataControl() : this.getBindingContainer().getDataControl();
            this.mInputHandler = (JUCtrlInputValueHandler)dCDataControl.getBindingContext().getBindingInputHandler(string);
            if (Diagnostic.isOn() && this.mInputHandler == null) {
                Diagnostic.println((String)("Warning! No InputHandler found for :" + string));
                Diagnostic.println((String)"******** Using default InputHandler");
            }
        }
        if (this.mInputHandler == null) {
            this.mInputHandler = this;
            this.mLookupInputHandler = IH_READWRITE;
        } else {
            this.mLookupInputHandler = this.mInputHandler instanceof JUCtrlValueHandler ? IH_READWRITE : IH_WRITEONLY;
        }
    }

    public boolean isNewInputValue(JUCtrlValueBinding jUCtrlValueBinding, int n, Object object) {
        JUIteratorBinding jUIteratorBinding = jUCtrlValueBinding.getIteratorBinding();
        if (jUIteratorBinding != null) {
            jUIteratorBinding.prepareForInput();
        }
        boolean bl = true;
        if (this.mErrExc == null) {
            Object object2 = jUCtrlValueBinding.getAttribute(n);
            if (object == null && object2 == null) {
                bl = false;
            } else if (object != null) {
                if (object instanceof String && ((String)object).length() == 0) {
                    if (object2 == null) {
                        if (jUIteratorBinding == null || !jUIteratorBinding.isFindMode()) {
                            bl = false;
                        }
                    } else if (object2 instanceof MutableDomainInterface) {
                        bl = false;
                    } else if (object.equals(this.mNullValueString)) {
                        return true;
                    }
                }
                if (bl) {
                    boolean bl2;
                    JUIteratorBinding jUIteratorBinding2 = this.getIteratorBinding();
                    boolean bl3 = bl2 = jUIteratorBinding2 != null ? jUIteratorBinding2.isFindMode() ^ true : true;
                    if (bl2) {
                        LocaleContext localeContext = this.getLocaleContext();
                        AttributeDef attributeDef = jUCtrlValueBinding.getAttributeDef(n);
                        Object object3 = this.formatValue(attributeDef, object);
                        object = object3 != null ? object3 : object;
                    }
                    bl = object.equals(TypeFactory.getInstance(object.getClass(), (Object)object2)) ^ true;
                }
            }
        }
        return bl;
    }

    Object formatValue(AttributeDef attributeDef, Object object) {
        Object object2;
        block3: {
            object2 = object;
            try {
                LocaleContext localeContext = this.getLocaleContext();
                AttributeHints attributeHints = attributeDef.getUIHelper();
                if (attributeHints != null && attributeHints.hasFormatInformation(localeContext)) {
                    Formatter formatter = attributeHints.getFormatter(localeContext);
                    String string = attributeHints.getFormat(localeContext);
                    object2 = formatter.format(string, object);
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block3;
                Diagnostic.print((String)("A formatting exception occured:  " + attributeDef.getName()));
                Diagnostic.print((String)exception.getMessage());
            }
        }
        return object2;
    }

    public JboException getError() {
        JUIteratorBinding jUIteratorBinding;
        if (this.mErrExc == null && (jUIteratorBinding = this.getIteratorBinding()) != null && jUIteratorBinding.getError() != null) {
            jUIteratorBinding.processInputException();
        }
        if (this.mErrExc != null && this.mErrExc.size() > 0) {
            JboException jboException = (JboException)((Object)this.mErrExc.get(0));
            jboException.setLocaleContext(this.getLocaleContext());
            return jboException;
        }
        return null;
    }

    public List getErrors() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (this.mErrExc == null && jUIteratorBinding != null && jUIteratorBinding.getError() != null) {
            jUIteratorBinding.processInputException();
        }
        return DCUtil.getLocalizedExceptionsList(this.mErrExc, this.getLocaleContext());
    }

    protected List getInputErrorsForRowKey(Key key) {
        return this.getErrors();
    }

    boolean hasBoundAttrChanged(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            AttributeDef[] attributeDefArray = this.getAttributeDefs();
            if (attributeDefArray.length > 0) {
                int n2 = 0;
                while (n2 < attributeDefArray.length) {
                    if (attributeDefArray[n2].getIndex() == nArray[n]) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    public void compareAndSetAttribute(int n, Object object) {
        String string;
        Object object2 = this.getAttribute(n);
        if (object == object2) {
            return;
        }
        String string2 = object == null ? "" : object.toString();
        String string3 = string = object2 == null ? "" : object2.toString();
        if (!string2.equals(string)) {
            try {
                this.setAttribute(n, object);
            }
            catch (JboException jboException) {
                this.reportException((Exception)((Object)jboException), true);
            }
        }
    }

    public final JUCtrlInputValueHandler getInputValueHandler() {
        return this.mInputHandler;
    }

    public void setInputValueHandler(JUCtrlInputValueHandler jUCtrlInputValueHandler) {
        if (jUCtrlInputValueHandler != null) {
            this.mInputHandler = jUCtrlInputValueHandler;
            this.mLookupInputHandler = this.mInputHandler instanceof JUCtrlValueHandler ? IH_READWRITE : IH_WRITEONLY;
        }
    }

    public final boolean hasVariables() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            Class clazz = jUIteratorBinding.getClass();
            Class clazz2 = class$oracle$jbo$uicli$binding$JUVariableIteratorBinding;
            if (clazz2 == null) {
                clazz2 = class$oracle$jbo$uicli$binding$JUVariableIteratorBinding = JUCtrlValueBinding.class$("oracle.jbo.uicli.binding.JUVariableIteratorBinding");
            }
            if (clazz == clazz2) {
                return true;
            }
        }
        return this.getCtrlValueDef() != null && this.getCtrlValueDef().hasVariables();
    }

    public final VariableValueManager ensureVariableManager() {
        if (this.hasVariables() && this.getIteratorBinding() != null) {
            return ((JUVariableIteratorBinding)this.getIteratorBinding()).ensureVariableManager();
        }
        return this.getBindingContainer().ensureVariableManager();
    }

    protected boolean internalHasPermission(String string, String string2) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            String string3 = null;
            String string4 = jUIteratorBinding.getPermissionTargetName();
            string3 = string4 != null && string.equalsIgnoreCase(string4) ? PermissionHelper.getPermissionClassName(1) : PermissionHelper.getPermissionClassName(0);
            if (string3 != null) {
                Permission permission = (Permission)PermissionHelper.createPermissionInstance(string3, string, string2);
                if (!PermissionHelper.hasPermission(ADFContext.getCurrent().getSecurityContext(), permission)) {
                    return false;
                }
            }
        }
        return true;
    }

    String getPermissionTargetName(String string) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        StringBuffer stringBuffer = new StringBuffer();
        if (jUIteratorBinding != null) {
            stringBuffer.append(jUIteratorBinding.getPermissionTargetName());
            if (string != null) {
                stringBuffer.append('.').append(string);
            }
        }
        return stringBuffer.toString();
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            String string = this.mAttrNames.length > 0 ? this.mAttrNames[0] : null;
            this.mPermissionInfo = string != null && this.getName().equals(string) ? new PermissionBinding(this.getPermissionTargetName(string), 0) : new PermissionBinding(this.getPermissionTargetName(null), 1, this.getLabels());
        }
        return this.mPermissionInfo;
    }

    boolean isViewable() {
        if (!PermissionHelper.isAuthorizationEnabled()) {
            return true;
        }
        if (this.mReadAuthorized == null) {
            this.initAuthorizationFlags();
        }
        if (this.mReadAuthorized[0] != -1) {
            return this.mReadAuthorized[0] == 1;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null && !jUIteratorBinding.getDataControl().hasPermission(this, jUIteratorBinding.getPermissionTargetName(), "Read")) {
            this.mReadAuthorized[0] = 0;
            return false;
        }
        this.mReadAuthorized[0] = 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAttributeViewable(int n) {
        if (!PermissionHelper.isAuthorizationEnabled()) {
            return true;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            Object object = jUIteratorBinding.getSyncLock();
            synchronized (object) {
                int n2 = n;
                AttributeDef attributeDef = this.getAttributeDef(n2);
                if (attributeDef == null && (attributeDef = this.getAttributeDef(n2 = 0, true)) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mReadAuthorized == null) {
                    this.initAuthorizationFlags();
                } else if (this.mReadAuthorized[n2] != -1) {
                    boolean bl = this.mReadAuthorized[n2] == 1;
                    return bl;
                }
                String string = this.getPermissionTargetName(attributeDef.getName());
                if (!this.internalHasPermission(string, "Read")) {
                    this.mReadAuthorized[n2] = 0;
                    boolean bl = false;
                    return bl;
                }
                this.mReadAuthorized[n2] = 1;
            }
        }
        return true;
    }

    void initAuthorizationFlags() {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        if (this.mReadAuthorized == null) {
            this.mReadAuthorized = new int[attributeDefArray.length];
            int n = 0;
            while (n < attributeDefArray.length) {
                this.mReadAuthorized[n] = -1;
                ++n;
            }
        }
        if (this.mUpdateAuthorized == null) {
            this.mUpdateAuthorized = new int[attributeDefArray.length];
            int n = 0;
            while (n < attributeDefArray.length) {
                this.mUpdateAuthorized[n] = -1;
                ++n;
            }
        }
    }

    boolean isInternalAttributeUpdateable(int n) {
        if (PermissionHelper.isAuthorizationEnabled()) {
            AttributeDef attributeDef;
            if (this.mUpdateAuthorized == null) {
                this.initAuthorizationFlags();
            }
            if (n < this.mUpdateAuthorized.length && this.mUpdateAuthorized[n] == 0) {
                return false;
            }
            if (n < this.mUpdateAuthorized.length && this.mUpdateAuthorized[n] == -1 && (attributeDef = this.getAttributeDef(n)) != null) {
                String string = this.getPermissionTargetName(attributeDef.getName());
                DCDataControl dCDataControl = this.getIteratorBinding().getDataControl();
                if (dCDataControl != null && !dCDataControl.hasPermission(this, string, "Update")) {
                    this.mUpdateAuthorized[n] = 0;
                    return false;
                }
                this.mUpdateAuthorized[n] = 1;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    implements LocaleContext {
        public Locale getLocale() {
            return Locale.getDefault();
        }

        public TimeZone getUserTimeZone() {
            return TimeZone.getDefault();
        }
    }
}

