/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.adf.model.BindingContext;
import oracle.adf.model.OperationBinding;
import oracle.adf.model.OperationParameter;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCInvokeMethod;
import oracle.adf.model.binding.DCInvokeMethodDef;
import oracle.adf.model.binding.DCInvokeMethodListener;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.binding.PermissionBinding;
import oracle.adf.model.binding.PermissionHelper;
import oracle.binding.OperationInfo;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.RowNotAvailableException;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ViewCriteria;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.uicli.binding.JUActionDef;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlActionBindingEvent;
import oracle.jbo.uicli.binding.JUCtrlActionBindingListener;
import oracle.jbo.uicli.binding.JUCtrlActionDef;
import oracle.jbo.uicli.binding.JUCtrlAttrsBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public class JUCtrlActionBinding
extends JUControlBinding
implements OperationBinding {
    public static final int ACTION_EXECUTE = 0;
    public static final int ACTION_FIND = 1;
    public static final int ACTION_BINDING_CONTAINER_EXECUTE = 0;
    public static final int ACTION_BINDING_CONTAINER_FIND = 1;
    public static final int ACTION_ITERATOR_BINDING_EXECUTE = 2;
    public static final int ACTION_ITERATOR_BINDING_FIND = 3;
    public static final int ACTION_NEXT = 10;
    public static final int ACTION_PREVIOUS = 11;
    public static final int ACTION_FIRST = 12;
    public static final int ACTION_LAST = 13;
    public static final int ACTION_NEXT_SET = 14;
    public static final int ACTION_PREVIOUS_SET = 15;
    public static final int ACTION_RESET = 20;
    public static final int ACTION_EXECUTE_WITH_PARAMS = 95;
    public static final int ACTION_REMOVE_CURRENT_ROW = 30;
    public static final int ACTION_CREATE_INSERT_ROW = 40;
    public static final int ACTION_CREATE_ROW = 41;
    public static final int ACTION_SETCURRENTROW_WITH_KEY = 96;
    public static final int ACTION_SETCURRENTROW_WITH_KEYVALUE = 98;
    public static final int ACTION_REMOVEROW_WITH_KEY = 99;
    public static final int ACTION_COMMIT_TRANSACTION = 100;
    public static final int ACTION_ROLLBACK_TRANSACTION = 101;
    public static final int ACTION_RESET_STATE = 102;
    public static final int ACTION_INVOKE_METHOD = 999;
    private DCDataControl mDataControl;
    private int mAction;
    private DCInvokeMethod mMethod;
    private ArrayList mActionBindingListeners;
    final byte TYPE_ROW_ITERATOR;
    final byte TYPE_ARRAY_ITERATOR;
    byte mIteratorBindingType;
    private ArrayList mParams;
    private Object mRetVal;
    private HashMap mParamMap;
    private JboException mErrExc;
    private int mAuthorized;
    static final JUActionDef[] mActionDefs = new JUActionDef[]{new JUActionDef(0, "execute"), new JUActionDef(1, "find"), new JUActionDef(2, "iteratorExecute"), new JUActionDef(3, "iteratorFind"), new JUActionDef(10, "next"), new JUActionDef(11, "previous"), new JUActionDef(12, "first"), new JUActionDef(13, "last"), new JUActionDef(20, "reset"), new JUActionDef(14, "nextSet"), new JUActionDef(15, "previousSet"), new JUActionDef(30, "removeCurrentRow"), new JUActionDef(95, "executeWithParams"), new JUActionDef(40, "createInsertRow"), new JUActionDef(41, "createRow"), new JUActionDef(100, "commitTransaction"), new JUActionDef(101, "rollbackTransaction"), new JUActionDef(102, "resetState"), new JUActionDef(96, "setCurrentRowWithKey"), new JUActionDef(98, "setCurrentRowWithKeyValue"), new JUActionDef(99, "removeRowWithKey"), new JUActionDef(999, "invokeMethod")};
    private static final String ATTR_PARAMS = "params";
    private static final String ATTR_PARAMSMAP = "paramsMap";
    private static final String ATTR_RETVAL = "result";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_ENABLED_STRING = "enabledString";
    private static final String ATTR_ACTION_ENABLED = "actionEnabled";
    private static final String ATTR_ACTION_ID = "actionId";
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

    private /* synthetic */ void $init$() {
        this.TYPE_ROW_ITERATOR = 0;
        this.TYPE_ARRAY_ITERATOR = 1;
        this.mIteratorBindingType = 0;
        this.mAuthorized = -1;
    }

    public JUCtrlActionBinding(Object object, DCBindingContainer dCBindingContainer, DCInvokeMethodDef dCInvokeMethodDef) {
        super(object, null);
        this.$init$();
        this.mAction = 999;
        this.setupMethodInfo(dCBindingContainer, dCInvokeMethodDef);
        this.setBindingContainer(dCBindingContainer);
    }

    public JUCtrlActionBinding(Object object, DCIteratorBinding dCIteratorBinding, int n) {
        super(object, dCIteratorBinding);
        this.$init$();
        this.mAction = n;
        if (n == 999) {
            throw new InvalidParamException("JUCtrlActionBinding", "action", Integer.toString(n));
        }
        if (dCIteratorBinding != null) {
            dCIteratorBinding.addActionBinding(this);
        }
    }

    public JUCtrlActionBinding(Object object, DCDataControl dCDataControl, int n) {
        super(object, null);
        this.$init$();
        switch (n) {
            case 100: 
            case 101: 
            case 102: {
                break;
            }
            default: {
                throw new InvalidParamException("JUCtrlActionBinding", "action", Integer.toString(n));
            }
        }
        this.mAction = n;
        this.mDataControl = dCDataControl;
    }

    public String getEnabledString() {
        if (this.isActionEnabled()) {
            return "";
        }
        return "disabled";
    }

    protected void setupMethodInfo(DCBindingContainer dCBindingContainer, DCInvokeMethodDef dCInvokeMethodDef) {
        this.mMethod = dCInvokeMethodDef.createMethodInstance(dCBindingContainer, this);
    }

    public boolean isActionEnabled() {
        return this.isOperationEnabled();
    }

    public boolean isOperationEnabled() {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        DCDataControl dCDataControl = this.getDataControl();
        if (!this.internalCheckPermission(0, false) || !this.internalCheckPermission(this.mAction, false)) {
            return false;
        }
        if (jUIteratorBinding == null || !jUIteratorBinding.isIteratorMadeVisible()) {
            switch (this.mAction) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: {
                    return jUIteratorBinding != null && jUIteratorBinding.getDataControl() != null && !jUIteratorBinding.getDataControl().isJClientApp();
                }
                case 30: {
                    return false;
                }
                case 2: 
                case 3: 
                case 40: 
                case 41: {
                    if (jUIteratorBinding == null || jUIteratorBinding.getDataControl() == null || !jUIteratorBinding.getDataControl().isJClientApp()) break;
                    return false;
                }
            }
        }
        switch (this.mAction) {
            case 2: {
                if (jUIteratorBinding == null) {
                    return false;
                }
            }
            case 0: {
                if (jUIteratorBinding == null) {
                    return false;
                }
                return jUIteratorBinding.isOperationSupported((byte)5);
            }
            case 3: {
                if (jUIteratorBinding == null) {
                    return false;
                }
            }
            case 1: {
                if (jUIteratorBinding == null) {
                    return false;
                }
                return jUIteratorBinding.isOperationSupported((byte)3);
            }
            case 10: 
            case 13: {
                try {
                    NavigatableRowIterator navigatableRowIterator;
                    if (jUIteratorBinding.isAlive() && (jUIteratorBinding.hasRSI() || jUIteratorBinding.isFindMode() || jUIteratorBinding.refreshIfNeeded()) && (navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator()) != null) {
                        boolean bl = navigatableRowIterator.hasNext();
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (RowNotAvailableException rowNotAvailableException) {
                    boolean bl = false;
                    return bl;
                }
            }
            case 11: 
            case 12: {
                NavigatableRowIterator navigatableRowIterator;
                if (jUIteratorBinding.isAlive() && (jUIteratorBinding.hasRSI() || jUIteratorBinding.isFindMode() || jUIteratorBinding.refreshIfNeeded()) && (navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator()) != null) {
                    return navigatableRowIterator.hasPrevious();
                }
                return false;
            }
            case 14: {
                NavigatableRowIterator navigatableRowIterator;
                if (jUIteratorBinding.isAlive() && (jUIteratorBinding.hasRSI() || jUIteratorBinding.refreshIfNeeded()) && (navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator()) != null) {
                    return navigatableRowIterator.isRangeAtBottom() ^ true;
                }
                return false;
            }
            case 15: {
                NavigatableRowIterator navigatableRowIterator;
                if (jUIteratorBinding.isAlive() && (jUIteratorBinding.hasRSI() || jUIteratorBinding.refreshIfNeeded()) && (navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator()) != null) {
                    return navigatableRowIterator.isRangeAtTop() ^ true;
                }
                return false;
            }
            case 20: {
                if (jUIteratorBinding == null) {
                    return false;
                }
                return jUIteratorBinding.getCurrentRow() != null;
            }
            case 30: {
                NavigatableRowIterator navigatableRowIterator;
                if (jUIteratorBinding == null || !jUIteratorBinding.isAlive()) {
                    return false;
                }
                if (jUIteratorBinding.isOperationSupported((byte)2) && (jUIteratorBinding.hasRSI() || jUIteratorBinding.isFindMode() || jUIteratorBinding.refreshIfNeeded()) && (navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator()) != null) {
                    return navigatableRowIterator.getCurrentRowSlot() == 0;
                }
                return false;
            }
            case 95: {
                return jUIteratorBinding != null;
            }
            case 40: 
            case 41: {
                if (jUIteratorBinding == null) {
                    return false;
                }
                if (jUIteratorBinding.isAlive()) {
                    jUIteratorBinding.refreshIfNeeded();
                    return jUIteratorBinding.isOperationSupported((byte)1);
                }
                return false;
            }
            case 100: 
            case 101: {
                return dCDataControl != null && dCDataControl.isTransactionModified();
            }
        }
        return true;
    }

    public final DCDataControl getDataControl() {
        if (this.mDataControl == null) {
            BindingContext bindingContext;
            String string;
            if (this.getDef() instanceof JUCtrlActionDef && (string = ((JUCtrlActionDef)this.getDef()).getDataControlName()) != null && this.getBindingContainer() != null && (bindingContext = this.getBindingContainer().getBindingContext()) != null) {
                DCDataControl dCDataControl;
                this.mDataControl = dCDataControl = bindingContext.findDataControl(string);
                if (this.getIteratorBinding() == null) {
                    JUFormBinding jUFormBinding = this.getFormBinding();
                    if (dCDataControl != null && jUFormBinding != null && dCDataControl != jUFormBinding.internalGetDataControl()) {
                        dCDataControl.addBindingContainer(jUFormBinding);
                    }
                }
            }
            if (this.mDataControl == null) {
                if (this.getIteratorBinding() != null) {
                    this.mDataControl = this.getIteratorBinding().getDataControl();
                } else if (this.getBindingContainer() != null) {
                    this.mDataControl = this.getBindingContainer().getDataControl();
                }
            }
        }
        return this.mDataControl;
    }

    public static int actionNameToId(String string) {
        int n = 0;
        while (n < mActionDefs.length) {
            if (JUCtrlActionBinding.mActionDefs[n].mStr.equals(string)) {
                return JUCtrlActionBinding.mActionDefs[n].mId;
            }
            ++n;
        }
        return -1;
    }

    public static String actionIdToName(int n) {
        int n2 = 0;
        while (n2 < mActionDefs.length) {
            if (JUCtrlActionBinding.mActionDefs[n2].mId == n) {
                return JUCtrlActionBinding.mActionDefs[n2].mStr;
            }
            ++n2;
        }
        return null;
    }

    Component getParentFrame() {
        Object object = this.getControl();
        if (object instanceof Component) {
            Component component = (Component)object;
            while (component != null && !(component instanceof Frame)) {
                component = component.getParent();
            }
            if (component instanceof Frame) {
                return component;
            }
        }
        return null;
    }

    public Object execute() {
        this.resetInputState();
        this.invoke();
        return this.mErrExc == null ? this.mRetVal : null;
    }

    public final void invoke() {
        int n;
        JUCtrlActionBindingEvent jUCtrlActionBindingEvent = null;
        ArrayList arrayList = null;
        int n2 = 0;
        if (this.mActionBindingListeners != null && this.mActionBindingListeners.size() > 0) {
            jUCtrlActionBindingEvent = this.createActionBindingEvent();
            arrayList = (ArrayList)this.mActionBindingListeners.clone();
            n2 = arrayList.size();
            n = 0;
            while (n < n2) {
                ((JUCtrlActionBindingListener)arrayList.get(n)).beforeActionPerformed(jUCtrlActionBindingEvent);
                ++n;
            }
        }
        this.internalCheckPermission(this.mAction, true);
        if (this.getDataControl() != null) {
            this.getDataControl().invokeOperation(this.getDataControl().getBindingContext(), this);
        } else {
            this.doIt();
        }
        if (jUCtrlActionBindingEvent != null) {
            n = 0;
            while (n < n2) {
                ((JUCtrlActionBindingListener)arrayList.get(n)).afterActionPerformed(jUCtrlActionBindingEvent);
                ++n;
            }
        }
    }

    public List getErrors() {
        ArrayList<JboException> arrayList = new ArrayList<JboException>();
        JboException jboException = this.getError();
        if (jboException != null) {
            arrayList.add(jboException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doIt() {
        this.resetInputState();
        var1_1 = this.getIteratorBinding();
        var2_2 = null;
        v0 = var3_3 = var1_1 != null ? var1_1.getSyncLock() : this.getBindingContainer();
        if (var3_3 == null) {
            var3_3 = this;
        }
        var42_4 = var3_3;
        synchronized (var42_4) {
            block117: {
                block116: {
                    block115: {
                        block114: {
                            block113: {
                                block112: {
                                    block111: {
                                        block110: {
                                            var4_5 = null;
                                            var5_6 = this.getParentFrame();
                                            var2_2 = this.getBindingContainer();
                                            var6_7 = var2_2 != null ? var2_2.isErrorHandlerActive() : false;
                                            try {
                                                try {
                                                    if (var5_6 != null) {
                                                        var5_6.setCursor(Cursor.getPredefinedCursor(3));
                                                    }
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(false);
                                                    }
                                                    switch (this.mAction) {
                                                        case 0: {
                                                            v1 = var7_8 = var2_2 != null && var2_2.isFindMode() != false;
                                                            if (var7_8) {
                                                                var2_2.setFindMode(false, true);
                                                            }
                                                            try {
                                                                var2_2.execute();
                                                            }
                                                            catch (Exception var8_9) {
                                                                if (var7_8) {
                                                                    try {
                                                                        var2_2.setFindMode(true, false);
                                                                    }
                                                                    catch (Exception var9_10) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                if (var8_9 instanceof JboException) {
                                                                    var10_11 = (JboException)var8_9;
                                                                    throw var10_11;
                                                                }
                                                                var10_11 = new JboException((Throwable)var8_9);
                                                                throw var10_11;
                                                            }
                                                            var44_12 = null;
                                                            this.mParamMap = null;
                                                            if (var6_7) {
                                                                var2_2.setErrorHandlerActive(var6_7);
                                                            }
                                                            if (var5_6 == null) return;
                                                            var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                                            return;
                                                        }
                                                        case 1: {
                                                            if (var2_2 != null) {
                                                                var2_2.setFindMode(var2_2.isFindMode() ^ true, false);
                                                            }
                                                            break block110;
                                                        }
                                                        case 2: {
                                                            if (var1_1 == null) break block111;
                                                            var11_24 = var1_1.isFindMode();
                                                            if (var11_24) {
                                                                var1_1.setFindMode(false, true);
                                                            }
                                                            try {
                                                                var1_1.executeQuery();
                                                                if (var1_1.getDataControl().syncNeeded()) {
                                                                    var1_1.getDataControl().sync("JUCtrlActionBinding.doIt().iteratorExecute");
                                                                }
                                                                break block111;
                                                            }
                                                            catch (Exception var12_25) {
                                                                if (var11_24) {
                                                                    try {
                                                                        var1_1.setFindMode(true, false);
                                                                    }
                                                                    catch (Exception var13_26) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                if (var12_25 instanceof JboException) {
                                                                    var14_27 = (JboException)var12_25;
                                                                    throw var14_27;
                                                                }
                                                                var14_27 = new JboException((Throwable)var12_25);
                                                                throw var14_27;
                                                            }
                                                        }
                                                        case 3: {
                                                            if (var1_1 != null) {
                                                                var1_1.setFindMode(var1_1.isFindMode() ^ true, false);
                                                            }
                                                            break block112;
                                                        }
                                                        case 10: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                            }
                                                            if (var2_2 != null) {
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            if (!var4_5.hasNext()) break;
                                                            if (!var1_1.getDataControl().syncNeeded()) {
                                                                var4_5.next();
                                                                ** break;
                                                            }
                                                            try {
                                                                var4_5.next();
                                                            }
                                                            catch (RowNotAvailableException var15_28) {
                                                                var1_1.internalGetNextRangeSet();
                                                            }
                                                            break;
                                                        }
                                                        case 11: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            if (!var4_5.hasPrevious()) break;
                                                            if (!var1_1.getDataControl().syncNeeded()) {
                                                                var4_5.previous();
                                                                ** break;
                                                            }
                                                            try {
                                                                var4_5.previous();
                                                            }
                                                            catch (RowNotAvailableException var16_29) {
                                                                var1_1.internalGetPreviousRangeSet();
                                                            }
                                                            break;
                                                        }
                                                        case 12: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            if (!var1_1.getDataControl().syncNeeded()) {
                                                                var4_5.first();
                                                                ** break;
                                                            }
                                                            try {
                                                                var4_5.first();
                                                            }
                                                            catch (RowNotAvailableException var17_30) {
                                                                ((RowSetIterator)var4_5).scrollRange(-2147483648);
                                                                var1_1.getDataControl().sync("JUCtrlActionBinding.doIt().first after RowNotAvailableException");
                                                                var4_5.first();
                                                            }
                                                            break;
                                                        }
                                                        case 13: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            if (!var1_1.getDataControl().syncNeeded()) {
                                                                var4_5.last();
                                                                ** break;
                                                            }
                                                            try {
                                                                var4_5.last();
                                                            }
                                                            catch (RowNotAvailableException var18_31) {
                                                                ((RowSetIterator)var4_5).scrollRange(0x7FFFFFFF);
                                                                var1_1.getDataControl().sync("JUCtrlActionBinding.doIt().last after RowNotAvailableException");
                                                                var4_5.last();
                                                            }
                                                            break;
                                                        }
                                                        case 14: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                            }
                                                            if (var4_5.isRangeAtBottom()) break;
                                                            if (var2_2 != null) {
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            ((RowSetIterator)var4_5).getNextRangeSet();
                                                            ** break;
                                                        }
                                                        case 15: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02528", new Object[]{var1_1.getDisplayName()});
                                                            }
                                                            if (var4_5.isRangeAtTop()) break;
                                                            if (var2_2 != null) {
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            ((RowSetIterator)var4_5).getPreviousRangeSet();
                                                            ** break;
                                                        }
                                                        case 20: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (var2_2 != null) {
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            var4_5.reset();
                                                            ** break;
                                                        }
                                                        case 30: {
                                                            if (var1_1 == null) break;
                                                            var4_5 = this.getRowIterator();
                                                            var1_1.removeCurrentRow();
                                                            if (!var1_1.isFindMode() || (var19_32 = var1_1.getDataControl()).syncNeeded() || (var20_33 = var19_32.getApplicationModule()) == null || !var20_33.getSession().isClient()) break;
                                                            var1_1.getViewObject().applyViewCriteria((ViewCriteria)var4_5);
                                                            ** break;
                                                        }
                                                        case 40: 
                                                        case 41: {
                                                            var4_5 = this.getRowIterator();
                                                            if (var4_5 == null) break;
                                                            if (!var1_1.isRefreshed()) {
                                                                var1_1.refreshIfNeeded();
                                                            }
                                                            if ((var21_34 = var4_5.createRow()) == null) break;
                                                            var22_35 = var1_1.getDataControl();
                                                            if (var2_2 != null) {
                                                                var2_2.callBeforeRowNavigated(var1_1);
                                                            }
                                                            var23_36 = var1_1.isFindMode();
                                                            v2 = var24_37 = this.mAction == 40 || var23_36 != false;
                                                            if (!var24_37) {
                                                                v3 = var24_37 = var1_1.getViewObject() == null;
                                                            }
                                                            if (var24_37) {
                                                                var4_5.insertRow(var21_34);
                                                                if (var23_36) {
                                                                    if (var22_35.syncNeeded()) {
                                                                        var22_35.getViewCriteria(var1_1);
                                                                        ** break;
                                                                    }
                                                                    var25_38 = var22_35.getApplicationModule();
                                                                    if (var25_38 == null || !var25_38.getSession().isClient()) break;
                                                                    var1_1.getViewObject().applyViewCriteria((ViewCriteria)var4_5);
                                                                    ** break;
                                                                }
                                                                var21_34.setNewRowState((byte)-1);
                                                                ** break;
                                                            }
                                                            var21_34.setNewRowState((byte)-1);
                                                            var1_1.cacheCreatedRow((RowSetIterator)var4_5, var21_34);
                                                            ** break;
                                                        }
                                                        case 100: {
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02529", null);
                                                                var26_39 = this.getDataControl();
                                                                if (var26_39 != null) {
                                                                    var26_39.callCommitTransaction();
                                                                } else {
                                                                    this.getApplicationModule().getTransaction().commit();
                                                                }
                                                                if (var26_39.isTransactionModified()) {
                                                                    var2_2.displayStatus(var1_1, "02532", null);
                                                                } else {
                                                                    var2_2.displayStatus(var1_1, "02530", null);
                                                                }
                                                            }
                                                            var27_40 = var2_2.getCtrlBindingList();
                                                            var30_41 = 0;
                                                            while (true) {
                                                                if (var30_41 >= var27_40.size()) {
                                                                    break block113;
                                                                }
                                                                var28_42 = var27_40.get(var30_41);
                                                                if (var28_42 instanceof JUCtrlAttrsBinding) {
                                                                    var29_43 = (JUCtrlAttrsBinding)var28_42;
                                                                    var29_43.refreshControl();
                                                                }
                                                                ++var30_41;
                                                            }
                                                        }
                                                        case 101: {
                                                            if (var2_2 != null) {
                                                                var2_2.displayStatus(var1_1, "02533", null);
                                                                var31_44 = this.getDataControl();
                                                                if (var31_44 != null) {
                                                                    var31_44.rollbackTransaction();
                                                                } else {
                                                                    this.getApplicationModule().getTransaction().rollback();
                                                                }
                                                                if (var2_2.isExecuteOnRollback()) {
                                                                    var2_2.getRootBindingContainer().execute();
                                                                }
                                                                var2_2.displayStatus(var1_1, "02534", null);
                                                            }
                                                            break block114;
                                                        }
                                                        case 102: {
                                                            var32_45 = this.getDataControl();
                                                            if (var32_45 != null) {
                                                                var32_45.resetState();
                                                            }
                                                            break block115;
                                                        }
                                                        case 95: {
                                                            if (var1_1 != null) {
                                                                var33_46 = var1_1.getDataControl();
                                                                var34_47 = this.mMethod.fetchParameterValues(this.getDataControl().getBindingContext(), this.resolveParamsMap());
                                                                var33_46.executeIteratorBindingWithParams(var1_1, this.mMethod.getParameters(), var34_47);
                                                                ** break;
                                                            }
                                                        }
                                                        case 96: {
                                                            if (var1_1 == null || (var35_48 = this.mMethod.fetchParameterValues(this.getDataControl().getBindingContext(), this.resolveParamsMap())).length <= 0) break;
                                                            var1_1.setCurrentRowWithKey((String)var35_48[0]);
                                                            ** break;
                                                        }
                                                        case 98: {
                                                            if (var1_1 == null || (var36_49 = this.mMethod.fetchParameterValues(this.getDataControl().getBindingContext(), this.resolveParamsMap())).length <= 0) break;
                                                            var1_1.setCurrentRowWithKeyValue((String)var36_49[0]);
                                                            ** break;
                                                        }
                                                        case 99: {
                                                            if (var1_1 == null || (var37_50 = this.mMethod.fetchParameterValues(this.getDataControl().getBindingContext(), this.resolveParamsMap())).length <= 0) break;
                                                            var1_1.removeRowWithKey((String)var37_50[0]);
                                                            ** break;
                                                        }
                                                        case 999: {
                                                            if (Diagnostic.isOn()) {
                                                                Diagnostic.println((String)("Invoke method Action:" + this.mAction));
                                                            }
                                                            this.mRetVal = null;
                                                            var38_51 = this.getDataControl();
                                                            this.mRetVal = this.mMethod.callMethod(var38_51, this, this.resolveParamsMap());
                                                            this.mParams = null;
                                                            ** break;
                                                        }
                                                        default: {
                                                            Diagnostic.println((String)("Action " + this.mAction + " not recognized"));
                                                            break;
                                                        }
                                                    }
                                                    break block116;
                                                }
                                                catch (JboException var39_52) {
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    this.reportException((Exception)var39_52);
                                                    var44_20 = null;
                                                    this.mParamMap = null;
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    if (var5_6 == null) return;
                                                    var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                                    break block117;
                                                }
                                                catch (Exception var40_53) {
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    this.reportException(var40_53);
                                                    var44_21 = null;
                                                    this.mParamMap = null;
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    if (var5_6 == null) return;
                                                    var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                                    break block117;
                                                }
                                                catch (Throwable var41_54) {
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    this.reportException((Exception)new JboException(var41_54));
                                                    var44_22 = null;
                                                    this.mParamMap = null;
                                                    if (var6_7) {
                                                        var2_2.setErrorHandlerActive(var6_7);
                                                    }
                                                    if (var5_6 == null) return;
                                                    var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                                    break block117;
                                                }
lbl334:
                                                // 17 sources

                                                break block116;
                                            }
                                            catch (Throwable var43_55) {
                                                var44_23 = null;
                                                this.mParamMap = null;
                                                if (var6_7) {
                                                    var2_2.setErrorHandlerActive(var6_7);
                                                }
                                                if (var5_6 == null) throw var43_55;
                                                var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                                throw var43_55;
                                            }
                                        }
                                        var44_13 = null;
                                        this.mParamMap = null;
                                        if (var6_7) {
                                            var2_2.setErrorHandlerActive(var6_7);
                                        }
                                        if (var5_6 == null) return;
                                        var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                        return;
                                    }
                                    var44_14 = null;
                                    this.mParamMap = null;
                                    if (var6_7) {
                                        var2_2.setErrorHandlerActive(var6_7);
                                    }
                                    if (var5_6 == null) return;
                                    var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                    return;
                                }
                                var44_15 = null;
                                this.mParamMap = null;
                                if (var6_7) {
                                    var2_2.setErrorHandlerActive(var6_7);
                                }
                                if (var5_6 == null) return;
                                var5_6.setCursor(Cursor.getPredefinedCursor(0));
                                return;
                            }
                            var44_16 = null;
                            this.mParamMap = null;
                            if (var6_7) {
                                var2_2.setErrorHandlerActive(var6_7);
                            }
                            if (var5_6 == null) return;
                            var5_6.setCursor(Cursor.getPredefinedCursor(0));
                            return;
                        }
                        var44_17 = null;
                        this.mParamMap = null;
                        if (var6_7) {
                            var2_2.setErrorHandlerActive(var6_7);
                        }
                        if (var5_6 == null) return;
                        var5_6.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    var44_18 = null;
                    this.mParamMap = null;
                    if (var6_7) {
                        var2_2.setErrorHandlerActive(var6_7);
                    }
                    if (var5_6 == null) return;
                    var5_6.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                var44_19 = null;
                this.mParamMap = null;
                if (var6_7) {
                    var2_2.setErrorHandlerActive(var6_7);
                }
                if (var5_6 == null) return;
                var5_6.setCursor(Cursor.getPredefinedCursor(0));
            }
            return;
        }
    }

    private Map resolveParamsMap() {
        OperationParameter[] operationParameterArray;
        HashMap hashMap;
        HashMap hashMap2 = hashMap = this.mParamMap != null ? this.mParamMap : new HashMap(6);
        if (this.mParams != null && (operationParameterArray = this.mMethod.getParameters()) != null && this.mParams != null) {
            int n = Math.min(operationParameterArray.length, this.mParams.size());
            int n2 = 0;
            while (n2 < n) {
                if (this.mParams.get(n2) != null) {
                    hashMap.put(operationParameterArray[n2].getName(), this.mParams.get(n2));
                }
                ++n2;
            }
        }
        this.mParamMap = hashMap;
        return hashMap;
    }

    public void setArrayIteratorType() {
        this.mIteratorBindingType = 1;
    }

    public boolean isArrayIteratorType() {
        return this.mIteratorBindingType == 1;
    }

    public void refreshControl() {
    }

    public boolean ignoreUpdates() {
        JUCtrlActionDef jUCtrlActionDef = (JUCtrlActionDef)this.getDef();
        if (jUCtrlActionDef != null) {
            return jUCtrlActionDef.requiresUpdateModel() ^ true;
        }
        return JUCtrlActionDef.getDefaultValueForUpdateModel(this.mAction) ^ true;
    }

    public int getActionId() {
        return this.mAction;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
    }

    public OperationInfo getOperationInfo() {
        return this.mMethod;
    }

    DCInvokeMethod getInvokeMethod() {
        return this.mMethod;
    }

    public DCInvokeMethodDef getInvokeMethodDef() {
        return this.mMethod != null ? this.mMethod.getDef() : null;
    }

    public void setInvoke(Object object) {
        this.invoke();
    }

    protected void initResources() {
    }

    protected void resetInputState() {
        this.removeFromDCExceptions();
        this.mErrExc = null;
    }

    public JboException getError() {
        if (this.mErrExc != null) {
            this.mErrExc.setLocaleContext(this.getBindingContainer().getLocaleContext());
        }
        return this.mErrExc;
    }

    public final Boolean getEnabled() {
        return this.isActionEnabled();
    }

    public final String getPath() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getFullName().replace('.', '/')).append('/').append("invoke");
        return stringBuffer.toString();
    }

    public boolean resolvePath(Map map) {
        if (map != null) {
            return map.containsKey(this.getPath());
        }
        return false;
    }

    protected Object internalGet(String string) {
        if (ATTR_ACTION_ENABLED == string) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isActionEnabled());
        }
        if (ATTR_ENABLED_STRING == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getEnabledString();
        }
        if (ATTR_PARAMS == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getParams();
        }
        if (ATTR_PARAMSMAP == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getParamsMap();
        }
        if (ATTR_RETVAL == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getResult();
        }
        if (ATTR_ENABLED == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getEnabled();
        }
        if (ATTR_PATH == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getPath();
        }
        if (ATTR_ACTION_ID == string) {
            this.mInternalGet_KeyResolved = true;
            return new Integer(this.getActionId());
        }
        return super.internalGet(string);
    }

    public Map getParamsMap() {
        return this.resolveParamsMap();
    }

    public Object getResult() {
        DCInvokeMethodDef dCInvokeMethodDef = ((JUCtrlActionDef)this.getDef()).getMethodDef();
        if (dCInvokeMethodDef != null && dCInvokeMethodDef.getReturnName() != null) {
            this.mRetVal = DCUtil.findContextObject(this.getDataControl().getBindingContext(), dCInvokeMethodDef.getReturnName());
        }
        return this.mRetVal;
    }

    public ArrayList getParams() {
        return this.mParams;
    }

    public void setParams(ArrayList arrayList) {
        this.mParams = arrayList != null ? (ArrayList)arrayList.clone() : null;
    }

    public void reportException(Exception exception) {
        if (exception == null) {
            return;
        }
        JboException jboException = exception instanceof JboException ? (JboException)((Object)exception) : new JboException((Throwable)exception);
        this.mErrExc = jboException;
        this.addToDCExceptions(jboException);
        super.reportException(exception);
    }

    public void release(int n) {
        if (this.mMethod != null) {
            this.mMethod.release(n);
        }
        this.mDataControl = null;
        super.release(n);
    }

    boolean internalCheckPermission(int n, boolean bl) {
        boolean bl2;
        if (!PermissionHelper.isAuthorizationEnabled()) {
            return true;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        DCDataControl dCDataControl = this.getDataControl();
        if (dCDataControl == null) {
            return true;
        }
        boolean bl3 = bl2 = this.mAuthorized != 0;
        if (this.mAuthorized == -1) {
            if (n == 999 && this.mMethod != null) {
                bl2 = dCDataControl.hasPermission(this, this.getPermissionTargetName(), "Invoke");
            } else if (jUIteratorBinding != null) {
                switch (n) {
                    case 30: {
                        bl2 = dCDataControl.hasPermission(this, this.getPermissionTargetName(), "Delete");
                        break;
                    }
                    case 40: 
                    case 41: {
                        bl2 = dCDataControl.hasPermission(this, this.getPermissionTargetName(), "Create");
                        break;
                    }
                    case 99: {
                        bl2 = dCDataControl.hasPermission(this, this.getPermissionTargetName(), "Delete");
                        break;
                    }
                    default: {
                        bl2 = dCDataControl.hasPermission(this, this.getPermissionTargetName(), null);
                    }
                }
            }
            if (n == this.mAction) {
                int n2 = this.mAuthorized = bl2 ? 1 : 0;
            }
        }
        if (!bl2 && bl) {
            Class clazz = class$oracle$adf$model$ADFmMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$adf$model$ADFmMessageBundle = JUCtrlActionBinding.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new InvalidOperException(clazz, "35108", new Object[]{JUCtrlActionBinding.actionIdToName(n)});
        }
        return bl2;
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            this.mPermissionInfo = this.mMethod != null ? new PermissionBinding(this.getPermissionTargetName(), 3) : new PermissionBinding(this.getPermissionTargetName(), 1);
        }
        return this.mPermissionInfo;
    }

    public String getPermissionTargetName() {
        if (this.mAction == 999 && this.mMethod != null) {
            return this.mMethod.getPermissionTargetName();
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null) {
            return jUIteratorBinding.getPermissionTargetName();
        }
        return null;
    }

    protected boolean internalHasPermission(String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = PermissionHelper.getPermissionClassName(this.mMethod != null && (this.mAction == 999 || JUCtrlActionBinding.actionNameToId(this.mMethod.getOperationName()) == 999) ? 3 : 1);
        if (string2 == null) {
            String string4 = string2 = string3.equals(PermissionHelper.getPermissionClassName(1)) ? "Read" : "Invoke";
        }
        if (string2 == null) {
            string2 = string3.equals(PermissionHelper.getPermissionClassName(1)) ? "Read" : "Invoke";
        }
        Permission permission = (Permission)PermissionHelper.createPermissionInstance(string3, string, string2);
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        DCDataControl dCDataControl = this.getDataControl();
        if (jUIteratorBinding != null) {
            dCDataControl = jUIteratorBinding.getDataControl();
        }
        return dCDataControl != null && PermissionHelper.hasPermission(dCDataControl.getSecurityContext(), permission);
    }

    public void addInvokeMethodListener(DCInvokeMethodListener dCInvokeMethodListener) {
        if (this.mMethod != null) {
            this.mMethod.addInvokeMethodListener(dCInvokeMethodListener);
        }
    }

    public void removeInvokeMethodListener(DCInvokeMethodListener dCInvokeMethodListener) {
        if (this.mMethod != null) {
            this.mMethod.removeInvokeMethodListener(dCInvokeMethodListener);
        }
    }

    public final ArrayList getActionBindingListeners() {
        return this.mActionBindingListeners != null ? (ArrayList)this.mActionBindingListeners.clone() : new ArrayList(0);
    }

    protected JUCtrlActionBindingEvent createActionBindingEvent() {
        return new JUCtrlActionBindingEvent(this);
    }

    public final void addActionBindingListener(JUCtrlActionBindingListener jUCtrlActionBindingListener) {
        if (this.mActionBindingListeners == null) {
            this.mActionBindingListeners = new ArrayList(4);
        }
        if (!this.mActionBindingListeners.contains(jUCtrlActionBindingListener)) {
            this.mActionBindingListeners.add(jUCtrlActionBindingListener);
        }
    }

    public final void removeActionBindingListener(JUCtrlActionBindingListener jUCtrlActionBindingListener) {
        if (this.mActionBindingListeners != null) {
            this.mActionBindingListeners.remove(jUCtrlActionBindingListener);
            if (this.mActionBindingListeners.size() == 0) {
                this.mActionBindingListeners = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

