/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic;

import com.sun.java.util.collections.HashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import oracle.adf.model.generic.AttributeDefImpl;
import oracle.adf.model.generic.BeanUtils;
import oracle.adf.model.generic.DCGenericRowContext;
import oracle.adf.model.generic.DCGenericRowSetIteratorImpl;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.Row;
import oracle.jbo.StructureDef;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.TypeFactory;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RowImpl
implements Row {
    private DCRowSetIteratorImpl mRSI;
    private BitSet mChanged;
    private int mChangedCount;
    private int mPKChangedCount;
    private Object mRowDataProvider;
    private Key mCachedKey;
    static final int PS_NEW = 0;
    static final int PS_CLEAN = 1;
    static final int PS_MODIFIED = 2;
    static final int PS_DELETED = 3;
    static final int PS_DEAD = 4;
    static final int PS_LAZY = 5;
    private int mRowState;
    private static final int DEFAULT_NUM_CHANGED_BITS = 4;
    static final byte PROVIDER_MAP = 0;
    static final byte PROVIDER_BEAN = 1;
    static final byte PROVIDER_SCALAR = 2;
    private byte mProviderType;
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

    private /* synthetic */ void $init$() {
        this.mChanged = null;
        this.mChangedCount = 0;
        this.mPKChangedCount = 0;
        this.mRowState = 1;
        this.mProviderType = 0;
    }

    final boolean isProviderMap() {
        return this.mProviderType == 0;
    }

    protected RowImpl(Object object, DCRowSetIteratorImpl dCRowSetIteratorImpl) {
        this.$init$();
        if (object == null) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)"Fatal Error: Creating a row over Null bean or map will lead to NPEs");
            }
            if ((clazz = class$oracle$adf$model$ADFmMessageBundle) == null) {
                clazz = class$oracle$adf$model$ADFmMessageBundle = RowImpl.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new InvalidParamException(clazz, "35008", new Object[]{dCRowSetIteratorImpl.getStructureDef().getFullName()});
        }
        this.mRowDataProvider = object;
        this.mRSI = dCRowSetIteratorImpl;
        this.mPKChangedCount = 0;
        this.mProviderType = object instanceof Map ? (byte)0 : 1;
    }

    public boolean equals(Object object) {
        if (object instanceof RowImpl) {
            RowImpl rowImpl = (RowImpl)object;
            if (this.mRowDataProvider != null && rowImpl.mRowDataProvider != null && this.mRowDataProvider.equals(rowImpl.mRowDataProvider)) {
                return true;
            }
        }
        return super.equals(object);
    }

    boolean belongsTo(Object object) {
        return object == this.mRSI;
    }

    public Object getAttribute(int n) {
        return this.internalGetAttributeValue(this.getStructureDef().getAttributeDef(n));
    }

    public Object getAttribute(String string) {
        AttributeDef attributeDef = this.getStructureDef().findAttributeDef(string);
        if (attributeDef != null) {
            return this.internalGetAttributeValue(attributeDef);
        }
        return null;
    }

    private Object internalGetAttributeValue(AttributeDef attributeDef) {
        Object object;
        String string = attributeDef.getColumnName();
        switch (this.mProviderType) {
            case 0: {
                object = ((Map)this.mRowDataProvider).get(string);
                break;
            }
            case 2: {
                object = this.mRowDataProvider;
                break;
            }
            default: {
                object = BeanUtils.getProperty((Object)this.mRowDataProvider, (String)string);
            }
        }
        Class clazz = attributeDef.getJavaType();
        if (clazz != null) {
            object = TypeFactory.convertAttributeValueToType((AttributeDef)attributeDef, (Class)attributeDef.getJavaType(), (Object)object, (int)181, (String)"");
        }
        return object;
    }

    public boolean isAttributeUpdateable(int n) {
        AttributeDef[] attributeDefArray;
        StructureDef structureDef = this.getStructureDef();
        if (structureDef instanceof StructureDefImpl && ((StructureDefImpl)structureDef).isElementsScalar() && (attributeDefArray = structureDef.getAttributeDefs()) == null && attributeDefArray.length == 0) {
            return false;
        }
        if (structureDef != null) {
            AttributeDef attributeDef = structureDef.getAttributeDef(n);
            switch (attributeDef.getUpdateableFlag()) {
                case 1: {
                    return this.mRowState == 0;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDead() {
        return false;
    }

    public StructureDef getStructureDef() {
        return this.mRSI.getStructureDef();
    }

    public void setAttribute(int n, Object object) {
        this.internalSetAttributeValue(this.getStructureDef().getAttributeDef(n), object);
    }

    public void setAttribute(String string, Object object) {
        this.internalSetAttributeValue(this.getStructureDef().findAttributeDef(string), object);
    }

    final void internalSetAttributeValue(AttributeDef attributeDef, Object object) {
        String string = attributeDef.getColumnName();
        Class clazz = attributeDef.getJavaType();
        String string2 = attributeDef.getName();
        if (!this.isAttributeUpdateable(attributeDef.getIndex())) {
            Class clazz2 = class$oracle$adf$model$ADFmMessageBundle;
            if (clazz2 == null) {
                clazz2 = class$oracle$adf$model$ADFmMessageBundle = RowImpl.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new ReadOnlyAttrException(0, clazz2, "35009", this.mRSI.getName(), string2);
        }
        try {
            Class clazz3;
            if (this.mChanged == null) {
                this.mChanged = new BitSet(4);
            }
            Object object2 = null;
            if (object != null) {
                try {
                    object2 = TypeFactory.convertAttributeValueToType((AttributeDef)attributeDef, (Class)clazz, (Object)object, (int)181, (String)"");
                    ((AttributeDefImpl)attributeDef).validate((AttributeList)this, object2);
                }
                catch (JboException jboException) {
                    jboException.setNeedsEntityToVOMapping(false);
                    throw jboException;
                }
            }
            this.lock();
            if (attributeDef instanceof AttributeDefImpl && clazz != (clazz3 = ((AttributeDefImpl)attributeDef).getColumnType())) {
                object2 = TypeFactory.convertAttributeValueToType((AttributeDef)attributeDef, (Class)clazz3, (Object)object, (int)181, (String)"");
            }
            if (this.mProviderType == 2) {
                this.mRowDataProvider = object2;
            } else {
                this.mRSI.setAttributeValue(this, string, object2);
            }
            if (attributeDef.isPrimaryKey()) {
                this.resetKey();
            }
        }
        catch (DataCreationException dataCreationException) {
            dataCreationException.setAttrInfo(111, this.mRSI.getName(), string2, object);
            throw dataCreationException;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        int n = attributeDef.getIndex();
        if (!this.mChanged.get(n)) {
            this.mChanged.set(n);
            ++this.mChangedCount;
            if (attributeDef != null && attributeDef.isPrimaryKey()) {
                ++this.mPKChangedCount;
            }
        }
        this.mRSI.notifyRowUpdated(this, this.mRSI.getRangeIndexOf(this), new int[]{n});
    }

    public int getAttributeCount() {
        return this.getStructureDef().getAttributeCount();
    }

    public int getAttributeIndexOf(String string) {
        return this.getStructureDef().findAttributeDef(string).getIndex();
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.getAttributeCount()];
        AttributeDef[] attributeDefArray = this.getStructureDef().getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            stringArray[n] = attributeDefArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    public ApplicationModule getApplicationModule() {
        return null;
    }

    public Key getKey() {
        if (this.mCachedKey == null && this.mRSI != null) {
            StructureDefImpl structureDefImpl;
            ArrayList arrayList;
            int n;
            StructureDef structureDef = this.getStructureDef();
            if (structureDef instanceof StructureDefImpl && (n = (arrayList = (structureDefImpl = (StructureDefImpl)structureDef).getKeyAttrsList()).size()) > 0) {
                Object[] objectArray = new Object[n];
                while (n > 0) {
                    objectArray[--n] = this.getAttribute(((AttributeDef)arrayList.get(n)).getName());
                }
                this.mCachedKey = new Key(objectArray);
            }
            if (this.mCachedKey == null) {
                this.mCachedKey = new Key(new Object[]{new Integer(this.getRowIndex())});
            }
        }
        return this.mCachedKey;
    }

    public void resetKey() {
        this.mCachedKey = null;
    }

    int getRowIndex() {
        if (this.mRSI.getCurrentRow() == this) {
            return this.mRSI.getCurrentRowIndex();
        }
        int n = this.mRSI.getRangeStart();
        int n2 = this.mRSI.getRangeIndexOf(this);
        return n <= 0 ? n2 : n2 + n;
    }

    public void validate() {
    }

    public void revert() {
        throw new UnsupportedOperationException("revert()");
    }

    public void refresh(int n) {
        throw new UnsupportedOperationException("refresh()");
    }

    public void lock() {
        this.mRowDataProvider = this.mRSI.mApp.registerDataProvider(new DCGenericRowContext(this, this.mRSI, this.mRSI.getStructureDef(), null));
    }

    public void remove() {
        this.mRSI.doRemoveRow(this, true);
    }

    public void removeFromCollection() {
        this.mRSI.doRemoveRow(this, false);
    }

    public void removeAndRetain() {
        this.mRSI.doRemoveRow(this, false);
    }

    final void _setState(int n, DCGenericRowSetIteratorImpl dCGenericRowSetIteratorImpl) {
        this.mRowState = n;
    }

    public Node writeXML(long l, HashMap hashMap) {
        throw new UnsupportedOperationException("writeXML()");
    }

    public Node writeXML(int n, long l) {
        throw new UnsupportedOperationException("writeXML()");
    }

    public void readXML(Element element, int n) {
        throw new UnsupportedOperationException("readXML()");
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        throw new UnsupportedOperationException("writeXML()");
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        throw new UnsupportedOperationException("writeXML()");
    }

    public void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        throw new UnsupportedOperationException("readXML()");
    }

    public void setNewRowState(byte by) {
    }

    public Object getDataProvider() {
        return this.mRowDataProvider;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

