/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.util.List;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.UpdateListener;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBindingDef;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.PermissionBinding;
import oracle.adf.model.utils.Adapt227;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.Transaction;
import oracle.jbo.ValidationException;
import oracle.jbo.ViewObject;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.common.JboBeanUtils;

public abstract class DCControlBinding
extends JboAbstractMap {
    String mName;
    private Object mControl;
    private DCIteratorBinding mIterBinding;
    DCBindingContainer mBindingContainer;
    private DCControlBindingDef mControlDef;
    protected UpdateListener mAttributeListener;
    protected PermissionInfo mPermissionInfo;
    public static final String ROW_KEY_STR = "rowKeyStr";
    public static final String ATTR_ITER = "iteratorBinding";
    public static final String ATTR_DEF = "def";
    public static final String ATTR_ERROR = "error";
    public static final String ATTR_ERRORS = "errors";
    public static final String ATTR_FULLNAME = "fullName";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CURRENTROW = "currentRow";
    protected boolean mInternalGet_KeyResolved;

    private /* synthetic */ void $init$() {
        this.mPermissionInfo = null;
        this.mInternalGet_KeyResolved = false;
    }

    protected DCControlBinding() {
        this.$init$();
    }

    public DCControlBinding(Object object, DCIteratorBinding dCIteratorBinding) {
        this.$init$();
        this.mControl = object;
        this.mIterBinding = dCIteratorBinding;
    }

    public final String getName() {
        return this.mName;
    }

    protected void internalSetName(String string) {
        this.mName = string;
    }

    void setDCIteratorBinding(DCIteratorBinding dCIteratorBinding) {
        if (dCIteratorBinding != this.mIterBinding) {
            this.mIterBinding = dCIteratorBinding;
            this.setBindingContainer(dCIteratorBinding.getBindingContainer());
        }
    }

    public void setName(String string) {
        if (this.mName == null && string == null) {
            return;
        }
        if (this.mName != null) {
            if (this.mName.equals(string)) {
                return;
            }
            if (this.mBindingContainer != null) {
                this.mBindingContainer.removeControlBinding(this);
            }
        }
        this.mName = string;
        if (this.mBindingContainer != null) {
            this.mBindingContainer.addControlBinding(this);
        }
    }

    public final String getFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBindingContainer().getFullName()).append('.').append(this.getName());
        return stringBuffer.toString();
    }

    public String getDefName() {
        if (this.mControlDef != null) {
            this.mControlDef.getName();
        }
        return null;
    }

    public String getDefFullName() {
        if (this.mControlDef != null) {
            this.mControlDef.getFullName();
        }
        return null;
    }

    public void reportException(Exception exception) {
        this.getBindingContainer().reportException(exception);
    }

    public final DCBindingContainer getBindingContainer() {
        if (this.mBindingContainer == null && this.mIterBinding != null) {
            this.setBindingContainer(this.mIterBinding.getBindingContainer());
        }
        return this.mBindingContainer;
    }

    public void setBindingContainer(DCBindingContainer dCBindingContainer) {
        if (dCBindingContainer != this.mBindingContainer) {
            if (this.mBindingContainer != null) {
                this.mBindingContainer.removeControlBinding(this);
            }
            this.mBindingContainer = dCBindingContainer;
            if (this.mBindingContainer != null) {
                this.mBindingContainer.addControlBinding(this);
            }
        }
    }

    public final DCControlBindingDef getDef() {
        return this.mControlDef;
    }

    void setDef(DCControlBindingDef dCControlBindingDef) {
        this.mControlDef = dCControlBindingDef;
    }

    public final DCIteratorBinding getDCIteratorBinding() {
        return this.mIterBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() {
        if (this.mIterBinding == null) {
            return null;
        }
        Object object = this.mIterBinding.getSyncLock();
        synchronized (object) {
            ApplicationModule applicationModule = this.getApplicationModule();
            if (applicationModule != null) {
                Transaction transaction = this.getApplicationModule().getTransaction();
                return transaction;
            }
            Transaction transaction = null;
            return transaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationModule getApplicationModule() {
        if (this.mIterBinding == null) {
            return null;
        }
        Object object = this.mIterBinding.getSyncLock();
        synchronized (object) {
            ViewObject viewObject = this.getViewObject();
            if (viewObject != null) {
                ApplicationModule applicationModule = this.getViewObject().getApplicationModule();
                return applicationModule;
            }
            ApplicationModule applicationModule = null;
            return applicationModule;
        }
    }

    public ViewObject getViewObject() {
        return this.mIterBinding != null ? this.mIterBinding.getViewObject() : null;
    }

    public RowIterator getRowIterator() {
        return this.mIterBinding != null ? this.mIterBinding.getNavigatableRowIterator() : null;
    }

    public void executeQuery() {
        this.mIterBinding.executeQuery();
    }

    public void executeQueryIfNeeded() {
        this.mIterBinding.executeQueryIfNeeded();
    }

    public Row getCurrentRow() {
        if (this.mIterBinding != null) {
            return this.mIterBinding.getCurrentRow();
        }
        return null;
    }

    public Row getRowAtRangeIndex(int n) {
        return this.mIterBinding.getRowAtRangeIndex(n);
    }

    public Row[] getAllRowsInRange() {
        return this.mIterBinding != null ? this.mIterBinding.getAllRowsInRange() : null;
    }

    public Object getControl() {
        return this.mControl;
    }

    public Object getControlModel(Object object) {
        return this;
    }

    public void setControl(Object object) {
        if (this.mControl == null) {
            this.mControl = object;
        } else if (this.mControl != object && object != null) {
            throw new JboException("35001");
        }
    }

    public Object getLayoutObject() {
        return this.mControl;
    }

    protected boolean isControlQueriable() {
        return false;
    }

    protected JboException getError() {
        return null;
    }

    protected List getErrors() {
        return null;
    }

    protected void processInputException(ValidationException validationException) {
    }

    protected abstract void resetInputState();

    protected abstract void initResources();

    public abstract void refreshControl();

    protected void release(int n) {
        if (n == DCDataControl.REL_ALL_REFS) {
            this.setBindingContainer(null);
            if (this.mIterBinding != null) {
                this.mIterBinding = null;
            }
        }
        if ((n & DCDataControl.REL_VIEW_REFS) > 0) {
            this.mControl = null;
        }
    }

    protected boolean needsEstimatedRowCount() {
        return false;
    }

    protected void removeFromDCExceptions() {
        DCIteratorBinding dCIteratorBinding = this.mIterBinding;
        DCDataControl dCDataControl = null;
        if (dCIteratorBinding != null) {
            dCDataControl = dCIteratorBinding.getDataControl();
        }
        if (dCDataControl == null && this.getBindingContainer() != null) {
            dCDataControl = this.getBindingContainer().getDataControl();
        }
        if (dCDataControl != null) {
            dCDataControl.removeBindingWithExc(this.getFullName());
        }
    }

    protected void resetAttributeExceptionInRow(Row row, AttributeDef attributeDef, AttrValException attrValException) {
        DCIteratorBinding dCIteratorBinding = this.mIterBinding;
        DCDataControl dCDataControl = null;
        if (dCIteratorBinding != null) {
            dCDataControl = dCIteratorBinding.getDataControl();
        }
        if (dCDataControl == null && this.getBindingContainer() != null) {
            dCDataControl = this.getBindingContainer().getDataControl();
        }
        if (dCDataControl != null) {
            dCDataControl.resetAttributeExceptionInRow(dCIteratorBinding, row, attributeDef, attrValException);
        }
    }

    protected void addToDCExceptions(JboException jboException) {
        DCIteratorBinding dCIteratorBinding = this.mIterBinding;
        DCDataControl dCDataControl = null;
        if (dCIteratorBinding != null) {
            dCDataControl = dCIteratorBinding.getDataControl();
        }
        if (dCDataControl == null && this.getBindingContainer() != null) {
            dCDataControl = this.getBindingContainer().getDataControl();
        }
        if (dCDataControl != null) {
            dCDataControl.addBindingWithExc(this.getFullName());
        }
    }

    public final Object get(Object object) {
        Object object2;
        if (object instanceof String) {
            String string = ((String)object).intern();
            this.mInternalGet_KeyResolved = false;
            object2 = this.internalGet(string);
            if (object2 == null && !this.mInternalGet_KeyResolved) {
                try {
                    object2 = JboBeanUtils.getProperty((Object)((Object)this), (String)string);
                }
                catch (Exception exception) {
                    object2 = null;
                }
            }
        } else {
            object2 = super.get(object);
        }
        return object2;
    }

    protected Object internalGet(String string) {
        if ((string = string.intern()) == ATTR_ITER) {
            this.mInternalGet_KeyResolved = true;
            return this.getDCIteratorBinding();
        }
        if (string == ROW_KEY_STR) {
            return this.getCurrentRow().getKey().toStringFormat(true);
        }
        if (string == ATTR_DEF) {
            this.mInternalGet_KeyResolved = true;
            return this.getDef();
        }
        if (string == ATTR_ERROR) {
            this.mInternalGet_KeyResolved = true;
            return this.getError();
        }
        if (string == ATTR_ERRORS) {
            this.mInternalGet_KeyResolved = true;
            return this.getErrors();
        }
        if (string == ATTR_CURRENTROW) {
            this.mInternalGet_KeyResolved = true;
            return this.getCurrentRow();
        }
        if (string == ATTR_FULLNAME) {
            this.mInternalGet_KeyResolved = true;
            return this.getFullName();
        }
        if (string == ATTR_NAME) {
            this.mInternalGet_KeyResolved = true;
            return this.getName();
        }
        return super.internalGet(string);
    }

    public int hashCode() {
        return this.mName != null ? this.mName.hashCode() : super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public void setListener(UpdateListener updateListener) {
        this.mAttributeListener = updateListener;
    }

    public void setListener(oracle.binding.UpdateListener updateListener) {
        this.mAttributeListener = Adapt227.wrapJSRUpdateListener(updateListener);
    }

    DCBindingContainer internalGetBindingContainer() {
        return this.mBindingContainer;
    }

    protected boolean internalHasPermission(String string) {
        return true;
    }

    protected boolean internalHasPermission(String string, String string2) {
        return true;
    }

    public String getPermissionTargetName() {
        if (this.mIterBinding != null) {
            return this.mIterBinding.getPermissionTargetName();
        }
        return this.mName;
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            this.mPermissionInfo = new PermissionBinding(this.getPermissionTargetName(), 1);
        }
        return this.mPermissionInfo;
    }
}

