/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;

public class CLOB
extends Datum
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32512;
    public static final int DURATION_SESSION = 1;
    public static final int DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    oracle.jdbc.OracleConnection m_conn;
    ClobDBAccess m_dbaccess;
    private int m_dbChunkSize;
    private short csform;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (oracleConnection != null) {
            this.m_conn = oracleConnection;
        } else {
            DBError.check_error(68, "Connection is null");
        }
        this.m_dbaccess = ((oracle.jdbc.internal.OracleConnection)oracleConnection).createClobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public void close() throws SQLException {
        this.getDBAccess().close(this);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n) throws SQLException {
        if (connection == null || n != 1 && n != 2) {
            DBError.throwSqlException(68);
        }
        return CLOB.getDBAccess(connection).createTemporaryClob(LobPlsqlUtil.getConnectionWithIn(connection), bl, n);
    }

    public static CLOB empty_lob() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public void freeTemporary() throws SQLException {
        this.getDBAccess().freeTemporary(this);
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public OutputStream getAsciiOutputStream(long l) throws SQLException {
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l);
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream(long l) throws SQLException {
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l);
    }

    public int getBufferSize() throws SQLException {
        int n = this.getChunkSize();
        if (n >= 32512 || n <= 0) {
            return 32512;
        }
        return 32512 / n * n;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), 0L);
    }

    public Writer getCharacterOutputStream(long l) throws SQLException {
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public Reader getCharacterStream(long l) throws SQLException {
        return this.getDBAccess().newReader(this, this.getBufferSize(), l);
    }

    public int getChars(long l, int n, char[] cArray) throws SQLException {
        return this.getDBAccess().getChars(this, l, n, cArray);
    }

    public int getChunkSize() throws SQLException {
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public OracleConnection getConnection() throws SQLException {
        try {
            return LobPlsqlUtil.getConnectionWithIn(this.getJavaSqlConnection());
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
            return null;
        }
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                DBError.throwSqlException(98);
            }
            this.m_dbaccess = this.getConnection().createClobDBAccess();
        }
        return this.m_dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.internal.OracleConnection)connection).createClobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = (oracle.jdbc.OracleConnection)new OracleDriver().defaultConnection();
        }
        return this.m_conn;
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public String getSubString(long l, int n) throws SQLException {
        if (n < 0 || l < 1L) {
            DBError.check_error(68, "getSubString");
        }
        if (n == 0) {
            return new String();
        }
        char[] cArray = new char[n];
        int n2 = this.getChars(l, n, cArray);
        if (n2 > 0) {
            return new String(cArray, 0, n2);
        }
        return new String();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public boolean isEmptyLob() throws SQLException {
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public boolean isNCLOB() {
        return this.csform == 2;
    }

    public boolean isOpen() throws SQLException {
        return this.getDBAccess().isOpen(this);
    }

    public boolean isTemporary() throws SQLException {
        return this.getDBAccess().isTemporary(this);
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public long length() throws SQLException {
        return this.getDBAccess().length(this);
    }

    public Object makeJdbcArray(int n) {
        return new CLOB[n];
    }

    public void open(int n) throws SQLException {
        this.getDBAccess().open(this, n);
    }

    public long position(String string, long l) throws SQLException {
        return this.getDBAccess().position(this, string, l);
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.getDBAccess().position(this, (CLOB)clob, l);
    }

    public int putChars(long l, char[] cArray) throws SQLException {
        return this.getDBAccess().putChars(this, l, cArray);
    }

    public int putString(long l, String string) throws SQLException {
        if (l < 1L) {
            DBError.check_error(68, "putString()");
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.putChars(l, string.toCharArray());
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public void trim(long l) throws SQLException {
        if (l < 0L) {
            DBError.throwSqlException(68);
        }
        this.getDBAccess().trim(this, l);
    }
}

