/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class PlsqlTTCColumn
extends TTCColumn {
    private TTCItem in;
    private TTCItem out;

    protected PlsqlTTCColumn(TTIoac tTIoac) {
        super(tTIoac, 1);
    }

    protected void marshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error(426);
        }
        if (this.in != null) {
            this.in.marshal();
        } else {
            this.out.marshalPLSQL();
        }
    }

    protected void print() {
        System.out.println("           ---- Enter: PlsqlTTCColumn.print  --- ");
        super.print();
        System.out.println("          +++++ IN Item information: ");
        if (this.in != null) {
            this.in.print();
        } else {
            System.out.println("              IN bind is NULL ");
        }
        System.out.println("          +++++ OUT Item information: ");
        if (this.out != null) {
            this.out.print();
        } else {
            System.out.println("              OUT bind is NULL ");
        }
        System.out.println("           ---- Exit: PlsqlTTCColumn.print --- ");
    }

    protected void setIN(TTCItem tTCItem) {
        this.in = tTCItem;
    }

    protected void setOUT(TTCItem tTCItem) {
        this.out = tTCItem;
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error(426);
        }
        if (this.out != null) {
            this.out.unmarshal();
            this.out.unmarshalIndicator();
        } else {
            this.in.unmarshal();
            this.in.unmarshalIndicator();
        }
        return false;
    }
}

