/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.RAW;
import oracle.sql.TypeDescriptor;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    static boolean DEBUG = false;
    int length;

    public OracleTypeRAW() {
    }

    public OracleTypeRAW(int n) {
        super(n);
    }

    public int getLength() {
        return this.length;
    }

    public int getTypeCode() {
        return -2;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        super.parseTDSrec(streamInfo);
        this.length = streamInfo.readShort();
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        if (datum.getLength() > (long)this.length) {
            DBError.check_error(72, this);
        }
        int n = pickleContext.writeLength_pctx((int)datum.getLength());
        return n += pickleContext.write_data_pctx(datum.shareBytes());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeRAW::readObject");
        }
        this.length = objectInputStream.readInt();
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        RAW rAW;
        block3: {
            rAW = null;
            if (object == null) break block3;
            try {
                if (object instanceof RAW) {
                    rAW = (RAW)object;
                    break block3;
                }
                rAW = new RAW(object);
            }
            catch (SQLException sQLException) {
                DBError.throwSqlException(59, object);
            }
        }
        return rAW;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n2 = (int)(n == -1 ? (long)cArray.length : Math.min((long)cArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                int n3 = 0;
                while (n3 < n2) {
                    datumArray[n3] = this.toDatum(new String(cArray[(int)l + n3 - 1]), oracleConnection);
                    ++n3;
                }
            } else {
                if (object instanceof Object[]) {
                    return super.toDatumArray(object, oracleConnection, l, n);
                }
                DBError.check_error(59, object);
            }
        }
        return datumArray;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new RAW(byArray);
            }
            case 2: 
            case 3: {
                return byArray;
            }
        }
        DBError.throwSqlException(59, byArray);
        return null;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        switch (n) {
            case 1: {
                if (unpickleContext.is_null(this.null_offset)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                if (n2 == 9) {
                    unpickleContext.skip_bytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.read_lengthBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n2, map);
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1 || n2 == 9) {
                    unpickleContext.skip_lengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_lengthBytes(), n2, map);
            }
            case 3: {
                if (n2 == 9) {
                    unpickleContext.skip_lengthBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_lengthBytes(), n2, map);
            }
        }
        DBError.throwSqlException(1, "format=" + n);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (TypeDescriptor.DEBUG_SERIALIZATION) {
            System.out.println("OracleTypeRAW::writeObject");
        }
        objectOutputStream.writeInt(this.length);
    }
}

