/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dms.spy.Spy;
import oracle.dms.util.DMSProperties;

public abstract class DMSUtil {
    public static final String OPMN_PORT = "oracle.dms.opmn.port";
    private static final int PIDNOTSET = -1;
    private static int _pid = -1;
    private static String _localhost = null;
    private static String _dmsMount = "dms0";
    private static volatile boolean _pidSet = false;

    public static synchronized String getLocalHostname() {
        if (_localhost != null) {
            return _localhost;
        }
        _localhost = "localhost";
        try {
            _localhost = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return _localhost;
        }
        return _localhost;
    }

    public static synchronized void setProcessID(int n) {
        if (_pidSet || n < 0) {
            return;
        }
        _pid = n;
        _pidSet = true;
    }

    public static synchronized int getProcessID() {
        if (_pid == -1) {
            while ((_pid = (int)(Math.random() * 100000.0)) == 0) {
            }
        }
        return _pid;
    }

    public static String getProcessName() {
        String string = DMSProperties.getProperty(OPMN_PORT);
        return DMSUtil.getProcessName(Spy.getName(), DMSUtil.getProcessID(), string);
    }

    public static String getProcessName(String string, int n, String string2) {
        if (string == null || n <= 0) {
            return null;
        }
        String string3 = ":" + n;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(string3)) {
            stringBuffer.append(string3);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(':');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String sanitize(String string, int n, boolean bl, boolean bl2) {
        if (string == null || n <= 0) {
            return "";
        }
        if (n < string.length()) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setLength(n);
            return DMSUtil.sanitize(stringBuffer, bl, bl2, 0);
        }
        n = string.length();
        int n2 = 32;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !bl) continue;
            if (!Character.isWhitespace(c) && !Character.isISOControl(c)) {
                switch (c) {
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '.': 
                    case '<': 
                    case '>': {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            return DMSUtil.sanitize(stringBuffer, bl, bl2, i);
        }
        return string;
    }

    private static final String sanitize(StringBuffer stringBuffer, boolean bl, boolean bl2, int n) {
        int n2 = stringBuffer.length();
        block7: for (int i = n; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' && !bl) continue;
            if (Character.isWhitespace(c)) {
                if (bl) {
                    stringBuffer.setCharAt(i, '_');
                    continue;
                }
                stringBuffer.setCharAt(i, ' ');
                continue;
            }
            if (Character.isISOControl(c)) {
                stringBuffer.setCharAt(i, '_');
                continue;
            }
            switch (c) {
                case '<': {
                    stringBuffer.setCharAt(i, '(');
                    continue block7;
                }
                case '>': {
                    stringBuffer.setCharAt(i, ')');
                    continue block7;
                }
                case '&': {
                    stringBuffer.setCharAt(i, '^');
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    stringBuffer.setCharAt(i, '`');
                    continue block7;
                }
                case '.': {
                    String string;
                    if (!bl2 || (string = stringBuffer.substring(i)).lastIndexOf(46) != 0 || !".value".equals(string) && !".count".equals(string) && !".time".equals(string) && !".minTime".equals(string) && !".minValue".equals(string) && !".maxTime".equals(string) && !".maxValue".equals(string) && !".completed".equals(string) && !".avg".equals(string) && !".sum".equals(string) && !".active".equals(string) && !".maxActive".equals(string) && !".logged".equals(string) && !".exclTime".equals(string) && !".lastUpdate".equals(string) && !".ts".equals(string)) continue block7;
                    stringBuffer.setCharAt(i, '_');
                    continue block7;
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getLeafFromPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char c = string.charAt(0);
        String string2 = string.substring(string.lastIndexOf(c) + 1);
        return string2;
    }

    public static String removeTrailingDelimFromPath(String string) {
        if (string == null || string.length() <= 1) {
            return string;
        }
        int n = string.length();
        if (string.charAt(0) == string.charAt(n - 1)) {
            return string.substring(0, n - 1);
        }
        return string;
    }

    public static String getParentFromPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        char c = string.charAt(0);
        return string.substring(0, string.lastIndexOf(c));
    }

    public static String genCompNounPath(String string) {
        return "/DMS-Internal/" + string;
    }

    public static void cleanFormatArgs(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                objectArray[i] = "null";
            }
        }
    }

    public static String getDMSMount() {
        return _dmsMount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapSets(Map map) {
        ArrayList arrayList;
        if (map == null) {
            return;
        }
        Object object = map;
        synchronized (object) {
            arrayList = new ArrayList(map.values());
            map.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Object e;
            Object e2 = object.next();
            if (e2 instanceof Collection) {
                e = e2;
                synchronized (e) {
                    ((Collection)e2).clear();
                    continue;
                }
            }
            if (!(e2 instanceof Map)) continue;
            e = e2;
            synchronized (e) {
                ((Map)e2).clear();
            }
        }
        arrayList.clear();
    }

    public static String xmlEscape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = string.indexOf("]]>")) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("&#x5d;&#x5d;&#x3e;");
            string = string.substring(n + 3);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String xssEscape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static HashSet createHashSet(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray == null) {
            return hashSet;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    public static ArrayList createArrayList(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray == null) {
            return arrayList;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static int[] parseVersion(String string) throws NumberFormatException {
        Object object;
        if (string == null || string.length() == 0) {
            throw new NumberFormatException(string);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            arrayList.add(new Integer((String)object));
        }
        int n = arrayList.size();
        if (n == 0) {
            throw new NumberFormatException(string);
        }
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public static int compareVersion(String string, int[] nArray) throws NumberFormatException {
        if (string == null || nArray == null || nArray.length == 0) {
            throw new NumberFormatException();
        }
        int[] nArray2 = DMSUtil.parseVersion(string);
        int n = nArray2.length < nArray.length ? nArray2.length : nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] < nArray[i]) {
                return -1;
            }
            if (nArray2[i] <= nArray[i]) continue;
            return 1;
        }
        int[] nArray3 = nArray2.length > nArray.length ? nArray2 : nArray;
        boolean bl = true;
        for (int i = n; i < nArray3.length; ++i) {
            if (nArray3[i] == 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 0;
        }
        if (nArray2.length < nArray.length) {
            return -1;
        }
        if (nArray2.length > nArray.length) {
            return 1;
        }
        return 0;
    }

    private DMSUtil() {
    }

    public static synchronized void exit() {
        _pidSet = false;
        _dmsMount = "dms0";
        _localhost = null;
        _pid = -1;
    }
}

