/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.state;

import oracle.dms.instrument.state.Value;

public class LongValue
extends Value {
    private long _value = 0L;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;

    private void setValue(long l) {
        this._value = l;
        if (this.MAX && this._value > this._max) {
            this._max = l;
        }
        if (this.MIN && this._value < this._min) {
            this._min = l;
        }
    }

    public void update(long l) {
        this.setValue(l);
    }

    public void update(double d) {
        long l = 0L;
        l = d >= 0.0 ? Math.round(d) : -Math.round(-d);
        this.setValue(l);
    }

    public void update(int n) {
        long l = n;
        this.setValue(l);
    }

    public void increment() {
        long l = this._value + 1L;
        this.setValue(l);
    }

    public void increment(int n) {
        long l = this._value + (long)n;
        this.setValue(l);
    }

    public void increment(long l) {
        long l2 = this._value + l;
        this.setValue(l2);
    }

    public void increment(double d) {
        long l = (long)(d + 0.5);
        this.setValue(l += this._value);
    }

    void initMinMax() {
        if (this._initialized) {
            if (this.MIN && this._min > this._value) {
                this._min = this._value;
            }
            if (this.MAX && this._max < this._value) {
                this._max = this._value;
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.MIN) {
            this._min = this._value;
        }
        if (this.MAX) {
            this._max = this._value;
        }
    }

    public Object getValue() {
        return new Long(this._value);
    }

    public Object getMin() {
        if (!this.MIN) {
            return null;
        }
        if (this._min != Long.MAX_VALUE) {
            return new Long(this._min);
        }
        return new Long(0L);
    }

    public Object getMax() {
        if (!this.MAX) {
            return null;
        }
        if (this._max != Long.MIN_VALUE) {
            return new Long(this._max);
        }
        return new Long(0L);
    }
}

