/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.DumpFilenameFilter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.State;

class NounDumperThread
extends Thread {
    static final String DMSDUMP_PREFIX = "dmsDump_";
    static final String DMSDUMP_SUFFIX = ".xml";
    private Noun _noun = null;
    private long _interval = 0L;
    private String _dest = null;
    private int _maxDumps = 0;
    private NounDumpListener _lsnr = null;
    private PhaseEvent _dumpPhase = null;
    private State _prevDumpState = null;
    private State _nextDumpState = null;
    private State _destState = null;
    private State _intervalState = null;
    private State _maxDumpsState = null;

    NounDumperThread(Noun noun, int n, String string, int n2, NounDumpListener nounDumpListener) {
        this._noun = noun;
        this._interval = n * 1000;
        this._dest = string;
        this._maxDumps = n2;
        this._lsnr = nounDumpListener;
        Noun noun2 = Noun.create("/DMS-Internal/transtrace/DumpInfo", "dms_dumpInfo");
        this._dumpPhase = PhaseEvent.create(noun2, "dump", "metric data was dumped to file");
        this._dumpPhase.deriveMetric(46);
        this._prevDumpState = State.create(noun2, "lastDumpTime", "", "timestamp of previous dump", (Object)"no dump yet");
        this._nextDumpState = State.create(noun2, "nextDumpTime", "", "timestamp of next dump", (Object)"n/a");
        this._destState = State.create(noun2, "location", "", "dump location", (Object)this._dest);
        this._intervalState = State.create(noun2, "sleepInterval", "secs", "sleep interval between dumps", this._interval / 1000L);
        this._maxDumpsState = State.create(noun2, "maxDumps", "files", "maximum number of dumps", this._maxDumps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this._noun.isAlive()) {
                long l = this.doSleep();
                long l2 = this._dumpPhase.start();
                this.evictOldDumps();
                try {
                    String string = this.dumpFileName(l);
                    if (this._lsnr != null) {
                        try {
                            this._lsnr.preNounDump(this._noun);
                        }
                        catch (Exception exception) {
                            System.err.println("NounDumper: listener preDump -- " + exception);
                            exception.printStackTrace();
                        }
                    }
                    this._noun.dump(string, "pdml", false);
                    if (this._lsnr == null) continue;
                    try {
                        this._lsnr.postNounDump(this._noun);
                    }
                    catch (Exception exception) {
                        System.err.println("NounDumper: listener postDump -- " + exception);
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    System.err.println("NounDumper: Exception caught -- " + exception);
                    exception.printStackTrace();
                }
                finally {
                    this._dumpPhase.stop(l2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void evictOldDumps() {
        try {
            Object object;
            String string;
            int n;
            File file = new File(this._dest);
            if (!DMSFileUtil.isDirectory(file)) {
                return;
            }
            String[] stringArray = DMSFileUtil.list(file, new DumpFilenameFilter());
            if (stringArray.length < this._maxDumps) {
                return;
            }
            long[] lArray = new long[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                int n2;
                string = stringArray[n];
                object = string.substring(DMSDUMP_PREFIX.length(), string.length() - DMSDUMP_SUFFIX.length());
                Long l = new Long((String)object);
                long l2 = l;
                for (n2 = 0; n2 < n && l2 <= lArray[n2]; ++n2) {
                }
                for (int i = n; i > n2; --i) {
                    lArray[i] = lArray[i - 1];
                }
                lArray[n2] = l2;
            }
            for (n = this._maxDumps - 1; n < stringArray.length; ++n) {
                string = this.dumpFileName(lArray[n]);
                object = new File(string);
                ((File)object).delete();
            }
        }
        catch (Exception exception) {
            System.err.println("DMS Dump: exception during eviction: " + exception);
            exception.printStackTrace();
        }
    }

    private String dumpFileName(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._dest);
        stringBuffer.append(File.separator);
        stringBuffer.append(DMSDUMP_PREFIX);
        stringBuffer.append(l);
        stringBuffer.append(DMSDUMP_SUFFIX);
        return stringBuffer.toString();
    }

    private long doSleep() throws InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = (l + this._interval) / this._interval * this._interval;
        long l3 = l2 / 1000L;
        long l4 = l2 - l;
        this._nextDumpState.update(new Long(l3));
        Thread.currentThread();
        Thread.sleep(l4);
        this._prevDumpState.update(new Long(l3));
        return l3;
    }
}

