/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.OutputStreamLogWriter;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.Logger;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Log {
    public static final String MAXSIZE_KEY = "MaxSize";
    public static final String SEGSIZE_KEY = "SegmentSize";
    public static final String ENCODING_KEY = "Encoding";
    public static final String PATH_KEY = "Path";
    private static boolean _initialized = false;
    private static boolean s_isLoggingEnabled = false;
    private static HashMap s_logWriters = new HashMap();
    private static LogWriter s_stdoutLogWriter;
    private static LogWriter s_stderrLogWriter;
    private static final String LOGBASE;
    private static Noun _logNoun;
    private static Event s_msgsLogged;
    private static State s_logStatus;

    private Log() {
    }

    public static final synchronized void init() throws ConfigurationError, PrivilegedActionException {
        if (_initialized) {
            return;
        }
        Log.initMetrics();
        _initialized = true;
        try {
            LogManager.getLogManager().init(null);
        }
        catch (Exception exception) {
            throw new ConfigurationError();
        }
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws ConfigurationError {
                try {
                    Log.initLogWriters();
                }
                catch (Exception exception) {
                    throw new ConfigurationError();
                }
                return null;
            }
        });
        Log.configureRootNoun();
        Log.setEnableLogging(true);
        Event event = Event.create(LOGBASE + '/' + "initLogging", DMSNLSupport.getString("LOG_INIT_MESG"));
        event.occurred();
    }

    public static final synchronized void shutdown() {
        Log.log(LOGBASE + "/shutdown", DMSNLSupport.getString("LOG_SHUTDOWN_MESG"), Level.DEBUG, null);
        Log.closeLogWriters();
        LogManager.getLogManager().term();
        Log.setEnableLogging(false);
        _logNoun.destroy();
        _logNoun = null;
        s_msgsLogged = null;
        s_logStatus = null;
        s_stdoutLogWriter = null;
        s_stderrLogWriter = null;
        _initialized = false;
    }

    public static void setEnableLogging(boolean bl) {
        s_isLoggingEnabled = bl;
        if (bl) {
            s_logStatus.update(DMSNLSupport.getString("LOG_STATUS_ENABLED"));
        } else {
            s_logStatus.update(DMSNLSupport.getString("LOG_STATUS_DISABLED"));
        }
    }

    public static boolean isLoggingEnabled() {
        return s_isLoggingEnabled;
    }

    private static void initMetrics() {
        _logNoun = Noun.create(LOGBASE, DMSNLSupport.getString("LOG_NOUN_DESC"));
        s_msgsLogged = Event.create(_logNoun, "messagesLogged", DMSNLSupport.getString("LOG_MSGS_WRITTEN"));
        s_msgsLogged.configureLogging(null, Level.OFF);
        s_logStatus = new State(_logNoun, "status", "", DMSNLSupport.getString("LOG_STATUS"), DMSNLSupport.getString("LOG_STATUS_ENABLED"));
    }

    protected static void logMsgEventOccurred() {
        s_msgsLogged.occurred();
    }

    private static void configureRootNoun() {
        Map map = DMSProperties.getNounProperties("/");
        if (map != null) {
            List list;
            String string = (String)map.get("loglevel");
            if (string != null) {
                Noun.getRoot().setLogLevel(Level.getLevel(string), false);
            }
            if ((list = (List)map.get("logwriter")) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    LogWriter logWriter = Log.getLogWriter(string2);
                    if (logWriter == null) continue;
                    Noun.getRoot().addLogWriter(logWriter);
                }
            }
        }
    }

    public static LogWriter getLogWriter(String string) {
        LogWriter logWriter = (LogWriter)s_logWriters.get(string);
        if (logWriter == null) {
            if (s_stdoutLogWriter == null && string.equals("stdout")) {
                s_stdoutLogWriter = OutputStreamLogWriter.create(System.out);
                s_logWriters.put("stdout", s_stdoutLogWriter);
                logWriter = s_stdoutLogWriter;
            }
            if (s_stderrLogWriter == null && string.equals("stderr")) {
                s_stderrLogWriter = OutputStreamLogWriter.create(System.err);
                s_logWriters.put("stderr", s_stderrLogWriter);
                logWriter = s_stderrLogWriter;
            }
        }
        return logWriter;
    }

    private static void initLogWriters() throws ConfigurationError {
        Map map = DMSProperties.getLogWriterProperties();
        if (map == null) {
            return;
        }
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("stdout") || string.equals("stderr")) {
                throw new ConfigurationError(DMSNLSupport.getMessage("LOG_WRITER_RESERVED_NAME", new Object[]{string}));
            }
            try {
                LogWriter logWriter = Log.createLogWriter((Properties)map.get(string));
                s_logWriters.put(string, logWriter);
            }
            catch (Exception exception) {
                throw new ConfigurationError(DMSNLSupport.getMessage("LOG_WRITER_CREATE_ERROR", new Object[]{string, exception.toString()}));
            }
        }
    }

    private static void closeLogWriters() {
        Iterator iterator = s_logWriters.values().iterator();
        while (iterator.hasNext()) {
            LogWriter logWriter = (LogWriter)iterator.next();
            if (logWriter != s_stdoutLogWriter && logWriter != s_stderrLogWriter) {
                try {
                    logWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iterator.remove();
                continue;
            }
            logWriter.flush();
        }
    }

    private static LogWriter createLogWriter(Properties properties) throws Exception {
        String string = properties.getProperty("Class");
        String string2 = properties.getProperty(PATH_KEY);
        boolean bl = false;
        if (string2.regionMatches(true, 0, "xml:", 0, 4)) {
            string2 = string2.substring(4);
            bl = true;
        }
        if (string != null && string.equals("oracle.core.ojdl.BusStopLogWriter") || bl) {
            long l = Log.getSizeProperty(properties, MAXSIZE_KEY);
            long l2 = Log.getSizeProperty(properties, SEGSIZE_KEY);
            String string3 = properties.getProperty(ENCODING_KEY);
            return BusStopLogWriter.create(string2, l2, l, string3);
        }
        if (string == null || string.equals("oracle.core.ojdl.FileLogWriter")) {
            long l = Log.getSizeProperty(properties, MAXSIZE_KEY);
            long l3 = Log.getSizeProperty(properties, SEGSIZE_KEY);
            String string4 = properties.getProperty(ENCODING_KEY);
            return FileLogWriter.create(string2, l3, l, string4);
        }
        throw new ConfigurationError(DMSNLSupport.getMessage("LOG_WRITER_INVALID_CLASS", new Object[]{string}));
    }

    private static long getSizeProperty(Properties properties, String string) throws ConfigurationError {
        String string2 = properties.getProperty(string);
        long l = Long.MAX_VALUE;
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
            }
            catch (Exception exception) {
                throw new ConfigurationError(DMSNLSupport.getMessage("LOG_INVALID_PROP", new Object[]{string2}));
            }
        }
        return l;
    }

    public static void log(String string, String string2, Level level, Object[] objectArray) {
        Logger logger = Logger.create(string, string2);
        logger.log(level, string2, objectArray);
    }

    public static void log(String string, String string2, LogLevel logLevel, Object[] objectArray) {
        Log.log(string, string2, (Level)logLevel, objectArray);
    }

    static {
        LOGBASE = DMSUtil.genCompNounPath("Log");
    }
}

