/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Properties;
import java.util.Stack;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.ExecutionContext;

public class CorrelationContext {
    private String upstreamId;
    private String currentId;
    private String downstreamId;
    private LogMessage.InstanceId execCtxId;
    private LogMessage.InstanceId errorInstId;
    private Properties properties;
    private static ThreadLocal threadStack = new ThreadLocal();

    private CorrelationContext() {
    }

    public static void enter(String string, String string2, LogMessage.InstanceId instanceId) {
        ExecutionContext.get().setECID(instanceId);
        CorrelationContext correlationContext = new CorrelationContext();
        correlationContext.upstreamId = string;
        correlationContext.currentId = string2;
        correlationContext.downstreamId = null;
        correlationContext.execCtxId = instanceId;
        CorrelationContext.push(correlationContext);
    }

    public static void enter(String string) {
        int n;
        String string2;
        ExecutionContext.get().incrementECIDSequenceNumber();
        CorrelationContext correlationContext = CorrelationContext.getTop();
        LogMessage.InstanceId instanceId = null;
        String string3 = null;
        if (correlationContext != null) {
            instanceId = correlationContext.execCtxId;
            string3 = correlationContext.currentId;
        }
        if (instanceId != null) {
            string2 = instanceId.getUniqueId();
            n = instanceId.getSequenceNumber() + 1;
        } else {
            string2 = LogManager.getLogManager().getUniqueId();
            n = 0;
        }
        CorrelationContext.enter(string3, string, new LogMessage.InstanceId(string2, n));
    }

    public static void exit() {
        CorrelationContext correlationContext = CorrelationContext.pop();
        if (correlationContext == null) {
            return;
        }
        LogMessage.InstanceId instanceId = correlationContext.errorInstId;
        if (instanceId != null) {
            CorrelationContext.setError(correlationContext.currentId, new LogMessage.InstanceId(instanceId.getUniqueId(), instanceId.getSequenceNumber() + 1));
        }
    }

    public static void setError(String string, LogMessage.InstanceId instanceId) {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            correlationContext.downstreamId = string;
            correlationContext.errorInstId = instanceId;
        }
    }

    public static void setError() {
        String string = LogManager.getLogManager().getUniqueId();
        CorrelationContext.setError(null, new LogMessage.InstanceId(string, 0));
    }

    public static void clearError() {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            correlationContext.errorInstId = null;
            correlationContext.downstreamId = null;
        }
    }

    public static LogMessage.InstanceId getExecContextId() {
        return ExecutionContext.get().getECID();
    }

    public static LogMessage.InstanceId getErrorInstanceId() {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            return correlationContext.errorInstId;
        }
        return null;
    }

    public static String getUpstreamId() {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            return correlationContext.upstreamId;
        }
        return null;
    }

    public static String getDownstreamId() {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            return correlationContext.downstreamId;
        }
        return null;
    }

    public static void setProperty(String string, String string2) {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            if (correlationContext.properties == null) {
                correlationContext.properties = new Properties();
            }
            correlationContext.properties.setProperty(string, string2);
        }
    }

    public static String getProperty(String string) {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null && correlationContext.properties != null) {
            return correlationContext.properties.getProperty(string);
        }
        return null;
    }

    public static Properties getProperties() {
        CorrelationContext correlationContext = CorrelationContext.getTop();
        if (correlationContext != null) {
            return correlationContext.properties;
        }
        return null;
    }

    public static LogMessage.InstanceId parseExecContextId(String string) {
        return ExecutionContext.parseECID(string);
    }

    private static CorrelationContext getTop() {
        Stack stack = (Stack)threadStack.get();
        if (stack != null && !stack.empty()) {
            return (CorrelationContext)stack.peek();
        }
        return null;
    }

    private static void push(CorrelationContext correlationContext) {
        Stack<CorrelationContext> stack = (Stack<CorrelationContext>)threadStack.get();
        if (stack == null) {
            stack = new Stack<CorrelationContext>();
            threadStack.set(stack);
        }
        stack.push(correlationContext);
    }

    private static CorrelationContext pop() {
        Stack stack = (Stack)threadStack.get();
        if (stack != null && !stack.empty()) {
            return (CorrelationContext)stack.pop();
        }
        return null;
    }

    static synchronized void shutdown() {
        threadStack = new ThreadLocal();
    }
}

