/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;

public class ODLTextFormatter
implements LogFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private Date m_date = new Date(0L);
    private DateFormat m_dateFmt = new DateFormat();

    public String format(LogMessage logMessage) {
        int n;
        Object object;
        Map map;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("[");
        this.m_date.setTime(logMessage.getTimestamp());
        this.m_dateFmt.format(this.m_date, stringBuffer);
        stringBuffer.append("] ");
        stringBuffer.append("[");
        if (logMessage.getComponentId() != null) {
            stringBuffer.append(logMessage.getComponentId());
        }
        stringBuffer.append("] [");
        MessageType messageType = logMessage.getMessageType();
        stringBuffer.append(messageType.toString());
        if (logMessage.getMessageLevel() > 1 && messageType != MessageType.UNKNOWN) {
            stringBuffer.append(":");
            stringBuffer.append(logMessage.getMessageLevel());
        }
        stringBuffer.append("] [");
        if (logMessage.getMessageId() != null) {
            stringBuffer.append(logMessage.getMessageId());
        }
        stringBuffer.append("] [");
        if (logMessage.getModuleId() != null) {
            stringBuffer.append(logMessage.getModuleId());
        }
        stringBuffer.append("] ");
        if (logMessage.getOrganizationId() != null) {
            stringBuffer.append("[org: ");
            stringBuffer.append(logMessage.getOrganizationId());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostingClientId() != null) {
            stringBuffer.append("[hostingClientId: ");
            stringBuffer.append(logMessage.getHostingClientId());
            stringBuffer.append("] ");
        }
        if (logMessage.getMessageGroup() != null) {
            stringBuffer.append("[group: ");
            stringBuffer.append(logMessage.getMessageGroup());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostId() != null) {
            stringBuffer.append("[host: ");
            stringBuffer.append(logMessage.getHostId());
            stringBuffer.append("] ");
        }
        if (logMessage.getHostNwAddr() != null) {
            stringBuffer.append("[nwaddr: ");
            stringBuffer.append(logMessage.getHostNwAddr());
            stringBuffer.append("] ");
        }
        if (logMessage.getProcessId() != null) {
            stringBuffer.append("[pid: ");
            stringBuffer.append(logMessage.getProcessId());
            stringBuffer.append("] ");
        }
        if (logMessage.getThreadId() != null) {
            stringBuffer.append("[tid: ");
            stringBuffer.append(logMessage.getThreadId());
            stringBuffer.append("] ");
        }
        if (logMessage.getUserId() != null) {
            stringBuffer.append("[userId: ");
            stringBuffer.append(logMessage.getUserId());
            stringBuffer.append("] ");
        }
        if (logMessage.getUpstreamCompId() != null) {
            stringBuffer.append("[upstreamComp: ");
            stringBuffer.append(logMessage.getUpstreamCompId());
            stringBuffer.append("] ");
        }
        if (logMessage.getDownstreamCompId() != null) {
            stringBuffer.append("[downstreamComp: ");
            stringBuffer.append(logMessage.getDownstreamCompId());
            stringBuffer.append("] ");
        }
        if (logMessage.getExecContextId() != null) {
            stringBuffer.append("[ecid: ");
            stringBuffer.append(logMessage.getExecContextId().getUniqueId());
            stringBuffer.append(",");
            stringBuffer.append(logMessage.getExecContextId().getSequenceNumber());
            stringBuffer.append("] ");
        }
        if (logMessage.getErrorInstanceId() != null) {
            stringBuffer.append("[errid: ");
            stringBuffer.append(logMessage.getErrorInstanceId().getUniqueId());
            stringBuffer.append(",");
            stringBuffer.append(logMessage.getErrorInstanceId().getSequenceNumber());
            stringBuffer.append("] ");
        }
        if (logMessage.getDetailLocation() != null) {
            stringBuffer.append("[detailLoc: ");
            stringBuffer.append(logMessage.getDetailLocation());
            stringBuffer.append("] ");
        }
        if (logMessage.getProblemKey() != null) {
            stringBuffer.append("[probKey: ");
            stringBuffer.append(logMessage.getProblemKey());
            stringBuffer.append("] ");
        }
        if ((map = logMessage.getSupplAttrs()) != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                stringBuffer.append("[");
                stringBuffer.append(entry.getKey());
                stringBuffer.append(": ");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("] ");
            }
        }
        if (logMessage.getMessageArgs() != null) {
            object = logMessage.getMessageArgs();
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (((LogMessage.MessageArgument)object[i]).getName() != null) {
                    stringBuffer.append(((LogMessage.MessageArgument)object[i]).getName());
                    stringBuffer.append("=");
                }
                stringBuffer.append(((LogMessage.MessageArgument)object[i]).getValue());
                stringBuffer.append(" ");
            }
        }
        object = logMessage.getMessageText();
        String string = logMessage.getSupplDetail();
        if (object == null) {
            object = "";
        }
        if ((n = ((String)object).indexOf(10)) >= 0) {
            String string2 = ((String)object).substring(0, n);
            string = string == null ? ((String)object).substring(n + 1) : ((String)object).substring(n + 1) + ' ' + string;
            object = string2;
        }
        if (((String)object).startsWith("[")) {
            stringBuffer.append(" ");
        }
        stringBuffer.append((String)object);
        if (string != null) {
            stringBuffer.append("[[");
            stringBuffer.append(LSEP);
            this.escapeBracket(stringBuffer, string);
            stringBuffer.append(LSEP);
            stringBuffer.append("]]");
        }
        stringBuffer.append(LSEP);
        return stringBuffer.toString();
    }

    private void escapeBracket(StringBuffer stringBuffer, String string) {
        int n = string.indexOf("]]\n");
        if (n < 0) {
            stringBuffer.append(string);
            return;
        }
        int n2 = 0;
        do {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append("]] \n");
        } while ((n = string.indexOf("]]\n", n2 = n + 3)) >= 0);
        stringBuffer.append(string.substring(n2));
    }

    public String header() {
        return null;
    }

    public String tail() {
        return null;
    }
}

