/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.DeleteEvent;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;
import oracle.jbo.uicli.binding.JUCtrlHierTypeBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUTreeBinding;

public class JUTreeNodeBinding
extends JUCtrlHierNodeBinding {
    private DefaultMutableTreeNode mTreeNode = new DefaultMutableTreeNode((Object)this);
    private static String PLACE_HOLDER = "$place-holder$";

    protected JUTreeNodeBinding(JTree jTree, JUTreeBinding jUTreeBinding, JUTreeNodeBinding jUTreeNodeBinding, JUIteratorBinding jUIteratorBinding, String string, Object object, boolean bl) {
        this(jUTreeBinding, jUTreeNodeBinding, jUIteratorBinding, null, null, bl);
    }

    protected JUTreeNodeBinding(JTree jTree, JUTreeBinding jUTreeBinding, JUTreeNodeBinding jUTreeNodeBinding, JUIteratorBinding jUIteratorBinding, JUCtrlHierTypeBinding jUCtrlHierTypeBinding, Row row, boolean bl) {
        this(jUTreeBinding, jUTreeNodeBinding, jUIteratorBinding, jUCtrlHierTypeBinding, row, bl);
    }

    protected JUTreeNodeBinding(JUCtrlHierBinding jUCtrlHierBinding, JUCtrlHierNodeBinding jUCtrlHierNodeBinding, JUIteratorBinding jUIteratorBinding, JUCtrlHierTypeBinding jUCtrlHierTypeBinding, Row row, boolean bl) {
        super(jUCtrlHierBinding, jUCtrlHierNodeBinding, jUIteratorBinding, jUCtrlHierTypeBinding, row, bl);
        if (jUCtrlHierNodeBinding != null) {
            if (bl) {
                this.mTreeNode.add(new DefaultMutableTreeNode(PLACE_HOLDER));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = ((JUTreeNodeBinding)jUCtrlHierNodeBinding).getTreeNode();
            defaultMutableTreeNode.insert(this.mTreeNode, defaultMutableTreeNode.getChildCount());
            if (this.mTreeNode.getParent() != defaultMutableTreeNode) {
                this.mTreeNode.setParent(defaultMutableTreeNode);
            }
        }
    }

    public void nodeSelected() {
        RowIterator rowIterator;
        Row[] rowArray;
        JUTreeNodeBinding jUTreeNodeBinding;
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.mParentNode != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeNode.getParent()) != null && (jUTreeNodeBinding = (JUTreeNodeBinding)((Object)defaultMutableTreeNode.getUserObject())) != null && this.mRowKey != null && (rowArray = (rowIterator = this.getRowIterator()).findByKey(this.mRowKey, 1)).length > 0) {
            JUPanelBinding jUPanelBinding = (JUPanelBinding)this.getFormBinding();
            jUPanelBinding.notifyIteratorChanged((DCIteratorBinding)this.getIteratorBinding(), false);
            jUPanelBinding.callBeforeRowNavigated((DCIteratorBinding)jUTreeNodeBinding.getIteratorBinding());
            rowIterator.setCurrentRow(rowArray[0]);
        }
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
    }

    public boolean removeChild(JUCtrlHierNodeBinding jUCtrlHierNodeBinding) {
        if (super.removeChild(jUCtrlHierNodeBinding) && ((JUTreeNodeBinding)jUCtrlHierNodeBinding).mTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = ((JUTreeNodeBinding)jUCtrlHierNodeBinding).mTreeNode;
            defaultMutableTreeNode.removeFromParent();
            defaultMutableTreeNode.setUserObject(null);
            ((JUTreeNodeBinding)jUCtrlHierNodeBinding).mTreeNode = null;
            return true;
        }
        return false;
    }

    public void collapse() {
        if (this.mTreeNode != null) {
            ((JTree)this.getControl()).collapsePath(new TreePath(this.mTreeNode));
        }
    }

    public void expand() {
        JTree jTree = (JTree)this.getControl();
        if (jTree != null) {
            ArrayList arrayList;
            TreePath treePath = this.getTreePath();
            if (treePath.getLastPathComponent() != null) {
                jTree.collapsePath(treePath);
            }
            if ((arrayList = this.getChildren()) != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    JUTreeNodeBinding jUTreeNodeBinding = (JUTreeNodeBinding)((Object)arrayList.get(n));
                    if (jUTreeNodeBinding.getTreePath().getLastPathComponent() != null) {
                        jTree.expandPath(jUTreeNodeBinding.getTreePath());
                    }
                    ++n;
                }
            }
        }
    }

    protected JUCtrlHierNodeBinding findChildNode(Key key) {
        return super.findChildNode(key);
    }

    public Object getValueAt(int n, int n2) {
        return this.mNodeValue;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.mNodeValue = object;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.mTreeNode;
    }

    public TreePath getTreePath() {
        JUTreeNodeBinding jUTreeNodeBinding = (JUTreeNodeBinding)this.getParent();
        if (jUTreeNodeBinding == null) {
            return new TreePath(this.mTreeNode);
        }
        Object[] objectArray = jUTreeNodeBinding.getTreePath().getPath();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = this.mTreeNode;
        return new TreePath(objectArray2);
    }

    public void updateNavigated(NavigationEvent navigationEvent) {
        JUTreeNodeBinding jUTreeNodeBinding;
        if (this.getIteratorBinding().isFindMode()) {
            return;
        }
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (!jUIteratorBinding.hasRSI()) {
            return;
        }
        Row row = navigationEvent.getRow();
        if (row != null && (jUTreeNodeBinding = (JUTreeNodeBinding)this.findMatchingNode(row.getKey())) != null) {
            ((JTree)this.getControl()).setSelectionPath(jUTreeNodeBinding.getTreePath());
        }
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        JUTreeNodeBinding jUTreeNodeBinding;
        if (this.getIteratorBinding().isFindMode()) {
            return;
        }
        Row row = deleteEvent.getRow();
        if (row != null && (jUTreeNodeBinding = (JUTreeNodeBinding)this.findMatchingNode(row.getKey())) != null) {
            jUTreeNodeBinding.mTreeNode.removeFromParent();
            ((JUTreeBinding)this.getHierBinding()).getModelImpl((JTree)this.getControl()).nodeStructureChanged(this.mTreeNode);
        }
    }

    public void updateValuesFromRow(Row row) {
        if (this.getIteratorBinding() == null || this.getIteratorBinding().isFindMode()) {
            return;
        }
        if (this.getParent() == null || row == null) {
            return;
        }
        if (!this.getHierTypeBinding().getViewDefName().equals(row.getStructureDef().getDefFullName())) {
            return;
        }
        JUTreeNodeBinding jUTreeNodeBinding = (JUTreeNodeBinding)this.findMatchingNode(row.getKey());
        if (jUTreeNodeBinding != null) {
            JTree jTree = (JTree)this.getControl();
            super.updateValuesFromRow(row);
            jUTreeNodeBinding = (JUTreeNodeBinding)this.findMatchingNode(row.getKey());
            if (jUTreeNodeBinding != null) {
                TreePath treePath = jUTreeNodeBinding.getTreePath();
                TreeModel treeModel = jTree.getModel();
                treeModel.valueForPathChanged(treePath, (Object)jUTreeNodeBinding);
            }
        }
    }

    public void myUpdateValuesFromRows(Row[] rowArray, boolean bl) {
        JTree jTree = (JTree)this.getControl();
        if (bl) {
            this.mTreeNode.removeAllChildren();
        }
        super.myUpdateValuesFromRows(rowArray, bl);
        TreePath treePath = this.getTreePath();
        ((JUTreeBinding)this.getHierBinding()).getModelImpl(jTree).nodeStructureChanged(this.mTreeNode);
        if (treePath != null && jTree.getModel().isLeaf(treePath.getLastPathComponent())) {
            treePath = treePath.getParentPath();
        }
        jTree.expandPath(treePath);
    }
}

