/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlListBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUSVFocusAdapter;
import oracle.jbo.uicli.jui.JUSpinnerBinding;

public class JUSpinnerBinding
extends JUCtrlListBinding {
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    protected SpinnerModel modelImpl;
    protected boolean mValueUpdating;
    protected JComponent mEditor;
    private static String DEFAULT_DATE_FORMAT_STR = "MM-dd-yyyy";
    private static String DEFAULT_NUMERIC_FORMAT_STR = "#0.##";
    private String mFormatStringForConversion;

    static /* synthetic */ Class class$(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object getControlModel(Object object) {
        this.setControl(object);
        return this.getModelImpl();
    }

    public static SpinnerModel createNavigationBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String[] stringArray) {
        if (!JUIUtil.inDesignTime()) {
            JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
            JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, stringArray, JUCtrlListBinding.LIST_OPER_NAVIGATE);
            SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
            jSpinner.setModel(spinnerModel);
            jUSpinnerBinding.refreshNow();
            return spinnerModel;
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJSpinnerNavigationBinding");
            String string4 = "";
            if (stringArray != null && stringArray.length != 0) {
                string4 = stringArray[0];
            }
            int n = stringArray == null ? 0 : stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(",");
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            Object[] objectArray = new Object[]{String.valueOf(string) + "." + stringBuffer.toString()};
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n3 = 0;
            while (n3 < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n3];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 1) {
                    Object obj = constructor.newInstance(objectArray);
                    SpinnerModel spinnerModel = (SpinnerModel)obj;
                    return spinnerModel;
                }
                ++n3;
            }
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
        catch (Exception exception) {
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
    }

    public static SpinnerModel createLovBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String[] stringArray, String string4) {
        return JUSpinnerBinding.createLovBinding(jUFormBinding, jSpinner, string, string2, string3, stringArray, string4, stringArray, null);
    }

    public static SpinnerModel createLovBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String[] stringArray, String string4, String[] stringArray2, String[] stringArray3) {
        if (!JUIUtil.inDesignTime()) {
            JUIteratorBinding jUIteratorBinding = string != null ? jUFormBinding.getRowIterBinding(string, string2, string3) : null;
            JUIteratorBinding jUIteratorBinding2 = string4 != null ? jUFormBinding.getRangeIterBinding(string4, null, null, -1) : null;
            JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, stringArray, jUIteratorBinding2, stringArray2, stringArray3);
            SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
            jUSpinnerBinding.refreshNow();
            return spinnerModel;
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJLovBindingDef");
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] objectArray = new Object[]{string4, stringArray3, string, stringArray2, stringArray};
            Class<?> clazz2 = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJSpinnerLovBinding");
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor2 = constructorArray[n];
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length == 1) {
                    Object[] objectArray2 = new Object[]{constructor.newInstance(objectArray)};
                    Object obj = constructor2.newInstance(objectArray2);
                    SpinnerModel spinnerModel = (SpinnerModel)obj;
                    return spinnerModel;
                }
                ++n;
            }
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
        catch (Exception exception) {
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
    }

    public static SpinnerModel createEnumerationBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (!JUIUtil.inDesignTime()) {
            JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
            JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, new String[]{string4}, objectArray);
            SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
            jUSpinnerBinding.refreshNow();
            return spinnerModel;
        }
        try {
            String string5 = "oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJSpinnerEnumBinding";
            Class<?> clazz = Class.forName(string5);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 2) {
                    StringBuffer stringBuffer = new StringBuffer(string).append(".").append(string4);
                    Object[] objectArray2 = new Object[]{stringBuffer.toString(), objectArray};
                    Object obj = constructor.newInstance(objectArray2);
                    SpinnerModel spinnerModel = (SpinnerModel)obj;
                    return spinnerModel;
                }
                ++n;
            }
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
        catch (Exception exception) {
            SpinnerModel spinnerModel = null;
            return spinnerModel;
        }
    }

    public static SpinnerModel createEnumerationBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String string4, SpinnerListModel spinnerListModel) {
        JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
        JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, new String[]{string4}, spinnerListModel);
        SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
        jSpinner.setModel(spinnerModel);
        jUSpinnerBinding.refreshNow();
        return spinnerModel;
    }

    public static SpinnerModel createEnumerationBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String string4, SpinnerDateModel spinnerDateModel) {
        JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
        JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, new String[]{string4}, spinnerDateModel);
        SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
        jSpinner.setModel(spinnerModel);
        jUSpinnerBinding.refreshNow();
        return spinnerModel;
    }

    public static SpinnerModel createEnumerationBinding(JUFormBinding jUFormBinding, JSpinner jSpinner, String string, String string2, String string3, String string4, SpinnerNumberModel spinnerNumberModel) {
        JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
        JUSpinnerBinding jUSpinnerBinding = new JUSpinnerBinding(jSpinner, jUIteratorBinding, new String[]{string4}, spinnerNumberModel);
        SpinnerModel spinnerModel = jUSpinnerBinding.getModelImpl();
        jSpinner.setModel(spinnerModel);
        jUSpinnerBinding.refreshNow();
        return jUSpinnerBinding.getModelImpl();
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, int n) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, n);
        this.modelImpl = new JUNavigableSpinnerModel();
        this.setControl(jSpinner);
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, Object[] objectArray) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, objectArray);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.modelImpl = new JUStaticUpdateableSpinnerModel(objectArray);
        this.setControl(jSpinner);
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, SpinnerListModel spinnerListModel) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, spinnerListModel.getList().toArray());
        this.modelImpl = new JUStaticUpdateableSpinnerModel(spinnerListModel);
        this.setControl(jSpinner);
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, SpinnerDateModel spinnerDateModel) {
        this(jSpinner, jUIteratorBinding, stringArray, spinnerDateModel, null);
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, SpinnerDateModel spinnerDateModel, String string) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, JUCtrlListBinding.LIST_OPER_SET_ATTRIBUTE);
        this.modelImpl = new JUSpinnerDateModel(spinnerDateModel);
        this.setStaticList(true);
        this.setControl(jSpinner);
        this.mFormatStringForConversion = string;
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, SpinnerNumberModel spinnerNumberModel) {
        this(jSpinner, jUIteratorBinding, stringArray, spinnerNumberModel, null);
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, SpinnerNumberModel spinnerNumberModel, String string) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, JUCtrlListBinding.LIST_OPER_SET_ATTRIBUTE);
        this.modelImpl = new JUSpinnerNumberModel(spinnerNumberModel);
        this.setStaticList(true);
        this.setControl(jSpinner);
        this.mFormatStringForConversion = string;
    }

    public JUSpinnerBinding(JSpinner jSpinner, JUIteratorBinding jUIteratorBinding, String[] stringArray, JUIteratorBinding jUIteratorBinding2, String[] stringArray2, String[] stringArray3) {
        super((Object)jSpinner, (DCIteratorBinding)jUIteratorBinding, stringArray, (DCIteratorBinding)jUIteratorBinding2, stringArray2, stringArray3);
        this.modelImpl = new JUDynamicUpdateableSpinnerModel();
        this.setControl(jSpinner);
    }

    protected SpinnerModel getModelImpl() {
        return this.modelImpl;
    }

    public void refreshControl() {
        super.refreshControl();
        this.refreshNow();
    }

    void refreshNow() {
        Row row;
        if (this.getIteratorBinding() != null && (row = this.getCurrentRow()) != null) {
            this.updateValuesFromRow(row);
        }
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    public void setControl(Object object) {
        super.setControl(object);
        if (object != null) {
            JSpinner jSpinner = (JSpinner)object;
            if (this.isNavigationBinding()) {
                jSpinner.addChangeListener(new SpinnerChangeListener());
            } else if (this.isLovBinding()) {
                this.mEditor = new JUSpinnerEditor(jSpinner, this.getListDisplayAttrNames());
            } else {
                SpinnerModel spinnerModel = this.getModelImpl();
                if (spinnerModel instanceof SpinnerDateModel) {
                    String string = this.getDateFormatString(this.getFirstAttrName());
                    jSpinner.setModel(spinnerModel);
                    this.mEditor = new JSpinner.DateEditor(jSpinner, string);
                } else if (spinnerModel instanceof SpinnerNumberModel) {
                    String string = this.getNumericFormatString(this.getFirstAttrName());
                    jSpinner.setModel(spinnerModel);
                    this.mEditor = new JSpinner.NumberEditor(jSpinner, string);
                }
            }
            if (this.mEditor != null) {
                jSpinner.setEditor(this.mEditor);
            }
            jSpinner.addFocusListener(new JUSVFocusAdapter((JUControlBinding)this));
        }
    }

    private String getFirstAttrName() {
        String[] stringArray = this.getAttributeNames();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    private boolean isNavigationBinding() {
        SpinnerModel spinnerModel = this.getModelImpl();
        return spinnerModel instanceof JUNavigableSpinnerModel;
    }

    private boolean isLovBinding() {
        SpinnerModel spinnerModel = this.getModelImpl();
        return spinnerModel instanceof JUDynamicUpdateableSpinnerModel;
    }

    public Object getValueAt(int n) {
        Object object = this.modelImpl.getValue();
        if (object == null) {
            object = super.getAttribute(0);
        }
        return object;
    }

    private void setSpinnerEditable(JSpinner jSpinner, boolean bl) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)jComponent).getTextField().setEditable(bl);
            ((JSpinner.DefaultEditor)jComponent).getTextField().setBackground(Color.WHITE);
        } else if (jComponent instanceof JSpinner.DateEditor) {
            ((JSpinner.DateEditor)jComponent).getTextField().setEditable(bl);
            ((JSpinner.DateEditor)jComponent).getTextField().setBackground(Color.WHITE);
        } else if (jComponent instanceof JSpinner.ListEditor) {
            ((JSpinner.ListEditor)jComponent).getTextField().setEditable(bl);
            ((JSpinner.ListEditor)jComponent).getTextField().setBackground(Color.WHITE);
        } else if (jComponent instanceof JSpinner.NumberEditor) {
            ((JSpinner.NumberEditor)jComponent).getTextField().setEditable(bl);
            ((JSpinner.NumberEditor)jComponent).getTextField().setBackground(Color.WHITE);
        }
    }

    public void setValueAt(Object object, int n) {
        if (this.isNavigationBinding() && this.getControl() != null) {
            this.setSpinnerEditable((JSpinner)this.getControl(), false);
        }
        if (this.getControl() == null) {
            return;
        }
        if (n > 0) {
            return;
        }
        Object object2 = this.findMatchingListValue(object);
        try {
            this.mValueUpdating = true;
            if (object2 != null) {
                this.modelImpl.setValue(object2);
            } else if (this.modelImpl instanceof JUNavigableSpinnerModel) {
                this.modelImpl.setValue(object2);
            }
            Object var5_4 = null;
            this.mValueUpdating = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mValueUpdating = false;
            throw throwable;
        }
    }

    public Object findMatchingListValue(Object object) {
        SpinnerModel spinnerModel = this.getModelImpl();
        if (spinnerModel instanceof JUSpinnerDateModel || spinnerModel instanceof JUSpinnerNumberModel) {
            return object;
        }
        return super.findMatchingListValue(object);
    }

    public void setDataValueAt(Object object, int n) {
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.setupListItems(true, true);
    }

    boolean containsNull(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isViewInitialized() {
        if (this.modelImpl != null && ((ModelHelper)((Object)this.modelImpl)).getSize() == 0) {
            return this.mValueList != null && this.mValueList.length == 0;
        }
        return true;
    }

    void callSuperSetupListItems(boolean bl, boolean bl2) {
        super.setupListItems(bl, bl2);
    }

    protected void setupListItems(boolean bl, boolean bl2) {
        if (this.mValueList == null || bl) {
            super.setupListItems(bl, bl2);
        }
        class MRunnable
        implements Runnable {
            final /* synthetic */ JUSpinnerBinding this$0;
            boolean mClean;
            boolean mKeepSel;

            MRunnable(JUSpinnerBinding jUSpinnerBinding, boolean bl, boolean bl2) {
                this.this$0 = jUSpinnerBinding;
                this.mClean = bl;
                this.mKeepSel = bl2;
            }

            public void run() {
                Object[] objectArray = this.this$0.getValueList();
                if (objectArray != null) {
                    ((ModelHelper)((Object)this.this$0.modelImpl)).setListInternal(objectArray);
                }
            }
        }
        SwingUtilities.invokeLater(new MRunnable(this, bl, bl2));
    }

    protected void updateAttributeValue(Object object) {
        if (!this.mValueUpdating) {
            super.setAttribute(0, object);
        }
    }

    protected void updateTargetFromSelectedValue(Object object) {
        if (!this.mValueUpdating) {
            super.updateTargetFromSelectedValue(object);
        }
    }

    protected void navigateTo(ChangeEvent changeEvent) {
        Object object = null;
        Object object2 = changeEvent.getSource();
        if (object2 instanceof SpinnerModel) {
            object = ((SpinnerModel)object2).getValue();
        } else if (object2 instanceof JSpinner) {
            object = ((JSpinner)object2).getValue();
        }
        int n = this.findListIndex(object);
        if (n != -1) {
            this.navigateTo(n);
        }
    }

    protected void navigateTo(int n) {
        RowIterator rowIterator = this.getRowIterator();
        if (rowIterator != null) {
            JUPanelBinding jUPanelBinding = (JUPanelBinding)this.getFormBinding();
            jUPanelBinding.callBeforeRowNavigated((DCIteratorBinding)this.getIteratorBinding());
            rowIterator.setCurrentRowAtRangeIndex(n);
        }
    }

    String getNumericFormatString(String string) {
        if (this.mFormatStringForConversion == null) {
            this.mFormatStringForConversion = this.getFormatString(string);
        }
        if (this.mFormatStringForConversion == null) {
            this.mFormatStringForConversion = DEFAULT_NUMERIC_FORMAT_STR;
        }
        return this.mFormatStringForConversion;
    }

    String getDateFormatString(String string) {
        if (this.mFormatStringForConversion == null) {
            this.mFormatStringForConversion = this.getFormatString(string);
        }
        if (this.mFormatStringForConversion == null) {
            this.mFormatStringForConversion = DEFAULT_DATE_FORMAT_STR;
        }
        return this.mFormatStringForConversion;
    }

    String getFormatString(String string) {
        AttributeDef attributeDef = this.findAttributeDef(string);
        String string2 = null;
        if (attributeDef != null) {
            LocaleContext localeContext;
            AttributeHints attributeHints = attributeDef.getUIHelper();
            ApplicationModule applicationModule = this.getApplicationModule();
            if (applicationModule != null && attributeHints.hasFormatInformation(localeContext = applicationModule.getSession().getLocaleContext())) {
                string2 = attributeHints.getFormat(localeContext);
            }
        }
        return string2;
    }

    protected String getDefaultDateFormatString() {
        return DEFAULT_DATE_FORMAT_STR;
    }

    protected String getDefaultNumericFormatString() {
        return DEFAULT_NUMERIC_FORMAT_STR;
    }

    class SpinnerChangeListener
    implements ChangeListener {
        SpinnerChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!JUSpinnerBinding.this.mValueUpdating) {
                JUSpinnerBinding.this.navigateTo(changeEvent);
            }
        }
    }

    public static class JUSpinnerEditor
    extends JTextField
    implements ChangeListener {
        String[] displayAttrNames;

        JUSpinnerEditor(JSpinner jSpinner, String[] stringArray) {
            jSpinner.addChangeListener(this);
            this.displayAttrNames = stringArray;
            this.setPreferredSize(new Dimension(100, 25));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            Object object = jSpinner.getValue();
            if (object instanceof Row) {
                Row row = (Row)object;
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.displayAttrNames.length) {
                    Object object2 = row.getAttribute(this.displayAttrNames[n]);
                    if (object2 != null) {
                        stringBuffer.append(object2);
                    }
                    ++n;
                }
                this.setText(stringBuffer.toString());
            } else {
                Object object3 = jSpinner.getValue();
                String string = object3 == null ? "" : object3.toString();
                this.setText(string);
            }
        }
    }

    class JUDynamicUpdateableSpinnerModel
    extends JUUpdateableSpinnerModel
    implements ModelHelper {
        JUDynamicUpdateableSpinnerModel() {
        }

        public int getSize() {
            List<?> list = this.getList();
            return list != null ? list.size() : -1;
        }

        public void setListInternal(Object[] objectArray) {
            List<Object> list = Arrays.asList(objectArray);
            if (list.size() > 0) {
                super.setList(list);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                arrayList.add(null);
                super.setList(arrayList);
            }
        }

        public void setValue(Object object) {
            JUSpinnerBinding.this.updateTargetFromSelectedValue(object);
            if (object != null && this.getList().indexOf(object) >= 0) {
                super.setValue(object);
            }
        }
    }

    class JUStaticUpdateableSpinnerModel
    extends JUUpdateableSpinnerModel
    implements ModelHelper {
        JUStaticUpdateableSpinnerModel(Object[] objectArray) {
            super(objectArray);
        }

        JUStaticUpdateableSpinnerModel(SpinnerListModel spinnerListModel) {
            super(spinnerListModel);
        }

        public int getSize() {
            return 1;
        }

        public void setListInternal(Object[] objectArray) {
        }

        public void setValue(Object object) {
            JUSpinnerBinding.this.updateAttributeValue(object);
            if (object != null && this.getList().indexOf(object) >= 0) {
                super.setValue(object);
            }
        }
    }

    class JUUpdateableSpinnerModel
    extends SpinnerListModel {
        JUUpdateableSpinnerModel() {
        }

        JUUpdateableSpinnerModel(Object[] objectArray) {
            this.setList(Arrays.asList(objectArray));
        }

        JUUpdateableSpinnerModel(SpinnerListModel spinnerListModel) {
            this.setList(spinnerListModel.getList());
        }

        public int getSize() {
            List<?> list = this.getList();
            return list != null ? list.size() : -1;
        }

        public void setValue(Object object) {
            if (object != null && this.getList().indexOf(object) >= 0) {
                super.setValue(object);
            }
        }
    }

    class JUSpinnerNumberModel
    extends SpinnerNumberModel
    implements ModelHelper {
        Class valueClass;

        JUSpinnerNumberModel() {
        }

        JUSpinnerNumberModel(SpinnerNumberModel spinnerNumberModel) {
            super.setMaximum(spinnerNumberModel.getMaximum());
            super.setMinimum(spinnerNumberModel.getMinimum());
            super.setStepSize(spinnerNumberModel.getStepSize());
            super.setValue(spinnerNumberModel.getValue());
            this.valueClass = spinnerNumberModel.getValue().getClass();
        }

        public void setListInternal(Object[] objectArray) {
        }

        public int getSize() {
            return 1;
        }

        public void setValue(Object object) {
            if (!JUSpinnerBinding.this.mValueUpdating) {
                JUSpinnerBinding.this.updateAttributeValue(object);
            } else {
                java.lang.Number number = this.toNumber(object);
                if (number != null) {
                    super.setValue(number);
                }
            }
        }

        java.lang.Number toNumber(Object object) {
            if (object instanceof java.lang.Number) {
                return (java.lang.Number)object;
            }
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                return new Double(d);
            }
            if (object instanceof String) {
                return this.getNumericValue((String)object);
            }
            return null;
        }

        java.lang.Number getNumericValue(String string) {
            String string2 = JUSpinnerBinding.this.getAttributeNames()[0];
            String string3 = JUSpinnerBinding.this.getNumericFormatString(string2);
            try {
                DecimalFormat decimalFormat = new DecimalFormat();
                if (string3 != null) {
                    decimalFormat.applyPattern(string3);
                }
                java.lang.Number number = decimalFormat.parse(string);
                if (this.valueClass.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = JUSpinnerBinding.class$("java.lang.Float")) : class$java$lang$Float)) {
                    Float f = new Float(number.floatValue());
                    return f;
                }
                if (this.valueClass.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = JUSpinnerBinding.class$("java.lang.Double")) : class$java$lang$Double)) {
                    Double d = new Double(number.doubleValue());
                    return d;
                }
                if (this.valueClass.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = JUSpinnerBinding.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    Integer n = new Integer(number.intValue());
                    return n;
                }
                if (this.valueClass.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = JUSpinnerBinding.class$("java.lang.Long")) : class$java$lang$Long)) {
                    Long l = new Long(number.longValue());
                    return l;
                }
                java.lang.Number number2 = number;
                return number2;
            }
            catch (ParseException parseException) {
                java.lang.Number number = null;
                return number;
            }
        }
    }

    class JUSpinnerDateModel
    extends SpinnerDateModel
    implements ModelHelper {
        JUSpinnerDateModel() {
        }

        JUSpinnerDateModel(SpinnerDateModel spinnerDateModel) {
            super.setStart(spinnerDateModel.getStart());
            super.setEnd(spinnerDateModel.getEnd());
            super.setCalendarField(spinnerDateModel.getCalendarField());
            super.setValue(spinnerDateModel.getValue());
        }

        public void setListInternal(Object[] objectArray) {
        }

        public int getSize() {
            return 1;
        }

        public void setValue(Object object) {
            if (!JUSpinnerBinding.this.mValueUpdating) {
                if (object instanceof java.util.Date) {
                    JUSpinnerBinding.this.updateAttributeValue(this.toTimeStamp((java.util.Date)object));
                } else {
                    JUSpinnerBinding.this.updateAttributeValue(object);
                }
            } else {
                java.util.Date date = this.toDate(object);
                if (date != null) {
                    super.setValue(date);
                }
            }
        }

        private java.util.Date toDate(Object object) {
            if (object instanceof java.util.Date) {
                return (java.util.Date)object;
            }
            if (object instanceof oracle.jbo.domain.Date) {
                Date date = ((oracle.jbo.domain.Date)object).dateValue();
                return date;
            }
            if (object instanceof String) {
                return this.getDateValue((String)object);
            }
            return null;
        }

        private java.util.Date getDateValue(String string) {
            String string2 = JUSpinnerBinding.this.getAttributeNames()[0];
            String string3 = JUSpinnerBinding.this.getDateFormatString(string2);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                java.util.Date date = simpleDateFormat.parse(string);
                return date;
            }
            catch (ParseException parseException) {
                java.util.Date date = null;
                return date;
            }
        }

        Timestamp toTimeStamp(java.util.Date date) {
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            return null;
        }
    }

    class JUNavigableSpinnerModel
    extends SpinnerListModel
    implements ModelHelper {
        JUNavigableSpinnerModel() {
        }

        public void setListInternal(Object[] objectArray) {
            List<Object> list = Arrays.asList(objectArray);
            if (list.size() > 0) {
                this.setList(list);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                arrayList.add(null);
                this.setList(arrayList);
            }
        }

        public void setValue(Object object) {
            if (!this.isEmptyList() && object != null && this.getList().indexOf(object) >= 0) {
                super.setValue(object);
            }
        }

        boolean isEmptyList() {
            Object obj;
            List<?> list = this.getList();
            int n = list.size();
            if (n == 1 && (obj = list.get(0)) != null && obj.toString().equals("empty")) {
                return true;
            }
            return n == 0;
        }

        public int getSize() {
            List<?> list = this.getList();
            return list != null ? list.size() : -1;
        }
    }

    interface ModelHelper {
        public void setListInternal(Object[] var1);

        public int getSize();
    }
}

