/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.math.BigInteger;
import oracle.i18n.util.builder.NLTParserException;

public class CharConvBuilder {
    public static final String HEXPREFIX = "0000";
    public static final String CHARCONVNAME = "lx2";
    public static final String CONVERTERDIR = "/oracle/i18n/data/";
    public static final int ORACHARMASK = 255;
    public static final int UCSCHARWIDTH = 16;
    public static final int ORACHARWIDTH = 16;
    public static final int BYTEWIDTH = 8;
    public static final int HIBYTEMASK = 65280;
    public static final int LOWBYTEMASK = 255;
    public static final int INVALID_ORA_CHAR = -1;
    public static final int DEFAULT_UCS_REPLACEMENT = 65533;

    public static String formatCharConvClassName(int n) {
        String string = Integer.toHexString(n);
        String string2 = HEXPREFIX.substring(0, HEXPREFIX.length() - string.length()) + string;
        return CHARCONVNAME + string2;
    }

    static String formatCharsetId(int n) {
        String string = Integer.toHexString(n);
        String string2 = HEXPREFIX.substring(0, HEXPREFIX.length() - string.length()) + string;
        return string2;
    }

    public static final long convertUTF32toUTF16(long l) {
        if (l > 65535L) {
            if ((l & 0xFFFFFFFFL) > 1048575L || l > 0xD8000000L && l < 0xDFFFFFFFL) {
                return l;
            }
            long l2 = 0xD8L | l - 65536L >> 18 & 0xFFL;
            l2 = l - 65536L >> 10 & 0xFFL | l2 << 8;
            l2 = 0xDCL | (l & 0x3FFL) >> 8 & 0xFFL | l2 << 8;
            l2 = l & 0xFFL | l2 << 8;
            return l2;
        }
        return l;
    }

    public static int stringToInt(String string) throws NLTParserException {
        try {
            BigInteger bigInteger = null;
            bigInteger = string.length() > 2 && (string.substring(0, 2).equals("0x") || string.substring(0, 2).equals("0X") || string.substring(0, 2).equals("\\x")) ? new BigInteger(string.substring(2), 16) : new BigInteger(string);
            return (int)CharConvBuilder.convertUTF32toUTF16(bigInteger.intValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new NLTParserException("Bad number format");
        }
    }
}

