/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import oracle.i18n.util.CharConvBuilder.CharDataParser;
import oracle.i18n.util.CharConvBuilder.TokenParser;

public class DataTypeParser
extends CharDataParser {
    private static final boolean DEBUG = false;
    private long INTEGERMASK = -1L;
    private long HIGHBYTEMASK = -65536L;
    private int MAXLEADCODE = 4;
    private char[] LeadCode = new char[this.MAXLEADCODE];
    private int maxByte;
    private boolean fixedWidth;
    private boolean tooManyLeadCode;
    private boolean isEBCDICBASED;
    private boolean isASCIIBASED;
    private boolean isFIXEDWIDTH;
    private boolean isSHIFT;
    private boolean isUNICODE;
    private boolean isSPECIALRANGE;
    public int baseCharID;
    public int typeID;

    public DataTypeParser(FileInputStream fileInputStream) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = DataTypeParser.getTokenizer(fileInputStream);
        boolean bl = false;
        int n2 = 0;
        String string = "";
        int n3 = 1;
        this.maxByte = 0;
        this.fixedWidth = true;
        this.isEBCDICBASED = false;
        this.isASCIIBASED = false;
        this.isFIXEDWIDTH = false;
        this.isSHIFT = false;
        this.isUNICODE = false;
        this.isSPECIALRANGE = false;
        this.tooManyLeadCode = false;
        this.typeID = -1;
        this.baseCharID = -1;
        for (int i = 0; i < this.MAXLEADCODE; ++i) {
            this.LeadCode[i] = '\u0000';
        }
        block20: while ((n = streamTokenizer.nextToken()) != -1 && !bl) {
            switch (n2) {
                case 0: 
                case 2: {
                    if (n == -3 || n == 34) {
                        string = string + streamTokenizer.sval;
                        n2 = 1;
                        n3 = 1;
                        continue block20;
                    }
                    string = "";
                    continue block20;
                }
                case 1: {
                    switch (n) {
                        case 95: {
                            string = string + (char)n;
                            n2 = 2;
                            continue block20;
                        }
                        case 61: {
                            n2 = 3;
                            continue block20;
                        }
                        case -3: {
                            DataTypeParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            n2 = 0;
                            string = "";
                            continue block20;
                        }
                    }
                    n2 = DataTypeParser.processSyntaxError(streamTokenizer, n3);
                    string = "";
                    continue block20;
                }
                case 3: {
                    switch (n) {
                        case 123: {
                            if (string.compareTo("character_data") == 0) {
                                this.parseCharInfo(streamTokenizer, n3);
                            } else if (string.compareTo("flags") == 0) {
                                this.parseFlagInfo(streamTokenizer, n3);
                            } else {
                                n3 = 2;
                                DataTypeParser.skipToEndOfDelimiter(streamTokenizer, n3);
                            }
                            n2 = 0;
                            string = "";
                            continue block20;
                        }
                    }
                    if (string.compareTo("base_char_set") == 0) {
                        this.baseCharID = TokenParser.getInteger(streamTokenizer);
                        n2 = 0;
                        string = "";
                        continue block20;
                    }
                    DataTypeParser.skipToEndOfDelimiter(streamTokenizer, n3);
                    n2 = 0;
                    string = "";
                    continue block20;
                }
            }
            n2 = DataTypeParser.processSyntaxError(streamTokenizer, n3);
            string = "";
        }
        if (this.tooManyLeadCode) {
            System.err.println("Ginstall can not support character sets with");
            System.err.println("more than 4 lead codes");
            this.typeID = -1;
            return;
        }
        if (this.isUNICODE) {
            return;
        }
        switch (this.maxByte) {
            case 1: {
                this.typeID = 0;
                return;
            }
            case 2: {
                this.typeID = this.isSHIFT ? 7 : (this.isFIXEDWIDTH ? 6 : (this.isSPECIALRANGE ? 4 : 1));
                return;
            }
            case 3: {
                if (!this.isFIXEDWIDTH) {
                    this.typeID = 2;
                }
                return;
            }
            case 4: {
                this.typeID = this.isFIXEDWIDTH ? 3 : 5;
                return;
            }
        }
        System.err.println("Ginstall can not support character sets with");
        System.err.println("characters longer than 4 bytes");
        this.typeID = -1;
    }

    private boolean parseFlagInfo(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        String string = null;
        while ((n2 = streamTokenizer.nextToken()) != -1) {
            switch (n2) {
                case 125: {
                    return true;
                }
                case -3: {
                    string = TokenParser.getString(streamTokenizer, 125);
                    if (string.indexOf("ascii") != -1) {
                        this.isASCIIBASED = true;
                    }
                    if (string.indexOf("fixed") != -1) {
                        this.isFIXEDWIDTH = true;
                    }
                    if (string.indexOf("ebcdic") != -1) {
                        this.isEBCDICBASED = true;
                    }
                    if (string.indexOf("shift") != -1) {
                        this.isSHIFT = true;
                    }
                    if (string.indexOf("unicode") != -1) {
                        this.isUNICODE = true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean parseCharInfo(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2;
        int n3 = 0;
        long l = 0L;
        long l2 = 0L;
        while ((n2 = streamTokenizer.nextToken()) != -1) {
            block2 : switch (n3) {
                case 0: {
                    switch (n2) {
                        case -2: {
                            try {
                                l = TokenParser.getLong(streamTokenizer);
                                char c = (char)((l & this.HIGHBYTEMASK) >> 16);
                                if (l > 65535L) {
                                    int n4;
                                    for (n4 = 0; n4 < this.MAXLEADCODE; ++n4) {
                                        if (this.LeadCode[n4] == '\u0000') {
                                            this.LeadCode[n4] = c;
                                            break;
                                        }
                                        if (this.LeadCode[n4] == c) break;
                                    }
                                    if (n4 >= this.MAXLEADCODE) {
                                        n3 = DataTypeParser.processSyntaxError(streamTokenizer, n);
                                        this.tooManyLeadCode = true;
                                    }
                                }
                                if (l > 0xFFFFFFL) {
                                    this.maxByte = Math.max(this.maxByte, 4);
                                } else if (l > 65535L) {
                                    this.maxByte = Math.max(this.maxByte, 3);
                                } else if (l > 255L) {
                                    this.maxByte = Math.max(this.maxByte, 2);
                                } else {
                                    this.maxByte = Math.max(this.maxByte, 1);
                                    if (l > 127L) {
                                        this.isSPECIALRANGE = true;
                                    }
                                }
                                n3 = 14;
                                break block2;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("sourceCodePoint = " + Long.toHexString(l));
                                TokenParser.processSyntaxError(streamTokenizer, n);
                                return false;
                            }
                        }
                        case 125: {
                            return true;
                        }
                    }
                    break;
                }
                case 14: {
                    if (n2 != 58) {
                        TokenParser.processSyntaxError(streamTokenizer, n);
                        return false;
                    }
                    n3 = 9;
                    break;
                }
                case 9: {
                    try {
                        l2 = TokenParser.getLong(streamTokenizer);
                        n3 = 15;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TokenParser.processSyntaxError(streamTokenizer, n);
                        return false;
                    }
                }
                case 15: {
                    switch (n2) {
                        case 44: 
                        case 125: {
                            if (n2 == 44) {
                                n3 = 0;
                                break block2;
                            }
                            return true;
                        }
                    }
                    TokenParser.processSyntaxError(streamTokenizer, n);
                    return false;
                }
            }
        }
        return true;
    }
}

