/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public abstract class OraNumberFormat
extends Format {
    static final int ORACLE_NUMBER_FORMAT = 0;
    static final int ORACLE_CURRENCY_FORMAT = 1;
    static final int NULL_FIELD = -1;
    public static final int ALL_FIELD = 1000;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private boolean groupingUsed = true;
    private boolean parseIntegerOnly = false;
    private int maximumIntegerDigits = 40;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 3;
    private int minimumFractionDigits = 0;

    public static OraNumberFormat getCurrencyInstance() {
        return OraNumberFormat.getInstance(OraLocaleInfo.getDefault(), 1);
    }

    public static OraNumberFormat getCurrencyInstance(Locale locale) {
        return OraNumberFormat.getCurrencyInstance(OraLocaleInfo.getInstance(locale));
    }

    public static OraNumberFormat getCurrencyInstance(OraLocaleInfo oraLocaleInfo) {
        return OraNumberFormat.getInstance(oraLocaleInfo, 1);
    }

    public static String getDefaultCurrencyFormatPattern(Locale locale) {
        return OraNumberFormat.getDefaultCurrencyFormatPattern(OraLocaleInfo.getInstance(locale));
    }

    public static String getDefaultCurrencyFormatPattern(OraLocaleInfo oraLocaleInfo) {
        return OraNumberFormat.getDefaultCurrencyFormatPattern(oraLocaleInfo.getOraTerritory());
    }

    public static String getDefaultNumberFormatPattern(Locale locale) {
        return OraNumberFormat.getDefaultNumberFormatPattern(OraLocaleInfo.getInstance(locale));
    }

    public static String getDefaultNumberFormatPattern(OraLocaleInfo oraLocaleInfo) {
        return OraNumberFormat.getDefaultNumberFormatPattern(oraLocaleInfo.getOraTerritory());
    }

    public static OraNumberFormat getInstance() {
        return OraNumberFormat.getNumberInstance();
    }

    public static OraNumberFormat getInstance(Locale locale) {
        return OraNumberFormat.getInstance(OraLocaleInfo.getInstance(locale));
    }

    public static OraNumberFormat getInstance(OraLocaleInfo oraLocaleInfo) {
        return OraNumberFormat.getInstance(oraLocaleInfo, 0);
    }

    public static OraNumberFormat getNumberInstance() {
        return OraNumberFormat.getInstance(OraLocaleInfo.getDefault(), 0);
    }

    public static OraNumberFormat getNumberInstance(Locale locale) {
        return OraNumberFormat.getNumberInstance(OraLocaleInfo.getInstance(locale));
    }

    public static OraNumberFormat getNumberInstance(OraLocaleInfo oraLocaleInfo) {
        return OraNumberFormat.getInstance(oraLocaleInfo, 0);
    }

    public String format(BigDecimal bigDecimal) {
        return this.format(bigDecimal, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(BigInteger bigInteger) {
        return this.format(bigInteger, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(double d) {
        return this.format(d, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(long l) {
        return this.format(l, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(BigDecimal var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(BigInteger var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return this.format((Long)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Double || object instanceof Float) {
            return this.format((Double)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException(GDKMessage.getMessage(5089));
    }

    public Number parse(String string) throws ParseException {
        Number number;
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            number = this.parse(string, parsePosition);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), parsePosition.getErrorIndex());
        }
        return number;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    void setMaximumIntegerDigits(int n) {
        int n2 = this.maximumIntegerDigits = n < 0 ? 0 : n;
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    void setMinimumIntegerDigits(int n) {
        int n2 = this.minimumIntegerDigits = n < 0 ? 0 : n;
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    void setMaximumFractionDigits(int n) {
        int n2 = this.maximumFractionDigits = n < 0 ? 0 : n;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    void setMinimumFractionDigits(int n) {
        int n2 = this.minimumFractionDigits = n < 0 ? 0 : n;
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    public Object clone() {
        OraNumberFormat oraNumberFormat = (OraNumberFormat)super.clone();
        return oraNumberFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraNumberFormat)) {
            return false;
        }
        OraNumberFormat oraNumberFormat = (OraNumberFormat)object;
        return this.maximumIntegerDigits == oraNumberFormat.maximumIntegerDigits && this.minimumIntegerDigits == oraNumberFormat.minimumIntegerDigits && this.maximumFractionDigits == oraNumberFormat.maximumFractionDigits && this.minimumFractionDigits == oraNumberFormat.minimumFractionDigits && this.groupingUsed == oraNumberFormat.groupingUsed && this.parseIntegerOnly == oraNumberFormat.parseIntegerOnly;
    }

    private static OraNumberFormat getInstance(OraLocaleInfo oraLocaleInfo, int n) {
        return new OraDecimalFormat(oraLocaleInfo, n);
    }

    private static String getDefaultCurrencyFormatPattern(OraTerritory oraTerritory) {
        String string = oraTerritory.getNLSCurrencyFormatPositive().pattern;
        String string2 = oraTerritory.getNLSCurrencyFormatNegative().pattern;
        if (string.equals(string2)) {
            return string;
        }
        return string + ';' + string2;
    }

    private static String getDefaultNumberFormatPattern(OraTerritory oraTerritory) {
        String string = oraTerritory.getNLSNumberFormatPositive().pattern;
        String string2 = oraTerritory.getNLSNumberFormatNegative().pattern;
        if (string.equals(string2)) {
            return string;
        }
        return string + ';' + string2;
    }
}

