/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import oracle.ord.im.OrdHttpUploadException;
import oracle.ord.im.OrdMultipartHeader;
import oracle.ord.im.OrdMultipartInputStream;
import oracle.ord.im.OrdMultipartUtil;

class OrdMultipartBodyInputStream
extends InputStream {
    private OrdMultipartInputStream mpIn;
    private byte[] delimiter;
    private int delimiterLen;
    private int delimiterOffset;
    private int delimiterMatched;
    private int lastByteRead;
    private byte[] aByte;
    private boolean endOfData;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int DASH = 45;
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String BOUNDARY_ENTITY = "boundary";

    OrdMultipartBodyInputStream(OrdMultipartInputStream ordMultipartInputStream, String string) throws OrdHttpUploadException {
        this.mpIn = ordMultipartInputStream;
        this.aByte = new byte[1];
        OrdMultipartHeader ordMultipartHeader = new OrdMultipartHeader(CONTENT_TYPE_HEADER, string, true);
        String string2 = ordMultipartHeader.getHeaderEntity(1);
        String string3 = ordMultipartHeader.getHeaderEntityValue(1);
        if (string2 == null || !string2.equalsIgnoreCase(BOUNDARY_ENTITY) || string3 == null) {
            throw new OrdHttpUploadException(101, ordMultipartHeader.getHeader());
        }
        this.delimiterLen = 4 + string3.length();
        this.delimiter = new byte[this.delimiterLen];
        this.delimiter[0] = 13;
        this.delimiter[1] = 10;
        this.delimiter[2] = 45;
        this.delimiter[3] = 45;
        OrdMultipartUtil.copyStringToByteArray(string3, this.delimiter, 4);
    }

    boolean checkDelimiter(byte[] byArray, int n) {
        int n2 = this.delimiterLen - 2;
        if (n < n2) {
            return false;
        }
        int n3 = 0;
        int n4 = 2;
        while (n3 < n2) {
            if (byArray[n3] != this.delimiter[n4]) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public void close() throws IOException {
        if (!this.endOfData) {
            byte[] byArray = new byte[512];
            while (!this.endOfData) {
                this.read(byArray, 0, byArray.length);
            }
        }
    }

    void open() {
        this.delimiterOffset = 0;
        this.delimiterMatched = 0;
        this.lastByteRead = -1;
        this.endOfData = false;
    }

    public int read() throws IOException {
        int n = this.read(this.aByte, 0, 1);
        if (n > 0) {
            return this.aByte[0] & 0xFF;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = var3_3;
        if (!this.endOfData) ** GOTO lbl45
        return -1;
lbl-1000:
        // 1 sources

        {
            if (this.delimiterMatched > 0) {
                var5_5 = this.delimiterMatched > var3_3 ? var3_3 : this.delimiterMatched;
                System.arraycopy(this.delimiter, this.delimiterOffset, var1_1, var2_2, var5_5);
                var3_3 -= var5_5;
                var2_2 += var5_5;
                this.delimiterMatched -= var5_5;
                this.delimiterOffset += var5_5;
                continue;
            }
            if (this.lastByteRead == -1) {
                this.lastByteRead = this.mpIn.read();
            }
            while (var3_3 > 0) {
                if (this.lastByteRead == 13) break;
                var1_1[var2_2] = (byte)this.lastByteRead;
                ++var2_2;
                --var3_3;
                this.lastByteRead = this.mpIn.read();
            }
            if (var3_3 == 0) break;
            this.delimiterOffset = 0;
            this.delimiterMatched = 1;
            while (this.delimiterMatched < this.delimiterLen) {
                this.lastByteRead = this.mpIn.read();
                if (this.lastByteRead != this.delimiter[this.delimiterMatched]) break;
                ++this.delimiterMatched;
            }
            if (this.delimiterMatched < this.delimiterLen) continue;
            this.lastByteRead = this.mpIn.read();
            if (this.lastByteRead == 45) {
                this.lastByteRead = this.mpIn.read();
                if (this.lastByteRead != 45) {
                    throw new OrdHttpUploadException(110, "0x" + Integer.toHexString(this.lastByteRead));
                }
                this.lastByteRead = this.mpIn.read();
            }
            if (this.lastByteRead == 13) {
                this.lastByteRead = this.mpIn.read();
                if (this.lastByteRead != 10) {
                    throw new OrdHttpUploadException(109);
                }
            } else {
                throw new OrdHttpUploadException(110, "0x" + Integer.toHexString(this.lastByteRead));
            }
            this.lastByteRead = -1;
            this.endOfData = true;
            break;
lbl45:
            // 3 sources

            ** while (var3_3 > 0)
        }
lbl46:
        // 3 sources

        return var4_4 - var3_3;
    }
}

