/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.TransactionStateEvent;
import oracle.jbo.TransactionStateListener;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.TypeMarshaller;
import oracle.jbo.domain.BFileDomain;
import oracle.jbo.domain.BlobDomain;
import oracle.jbo.domain.ClobDomain;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.MarshalledDomain;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainReaderFactory;
import oracle.jbo.domain.XMLDomainWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.MutableStruct;
import oracle.ord.im.ExpectedSQLException;
import oracle.ord.im.MethodNotImplementedException;
import oracle.ord.im.NotConnectedException;
import oracle.ord.im.OrdByteArraySource;
import oracle.ord.im.OrdContentSource;
import oracle.ord.im.OrdDomainIOInterface;
import oracle.ord.im.OrdDomainState;
import oracle.ord.im.OrdDomainSupportInterface;
import oracle.ord.im.OrdDomainUtil;
import oracle.ord.im.OrdFileSource;
import oracle.ord.im.OrdHttpUploadFile;
import oracle.ord.im.OrdHttpUploadFileSource;
import oracle.ord.im.OrdSource;
import oracle.ord.im.OrdVideo;
import oracle.ord.im.OrdVideoBase;
import oracle.ord.im.WrongTierException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.svcmsg.ResponseValues;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OrdVideoDomain
extends OrdVideo
implements MarshalledDomain,
TransactionStateListener,
Serializable,
XMLDomainWriter,
XMLDomainReaderFactory,
DomainOwnerInterface,
LobInterface,
AttributeList,
OrdDomainSupportInterface,
OrdDomainState,
OrdDomainIOInterface {
    private int m_tier;
    private boolean m_connected;
    private BlobDomain m_blobDomain;
    private BFileDomain m_bfileDomain;
    private ClobDomain m_clobDomain;
    private DomainOwnerInterface m_owner;
    private int m_ownerAttrIndex;
    private String m_indexString;
    private boolean m_ownerNotModified;
    private Transaction m_transaction;
    private Object m_lastPostListener;
    private OrdContentSource m_contentSource;
    private boolean m_reuseLobs;
    private String m_ctTempFilePath;
    private boolean m_isAddedToTransaction;
    private boolean m_doneRollback;
    private Exception m_exception;
    private int m_objId;
    private static int m_objIdCounter = 0;
    private static final OrdVideoDomain s_ordVideoDomainFactory = new OrdVideoDomain();
    private static final long serialVersionUID = -8938853442752945910L;
    private boolean m_forClientPostNewDomain;

    private /* synthetic */ void $init$() {
        this.m_tier = 0;
        this.m_connected = false;
        this.m_blobDomain = null;
        this.m_bfileDomain = null;
        this.m_clobDomain = null;
        this.m_owner = null;
        this.m_ownerAttrIndex = -1;
        this.m_indexString = null;
        this.m_ownerNotModified = true;
        this.m_lastPostListener = null;
        this.m_contentSource = null;
        this.m_reuseLobs = false;
        this.m_ctTempFilePath = null;
        this.m_isAddedToTransaction = false;
        this.m_doneRollback = false;
        this.m_exception = null;
        this.m_objId = -1;
        this.m_forClientPostNewDomain = false;
    }

    public OrdVideoDomain() {
        this.$init$();
        this.initConstructor();
    }

    public OrdVideoDomain(byte[] byArray) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdByteArraySource(byArray));
    }

    public OrdVideoDomain(String string) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdFileSource(string));
    }

    public OrdVideoDomain(OrdContentSource ordContentSource) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(ordContentSource);
    }

    public OrdVideoDomain(OrdHttpUploadFile ordHttpUploadFile) {
        this.$init$();
        this.initConstructor();
        this.setContentSource(new OrdHttpUploadFileSource(ordHttpUploadFile));
    }

    private void initConstructor() {
        try {
            this.setSourceObject(new OrdSource());
            this.setContent(BLOB.empty_lob());
            this.setComments(CLOB.empty_lob());
            this.m_blobDomain = new BlobDomain();
            this.m_clobDomain = new ClobDomain();
            this.m_bfileDomain = new BFileDomain();
            this.m_objId = m_objIdCounter++;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public int getObjectId() {
        return this.m_objId;
    }

    public static CustomDatumFactory getFactory() {
        return s_ordVideoDomainFactory;
    }

    public static CustomDatumFactory getCustomDatumFactory() {
        return s_ordVideoDomainFactory;
    }

    public String toString() {
        String string = null;
        int n = 0;
        try {
            string = this.getMimeType();
            n = this.getContentLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "OrdVideoDomain:" + string + ":" + n;
    }

    public int hashCode() {
        try {
            Timestamp timestamp = this.getUpdateTime();
            int n = timestamp.hashCode() + this.getContentLength();
            return n;
        }
        catch (SQLException sQLException) {
            int n = super.hashCode();
            return n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OrdVideoDomain) {
            if (this.m_doneRollback) {
                return this == object;
            }
            try {
                Timestamp timestamp = this.getUpdateTime();
                Timestamp timestamp2 = ((OrdVideoDomain)object).getUpdateTime();
                int n = 0;
                int n2 = 0;
                try {
                    n = this.getContentLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = ((OrdVideoDomain)object).getContentLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (timestamp == null && timestamp2 == null && n == n2) {
                    boolean bl = true;
                    return bl;
                }
                if (timestamp.equals(timestamp2) && n == n2) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public BLOB getContent() throws SQLException {
        return super.getContent();
    }

    public BFILE getBFILE() throws SQLException {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdVideoDomain.getBFILE()", "Client Tier");
        }
        return super.getBFILE();
    }

    public boolean isLocal() throws SQLException {
        return super.isLocal();
    }

    public void clearLocal() throws SQLException {
        this.domainToBeModified();
        super.clearLocal();
        this.setAttribute();
    }

    public void setLocal() throws SQLException {
        this.domainToBeModified();
        super.setLocal();
        this.setAttribute();
    }

    public void deleteContent() throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("deleteConent()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "deleteContent", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.deleteContent();
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void importData(byte[][] byArray) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("importData()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "importData", new String[]{byArray.getClass().getName()}, new Object[]{byArray});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.importData(byArray);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public void importFrom(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("importFrom()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "importFrom", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{byArray, string, string2, string3});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.importFrom(byArray, string, string2, string3);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public boolean loadDataFromFile(String string) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromFile()", "OrdVideoDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            FileInputStream fileInputStream = new FileInputStream(string);
            OrdDomainUtil.fromInputToOutput(fileInputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromFile(string);
        }
        this.setAttribute();
        return true;
    }

    public boolean loadDataFromInputStream(InputStream inputStream) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromInputStream()", "OrdVideoDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            OrdDomainUtil.fromInputToOutput(inputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromInputStream(inputStream);
        }
        this.setAttribute();
        return true;
    }

    public boolean loadDataFromByteArray(byte[] byArray) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("loadDataFromByteArray()", "OrdVideoDomain");
        }
        this.domainToBeModified();
        if (this.m_tier == 1) {
            this.deleteContent();
            this.setLocal();
            this.setUpdateTime(null);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            OrdDomainUtil.fromInputToOutput(byteArrayInputStream, this.m_blobDomain.getOutputStream());
        } else if (this.m_tier == 2) {
            super.loadDataFromByteArray(byArray);
        }
        this.setAttribute();
        return true;
    }

    public int getContentLength() throws SQLException {
        int n = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("getContentLength()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n2 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "getContentLength", new String[0], new Object[0]);
                n = n2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (this.m_exception != null) {
                if (this.m_exception instanceof SQLException) {
                    throw (SQLException)this.m_exception;
                }
                throw new JboException((Throwable)this.m_exception);
            }
        } else if (this.m_tier == 2) {
            try {
                this.m_exception = null;
                n = super.getContentLength();
            }
            catch (SQLException sQLException) {
                this.m_exception = sQLException;
                Diagnostic.println((String)("MT getContentLength exception:" + sQLException.getMessage()));
            }
            if (this.m_exception != null) {
                throw new ExpectedSQLException((SQLException)this.m_exception);
            }
        }
        return n;
    }

    public int getContentLength(byte[][] byArray) throws SQLException {
        int n = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("getContentLength()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n2 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "getContentLength", new String[]{byArray.getClass().getName()}, new Object[]{byArray});
                n = n2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            n = super.getContentLength(byArray);
        }
        return n;
    }

    public void setMimeType(String string) throws SQLException {
        this.domainToBeModified();
        super.setMimeType(string);
        this.setAttribute();
    }

    public String getMimeType() throws SQLException {
        if (this.m_contentSource != null) {
            return this.m_contentSource.getMimeType();
        }
        return super.getMimeType();
    }

    public int getWidth() throws SQLException {
        return super.getWidth();
    }

    public void setWidth(int n) throws SQLException {
        this.domainToBeModified();
        super.setWidth(n);
        this.setAttribute();
    }

    public int getHeight() throws SQLException {
        return super.getHeight();
    }

    public void setHeight(int n) throws SQLException {
        this.domainToBeModified();
        super.setHeight(n);
        this.setAttribute();
    }

    public int getFrameResolution() throws SQLException {
        return super.getFrameResolution();
    }

    public void setFrameResolution(int n) throws SQLException {
        this.domainToBeModified();
        super.setFrameResolution(n);
        this.setAttribute();
    }

    public int getFrameRate() throws SQLException {
        return super.getFrameRate();
    }

    public void setFrameRate(int n) throws SQLException {
        this.domainToBeModified();
        super.setFrameRate(n);
        this.setAttribute();
    }

    public int getNumberOfFrames() throws SQLException {
        return super.getNumberOfFrames();
    }

    public void setNumberOfFrames(int n) throws SQLException {
        this.domainToBeModified();
        super.setNumberOfFrames(n);
        this.setAttribute();
    }

    public int getNumberOfColors() throws SQLException {
        return super.getNumberOfColors();
    }

    public void setNumberOfColors(int n) throws SQLException {
        this.domainToBeModified();
        super.setNumberOfColors(n);
        this.setAttribute();
    }

    public int getBitRate() throws SQLException {
        return super.getBitRate();
    }

    public void setBitRate(int n) throws SQLException {
        this.domainToBeModified();
        super.setBitRate(n);
        this.setAttribute();
    }

    public void setSource(String string, String string2, String string3) throws SQLException {
        this.domainToBeModified();
        super.setSource(string, string2, string3);
        this.setAttribute();
    }

    public String getSourceType() throws SQLException {
        return super.getSourceType();
    }

    public String getSourceLocation() throws SQLException {
        return super.getSourceLocation();
    }

    public String getSourceName() throws SQLException {
        return super.getSourceName();
    }

    public String getSource() throws SQLException {
        String string = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                string = (String)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "getSource", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            string = super.getSource();
        }
        return string;
    }

    public String getDescription() throws SQLException {
        return super.getDescription();
    }

    public void setDescription(String string) throws SQLException {
        this.domainToBeModified();
        super.setDescription(string);
        this.setAttribute();
    }

    public CLOB getComments() throws SQLException {
        return super.getComments();
    }

    public void setComments(CLOB cLOB) throws SQLException {
        this.domainToBeModified();
        super.setComments(cLOB);
        this.setAttribute();
    }

    public String getCompressionType() throws SQLException {
        return super.getCompressionType();
    }

    public void setCompressionType(String string) throws SQLException {
        this.domainToBeModified();
        super.setCompressionType(string);
        this.setAttribute();
    }

    public int getVideoDuration() throws SQLException {
        return super.getVideoDuration();
    }

    public void setVideoDuration(int n) throws SQLException {
        this.domainToBeModified();
        super.setVideoDuration(n);
        this.setAttribute();
    }

    public String getFormat() throws SQLException {
        return super.getFormat();
    }

    public void setFormat(String string) throws SQLException {
        this.domainToBeModified();
        super.setFormat(string);
        this.setAttribute();
    }

    public boolean checkProperties(byte[][] byArray) throws SQLException {
        boolean bl = false;
        if (!this.m_connected) {
            throw new NotConnectedException("checkProperties()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Boolean bl2 = (Boolean)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "checkProperties", new String[]{byArray.getClass().getName()}, new Object[]{byArray});
                bl = bl2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            bl = super.checkProperties(byArray);
        }
        return bl;
    }

    public void setProperties() throws SQLException {
        byte[][] byArray = new byte[1][64];
        this.setProperties(byArray, false);
    }

    public void setProperties(byte[][] byArray) throws SQLException {
        this.setProperties(byArray, false);
    }

    public void setProperties(byte[][] byArray, boolean bl) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("setProperties()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            this.m_exception = null;
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setProperties", new String[]{byArray.getClass().getName(), "boolean"}, new Object[]{byArray, new Boolean(bl)});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (this.m_exception != null) {
                if (this.m_exception instanceof SQLException) {
                    throw (SQLException)this.m_exception;
                }
                throw new JboException((Throwable)this.m_exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            try {
                this.m_exception = null;
                super.setProperties(byArray, bl);
            }
            catch (SQLException sQLException) {
                this.m_exception = sQLException;
                Diagnostic.println((String)("MT setproperties exception:" + sQLException.getMessage()));
            }
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
            if (this.m_exception != null) {
                throw new ExpectedSQLException((SQLException)this.m_exception);
            }
        }
    }

    public void setContentLength(int n) throws SQLException {
    }

    public int trimSource(byte[][] byArray, int n) throws SQLException {
        int n2 = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("trimSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n3 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "trimSource", new String[]{byArray.getClass().getName(), "int"}, new Object[]{byArray, new Integer(n)});
                n2 = n3;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            n2 = super.trimSource(byArray, n);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return n2;
    }

    public int openSource(byte[] byArray, byte[][] byArray2) throws SQLException {
        int n = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("openSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n2 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "openSource", new String[]{byArray.getClass().getName(), byArray2.getClass().getName()}, new Object[]{byArray, byArray2});
                n = n2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            n = super.openSource(byArray, byArray2);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return n;
    }

    public int closeSource(byte[][] byArray) throws SQLException {
        int n = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("closeSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n2 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "closeSource", new String[]{byArray.getClass().getName()}, new Object[]{byArray});
                n = n2;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            n = super.closeSource(byArray);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return n;
    }

    public byte[] processSourceCommand(byte[][] byArray, String string, String string2, byte[][] byArray2) throws SQLException {
        byte[] byArray3 = null;
        if (!this.m_connected) {
            throw new NotConnectedException("processSourceCommand()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                byArray3 = (byte[])method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "processSourceCommand", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", byArray2.getClass().getName()}, new Object[]{byArray, string, string2, byArray2});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            byArray3 = super.processSourceCommand(byArray, string, string2, byArray2);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return byArray3;
    }

    public byte[] processVideoCommand(byte[][] byArray, String string, String string2, byte[][] byArray2) throws SQLException {
        byte[] byArray3 = null;
        if (!this.m_connected) {
            throw new NotConnectedException("processVideoCommand()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                byArray3 = (byte[])method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "processVideoCommand", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", byArray2.getClass().getName()}, new Object[]{byArray, string, string2, byArray2});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            byArray3 = super.processVideoCommand(byArray, string, string2, byArray2);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return byArray3;
    }

    public void setUpdateTime(Timestamp timestamp) throws SQLException {
        if (!this.m_connected) {
            this.set_Source(this.get_Source());
            OrdSource ordSource = this.get_Source();
            if (timestamp == null) {
                timestamp = new Timestamp(System.currentTimeMillis());
            }
            ordSource.setUpdatetime(timestamp);
            return;
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setUpdateTime", new String[]{"java.sql.Timestamp"}, new Object[]{timestamp});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.setUpdateTime(timestamp);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public Timestamp getUpdateTime() throws SQLException {
        return super.getUpdateTime();
    }

    public String getAttribute(byte[][] byArray, String string) throws SQLException {
        String string2 = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getAttribute()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                string2 = (String)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.FALSE, "getAttribute", new String[]{byArray.getClass().getName(), "java.lang.String"}, new Object[]{byArray, string});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            string2 = super.getAttribute(byArray, string);
        }
        return string2;
    }

    public CLOB getAllAttributes(byte[][] byArray) throws SQLException {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdVideoDomain.getAllAttributes()", "Client Tier");
        }
        return super.getAllAttributes(byArray);
    }

    public BLOB getContentInLob(byte[][] byArray, String[] stringArray, String[] stringArray2) throws SQLException {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdVideoDomain.getContentInLob()", "Client Tier");
        }
        return super.getContentInLob(byArray, stringArray, stringArray2);
    }

    public void setKnownAttributes(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2, int n7, int n8) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("setKnowAttributes()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "setKnownAttributes", new String[]{"java.lang.String", "int", "int", "int", "int", "int", "int", "java.lang.String", "int", "int"}, new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), string2, new Integer(n7), new Integer(n8)});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.setKnownAttributes(string, n, n2, n3, n4, n5, n6, string2, n7, n8);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public int readFromSource(byte[][] byArray, int n, int n2, byte[][] byArray2) throws SQLException {
        int n3 = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("readFromSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n4 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "readFromSource", new String[]{byArray.getClass().getName(), "int", "int", byArray2.getClass().getName()}, new Object[]{byArray, new Integer(n), new Integer(n2), byArray2});
                n3 = n4;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            n3 = super.readFromSource(byArray, n, n2, byArray2);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return n3;
    }

    public int writeToSource(byte[][] byArray, int n, int n2, byte[] byArray2) throws SQLException {
        int n3 = 0;
        if (!this.m_connected) {
            throw new NotConnectedException("writeToSource()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                Integer n4 = (Integer)method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "writeToSource", new String[]{byArray.getClass().getName(), "int", "int", byArray2.getClass().getName()}, new Object[]{byArray, new Integer(n), new Integer(n2), byArray2});
                n3 = n4;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            n3 = super.writeToSource(byArray, n, n2, byArray2);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
        return n3;
    }

    public void export(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("export()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "export", new String[]{byArray.getClass().getName(), "java.lang.String", "java.lang.String", "java.lang.String"}, new Object[]{byArray, string, string2, string3});
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.domainToBeModified();
            super.export(byArray, string, string2, string3);
            this.adjustLobDomainsAfterInvoker();
            this.setAttribute();
        }
    }

    public boolean getDataInFile(String string) throws SQLException, IOException {
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInFile()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            OrdDomainUtil.getDataInFile(string, this.getContentAsBlobDomain());
        } else if (this.m_tier == 2) {
            return super.getDataInFile(string);
        }
        return true;
    }

    public InputStream getDataInStream() throws SQLException {
        InputStream inputStream = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInStream()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            inputStream = this.getContentAsBlobDomain().getInputStream();
        } else if (this.m_tier == 2) {
            inputStream = super.getDataInStream();
        }
        return inputStream;
    }

    public byte[] getDataInByteArray() throws SQLException, IOException, OutOfMemoryError {
        byte[] byArray = null;
        if (!this.m_connected) {
            throw new NotConnectedException("getDataInByteArray()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            byArray = this.getContentAsBlobDomain().toByteArray();
        } else if (this.m_tier == 2) {
            byArray = super.getDataInByteArray();
        }
        return byArray;
    }

    public BlobDomain getContentAsBlobDomain() throws SQLException {
        this.initBlobDomain();
        return this.m_blobDomain;
    }

    public BFileDomain getBFileDomain() throws SQLException {
        if (!this.m_connected) {
            throw new NotConnectedException("getBFileDomain()", "OrdVideoDomain");
        }
        if (this.m_tier == 1) {
            Method method = OrdDomainUtil.getInvokeDomainMethod();
            try {
                method.invoke((Object)this.m_transaction, this.getOwnerRow(), this.getRemoteIdString(), Boolean.TRUE, "getBFileDomain", new String[0], new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    SQLException sQLException = OrdDomainUtil.unwrapSQLException(invocationTargetException);
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    throw new JboException((Throwable)invocationTargetException);
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)invocationTargetException);
                }
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else if (this.m_tier == 2) {
            this.m_bfileDomain = new BFileDomain(this.getBFILE());
            this.adjustLobDomainsAfterInvoker();
        }
        return this.m_bfileDomain;
    }

    public ClobDomain getCommentsAsClobDomain() throws SQLException {
        this.initClobDomain();
        return this.m_clobDomain;
    }

    public void setContentSource(OrdContentSource ordContentSource) {
        this.domainToBeModified();
        if (this.m_contentSource != null) {
            this.m_contentSource.release();
        }
        this.m_contentSource = ordContentSource;
        if (ordContentSource != null) {
            this.addPostListener();
        } else {
            if (this.m_tier == 1 && this.m_lastPostListener != null) {
                OrdDomainUtil.removeOrdPostListener(this.m_transaction, this.m_lastPostListener);
            }
            this.m_lastPostListener = null;
        }
        if (this.m_tier == 1) {
            this.generateTempFilePath();
        }
        this.setAttribute();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    public OrdContentSource getContentSource() {
        return this.m_contentSource;
    }

    private void addPostListener() {
        if (this.m_tier == 1 && this.m_lastPostListener == null) {
            Object object;
            this.m_lastPostListener = object = OrdDomainUtil.getOrdPostListener(this.m_transaction, this);
            OrdDomainUtil.addOrdPostListener(this.m_transaction, object);
        }
    }

    public CustomDatum create(Datum datum, int n) throws SQLException {
        if (datum == null) {
            return null;
        }
        OrdVideoDomain ordVideoDomain = new OrdVideoDomain();
        ordVideoDomain._struct = new MutableStruct((STRUCT)datum, OrdVideoBase._sqlType, OrdVideoBase._factory);
        ordVideoDomain._ctx = new OrdVideoBase._Ctx(((STRUCT)datum).getJavaSqlConnection());
        ordVideoDomain.conn = (OracleConnection)ordVideoDomain._ctx.getConnection();
        ordVideoDomain.initBlobDomain();
        ordVideoDomain.initClobDomain();
        ordVideoDomain.initBFileDomain();
        ordVideoDomain.m_tier = 2;
        if (ordVideoDomain.conn != null) {
            ordVideoDomain.m_connected = true;
        }
        return ordVideoDomain;
    }

    public static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return OrdDomainUtil.getXMLDomainFactory(clazz);
    }

    public Node getXMLContentNode(Document document) {
        return OrdDomainUtil.getXMLContentNode(document, this, this.getXMLElementTag());
    }

    public Object createDomainFromSerializedXML(Element element) {
        OrdVideoDomain ordVideoDomain = new OrdVideoDomain();
        return OrdDomainUtil.createDomainFromXMLElement(element, ordVideoDomain);
    }

    public Node getSerializedDomainXML(Document document) {
        return OrdDomainUtil.getXMLContentNode(document, this, this.getXMLElementTag());
    }

    protected String getXMLElementTag() {
        return "OrdVideoDomain";
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        String string = this.getXMLElementTag();
        return OrdDomainUtil.printXMLDefinition(hashtable, printWriter, bl, string);
    }

    public void domainToBeModified(DomainInterface domainInterface) {
        this.domainToBeModified();
    }

    public Object getAttribute(int n) {
        switch (n) {
            case 0: {
                return this.m_blobDomain;
            }
            case 1: {
                return this.m_clobDomain;
            }
            case 2: {
                return this.m_bfileDomain;
            }
        }
        return null;
    }

    public Object getAttribute(String string) {
        throw new MethodNotImplementedException("getAttribute(String)", "OrdVideoDomain");
    }

    public void setAttribute(int n, Object object) {
        throw new MethodNotImplementedException("setAttribute(int, Object)", "OrdVideoDomain");
    }

    public void setAttribute(String string, Object object) {
        throw new MethodNotImplementedException("setAttribute(String, Object)", "OrdVideoDomain");
    }

    public int getAttributeCount() {
        throw new MethodNotImplementedException("getAttributeCount()", "OrdVideoDomain");
    }

    public int getAttributeIndexOf(String string) {
        throw new MethodNotImplementedException("getAttributeIndexOf(String)", "OrdVideoDomain");
    }

    public String[] getAttributeNames() {
        throw new MethodNotImplementedException("getAttributeNames()", "OrdVideoDomain");
    }

    public Object[] getAttributeValues() {
        throw new MethodNotImplementedException("getAttributeValues()", "OrdVideoDomain");
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            try {
                if (this.m_transaction != null) {
                    OrdVideoDomain ordVideoDomain = (OrdVideoDomain)lobInterface;
                    this.copyObject(ordVideoDomain);
                    this.m_connected = true;
                    this.m_ownerNotModified = true;
                    this.m_blobDomain.syncServerLob((LobInterface)ordVideoDomain.m_blobDomain);
                    this.m_clobDomain.syncServerLob((LobInterface)ordVideoDomain.m_clobDomain);
                    this.m_bfileDomain = new BFileDomain();
                    return;
                }
                OrdVideoDomain ordVideoDomain = (OrdVideoDomain)lobInterface;
                if (this.m_connected && (this.m_reuseLobs || !this.m_reuseLobs && this.m_blobDomain.isCacheDataModified())) {
                    this.setContent(ordVideoDomain.getContent());
                    this.m_blobDomain.syncServerLob((LobInterface)ordVideoDomain.m_blobDomain);
                    this.setComments(ordVideoDomain.getComments());
                    this.m_clobDomain.syncServerLob((LobInterface)ordVideoDomain.m_clobDomain);
                    this.m_bfileDomain.syncServerLob((LobInterface)ordVideoDomain.m_bfileDomain);
                }
                this.m_owner = ordVideoDomain.m_owner;
                this.conn = ordVideoDomain.conn;
                this._ctx = ordVideoDomain._ctx;
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public void syncClientLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            OrdVideoDomain ordVideoDomain = (OrdVideoDomain)lobInterface;
            try {
                this.syncWithArrivingOne(ordVideoDomain);
                if (ordVideoDomain.m_blobDomain != null) {
                    this.initBlobDomain();
                    this.m_blobDomain.syncClientLob((LobInterface)ordVideoDomain.m_blobDomain);
                } else {
                    this.m_blobDomain = null;
                }
                if (ordVideoDomain.m_clobDomain != null) {
                    this.initClobDomain();
                    this.m_clobDomain.syncClientLob((LobInterface)ordVideoDomain.m_clobDomain);
                } else {
                    this.m_clobDomain = null;
                }
                if (ordVideoDomain.m_bfileDomain == null) {
                    this.m_bfileDomain = null;
                }
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public long getSize() {
        int n = 0;
        if (this.m_contentSource != null) {
            try {
                n = this.m_contentSource.getContentLength();
            }
            catch (IOException iOException) {
                throw new JboException((Throwable)iOException);
            }
            return n;
        }
        try {
            this.initBlobDomain();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
        return this.m_blobDomain.getSize();
    }

    public String getRemoteIdString() {
        if (this.m_indexString == null) {
            this.m_indexString = OrdDomainUtil.getRemoteIdString(this);
        }
        return this.m_indexString;
    }

    public void saveToDatabase(Transaction transaction) throws SQLException {
    }

    public void saveToDatabase(Transaction transaction, Object object) throws SQLException, IOException {
        byte[] byArray;
        if (this.m_blobDomain.isCacheDataModified() && (byArray = this.m_blobDomain.toByteArray()).length > 0) {
            this.setContentSource(new OrdByteArraySource(byArray));
        }
        if (this.m_contentSource != null) {
            OrdVideoDomain ordVideoDomain = (OrdVideoDomain)object;
            this.copyObject(ordVideoDomain);
            this.m_owner = ordVideoDomain.m_owner;
            this.m_ownerAttrIndex = ordVideoDomain.m_ownerAttrIndex;
            this.m_connected = true;
            this.m_tier = 2;
            this.initBlobDomain();
            OrdDomainUtil.loadAndSetProperties(this);
            ((AttributeList)this.m_owner).setAttribute(this.m_ownerAttrIndex, (Object)this);
            this.m_ownerNotModified = true;
            this.initClobDomain();
            OrdDomainUtil.updateRow(this.m_owner);
        }
    }

    public void prepareForDML(Object object) {
        if (this.m_contentSource != null || this.isBlobNull()) {
            try {
                BLOB bLOB = BlobDomain.createEmptyBLOB((Object)object);
                this.setContent(bLOB);
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public void loadFromDatabase(Transaction transaction) throws Exception {
        if (this.m_tier != 2) {
            throw new WrongTierException("OrdVideoDomain.loadFromDatabase()", "Client Tier");
        }
    }

    public DomainOwnerInterface getOwner() {
        return this.m_owner;
    }

    public int getOwnerAttributeIndex() {
        return this.m_ownerAttrIndex;
    }

    public Object getData() {
        return this;
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        this.m_owner = domainOwnerInterface;
        HashMap hashMap = (HashMap)object;
        Integer n = (Integer)hashMap.get((Object)"0");
        this.m_ownerAttrIndex = n != null ? n : this.m_ownerAttrIndex;
        this.m_tier = 2;
        if (hashMap.get((Object)"3") != null) {
            this.m_tier = 1;
        }
        if (transaction instanceof ApplicationModule) {
            this.m_tier = 1;
        }
        this.m_transaction = transaction;
        HashMap hashMap2 = (HashMap)((HashMap)object).clone();
        hashMap2.put((Object)"0", (Object)new Integer(0));
        this.m_blobDomain.setContext((DomainOwnerInterface)this, transaction, (Object)hashMap2);
        hashMap2.put((Object)"0", (Object)new Integer(1));
        this.m_clobDomain.setContext((DomainOwnerInterface)this, transaction, (Object)hashMap2);
        hashMap2.put((Object)"0", (Object)new Integer(2));
        this.m_bfileDomain.setContext((DomainOwnerInterface)this, transaction, (Object)hashMap2);
        this.processCTActivation();
        this.adjustDeferredLoadingSource();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    private void processCTActivation() {
        if (this.m_tier == 1 && this.m_ctTempFilePath != null && this.m_contentSource == null) {
            OrdFileSource ordFileSource = new OrdFileSource(this.m_ctTempFilePath);
            ordFileSource.deleteFileInRelease();
            this.m_contentSource = ordFileSource;
            this.m_ctTempFilePath = null;
            try {
                if (this.getMimeType() != null) {
                    ordFileSource.setMimeType(this.getMimeType());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void adjustDeferredLoadingSource() {
        if (this.m_tier == 1 && this.m_owner != null && this.m_lastPostListener == null && this.getContentSource() != null && !this.m_forClientPostNewDomain) {
            this.addPostListener();
            this.generateTempFilePath();
        }
    }

    public ResponseValues marshal() {
        return TypeMarshaller.serializeObject((Serializable)this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeInt(this.m_ownerAttrIndex);
            objectOutputStream.writeBoolean(this.m_ownerNotModified);
            objectOutputStream.writeBoolean(this.m_connected);
            objectOutputStream.writeObject(this.m_bfileDomain);
            if (this.m_tier == 2) {
                this.m_reuseLobs = true;
            }
            objectOutputStream.writeBoolean(this.m_reuseLobs);
            objectOutputStream.writeObject(this.m_blobDomain);
            objectOutputStream.writeObject(this.m_clobDomain);
            objectOutputStream.writeObject(this.getDescription());
            objectOutputStream.writeObject(this.getFormat());
            objectOutputStream.writeObject(this.getMimeType());
            objectOutputStream.writeObject(this.get_Width());
            objectOutputStream.writeObject(this.get_Height());
            objectOutputStream.writeObject(this.get_FrameResolution());
            objectOutputStream.writeObject(this.get_FrameRate());
            objectOutputStream.writeObject(this.get_VideoDuration());
            objectOutputStream.writeObject(this.get_NumberOfFrames());
            objectOutputStream.writeObject(this.getCompressionType());
            objectOutputStream.writeObject(this.get_NumberOfColors());
            objectOutputStream.writeObject(this.get_BitRate());
            objectOutputStream.writeObject(this.getSourceType());
            objectOutputStream.writeObject(this.getSourceLocation());
            objectOutputStream.writeObject(this.getSourceName());
            objectOutputStream.writeObject(this.getUpdateTime());
            if (this.isLocal()) {
                objectOutputStream.writeBoolean(true);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            if (this.m_exception != null) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.m_exception);
            } else {
                objectOutputStream.writeBoolean(false);
            }
            objectOutputStream.writeObject(this.m_ctTempFilePath);
            objectOutputStream.writeInt(this.m_objId);
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.setSourceObject(new OrdSource());
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
        try {
            this.m_ownerAttrIndex = objectInputStream.readInt();
            this.m_ownerNotModified = objectInputStream.readBoolean();
            this.m_connected = objectInputStream.readBoolean();
            this.m_bfileDomain = (BFileDomain)objectInputStream.readObject();
            this.m_reuseLobs = objectInputStream.readBoolean();
            this.m_blobDomain = (BlobDomain)objectInputStream.readObject();
            this.m_clobDomain = (ClobDomain)objectInputStream.readObject();
            super.setDescription((String)objectInputStream.readObject());
            super.setFormat((String)objectInputStream.readObject());
            super.setMimeType((String)objectInputStream.readObject());
            super.set_Width((Integer)objectInputStream.readObject());
            super.set_Height((Integer)objectInputStream.readObject());
            super.set_FrameResolution((Integer)objectInputStream.readObject());
            super.set_FrameRate((Integer)objectInputStream.readObject());
            super.set_VideoDuration((Integer)objectInputStream.readObject());
            super.set_NumberOfFrames((Integer)objectInputStream.readObject());
            super.setCompressionType((String)objectInputStream.readObject());
            super.set_NumberOfColors((Integer)objectInputStream.readObject());
            super.set_BitRate((Integer)objectInputStream.readObject());
            String string = (String)objectInputStream.readObject();
            String string2 = (String)objectInputStream.readObject();
            String string3 = (String)objectInputStream.readObject();
            super.setSource(string, string2, string3);
            Timestamp timestamp = (Timestamp)objectInputStream.readObject();
            this.setLocalUpdateTime(timestamp);
            if (objectInputStream.readBoolean()) {
                super.setLocal();
            } else {
                super.clearLocal();
            }
            boolean bl = objectInputStream.readBoolean();
            if (bl) {
                this.m_exception = (Exception)objectInputStream.readObject();
            }
            this.m_ctTempFilePath = (String)objectInputStream.readObject();
            this.m_objId = objectInputStream.readInt();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    private void domainToBeModified() {
        if (this.m_owner != null && this.m_ownerNotModified) {
            this.m_owner.domainToBeModified((DomainInterface)this);
            this.m_ownerNotModified = false;
        }
    }

    private void setAttribute() {
        if (this.m_owner != null) {
            ((AttributeList)this.m_owner).setAttribute(this.m_ownerAttrIndex, (Object)this);
        }
    }

    private void adjustLobDomainsAfterInvoker() throws SQLException {
        this.initBlobDomain();
        this.initClobDomain();
    }

    private DomainOwnerInterface getOwnerRow() {
        return OrdDomainUtil.getOwnerRow(this);
    }

    private void initBlobDomain() throws SQLException {
        BLOB bLOB;
        if (this.m_blobDomain == null) {
            this.m_blobDomain = new BlobDomain();
        }
        if ((bLOB = this.getContent()) != null && !bLOB.isEmptyLob()) {
            this.m_blobDomain.useBLOB(bLOB);
        }
    }

    private void initBFileDomain() throws SQLException {
        if (this.m_bfileDomain == null) {
            this.m_bfileDomain = new BFileDomain();
        }
    }

    private void initClobDomain() throws SQLException {
        CLOB cLOB;
        if (this.m_clobDomain == null) {
            this.m_clobDomain = new ClobDomain();
        }
        if ((cLOB = this.getComments()) != null && !cLOB.isEmptyLob()) {
            this.m_clobDomain.useCLOB(cLOB);
        }
    }

    private boolean isBlobNull() {
        boolean bl = false;
        try {
            bl = this.getContentReadOnly() == null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private void setLocalUpdateTime(Timestamp timestamp) throws SQLException {
        this.set_Source(this.get_Source());
        OrdSource ordSource = this.get_Source();
        ordSource.setUpdatetime(timestamp);
    }

    private void syncWithArrivingOne(OrdVideoDomain ordVideoDomain) throws SQLException {
        this.m_ownerNotModified = ordVideoDomain.m_ownerNotModified;
        this.m_connected = ordVideoDomain.m_connected;
        this.m_reuseLobs = ordVideoDomain.m_reuseLobs;
        this.m_exception = ordVideoDomain.m_exception;
        BLOB bLOB = this.getContentReadOnly();
        CLOB cLOB = this.getComments();
        this.copyObject(ordVideoDomain);
        super.setContent(bLOB);
        super.setComments(cLOB);
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public int getTierInfo() {
        return this.m_tier;
    }

    public void setConnected(boolean bl) {
        this.m_connected = bl;
    }

    public void removeListenerFromTransaction() {
        if (this.m_transaction != null) {
            this.m_transaction.removeTransactionStateListener((TransactionStateListener)this);
            this.setAddToTransactionState(false);
        }
    }

    public boolean isAddedToTransaction() {
        return this.m_isAddedToTransaction;
    }

    public void setAddToTransactionState(boolean bl) {
        this.m_isAddedToTransaction = bl;
    }

    public void doneCommit(TransactionStateEvent transactionStateEvent) {
        OrdDomainUtil.releaseContentSourceResource(this);
        this.removeListenerFromTransaction();
    }

    public void doneRollback(TransactionStateEvent transactionStateEvent) {
        this.m_doneRollback = true;
        this.removeListenerFromTransaction();
        if (this.m_tier == 1 && this.m_lastPostListener != null) {
            OrdDomainUtil.removeOrdPostListener(this.m_transaction, this.m_lastPostListener);
        }
        this.m_lastPostListener = null;
        this.m_doneRollback = false;
    }

    public void setContentSourceOnly(OrdContentSource ordContentSource) {
        this.domainToBeModified();
        this.m_contentSource = ordContentSource;
        this.m_forClientPostNewDomain = true;
        this.setAttribute();
        OrdDomainUtil.bindToTransaction(this, this.m_transaction);
    }

    public void setCTPassivationHandle(Object object) {
        this.m_ctTempFilePath = (String)object;
    }

    public Object getCTPassivationHandle() {
        return this.m_ctTempFilePath;
    }

    public void generateTempFilePath() {
        this.m_contentSource = OrdDomainUtil.prepareTempFile(this);
        this.m_ctTempFilePath = ((OrdFileSource)this.m_contentSource).getFileName();
    }

    public void clearContentSource() {
        this.m_contentSource = null;
    }
}

