
@echo off

set "TCERS_EXEC=-jar padDesktop.jar"
set "TCERS_OPTS=-Xms256m -Xmx512m -Dlog4j.configuration=conf/log4j.properties"

:checkJavaHome
if exist "%JAVA_HOME%\bin\java.exe" goto javaHomeOk
if exist "%JAVA_HOME%\java.exe" goto javaHomeBinOk

:checkWindowsRegistry
echo checkWindowsRegistry
FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "HKLM\Software\JavaSoft\Java Development Kit" /v CurrentVersion') DO set "JAVA_CUR_VER=%%B"
:: ECHO %JAVA_CUR_VER%"
FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "HKLM\Software\JavaSoft\Java Development Kit\%JAVA_CUR_VER%" /v JavaHome') DO set "JAVA_HOME=%%B"
:: ECHO %JAVA_HOME%"
if exist "%JAVA_HOME%\bin\java.exe" goto javaHomeOk
if exist "%JAVA_HOME%\java.exe" goto javaHomeBinOk

:checkWindowsRegistryJRE
echo checkWindowsRegistryJRE
FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "HKLM\Software\JavaSoft\Java Runtime Environment" /v CurrentVersion') DO set "JAVA_CUR_VER=%%B"
:: ECHO %JAVA_CUR_VER%"
FOR /F "skip=2 tokens=2*" %%A IN ('REG QUERY "HKLM\Software\JavaSoft\Java Runtime Environment\%JAVA_CUR_VER%" /v JavaHome') DO set "JAVA_HOME=%%B"
:: ECHO %JAVA_HOME%"
if exist "%JAVA_HOME%\bin\java.exe" goto javaHomeOk
if exist "%JAVA_HOME%\java.exe" goto javaHomeBinOk

:: current user... HKCU ??

:checkJavaExe
echo checkJavaExe
where /q java.exe
::echo ERRORLEVEL-where==%ERRORLEVEL%
if ERRORLEVEL 9009 goto javaTryAnyway
if ERRORLEVEL 1 goto findJava
goto javaOk

:javaOk
echo javaOk
goto javaExecRun

:javaTryAnyway
echo javaTryAnyway

:javaExecRun
java %TCERS_OPTS% %TCERS_EXEC%
::echo ERRORLEVEL-java==%ERRORLEVEL%
if ERRORLEVEL 9009 goto findJava
goto end

:findJava
echo findJava
if exist "%ProgramFiles%\Java\jre8\bin\java.exe" goto javaJre8Ok
if exist "%ProgramFiles%\Java\jre7\bin\java.exe" goto javaJre7Ok
if exist "%ProgramFiles%\Java\jre6\bin\java.exe" goto javaJre6Ok
if exist "%ProgramFiles(x86)%\Java\jre8\bin\java.exe" goto javaJre8x86Ok
if exist "%ProgramFiles(x86)%\Java\jre7\bin\java.exe" goto javaJre7x86Ok
if exist "%ProgramFiles(x86)%\Java\jre6\bin\java.exe" goto javaJre6x86Ok
goto erro

:javaHomeBinOk
echo JAVA_HOME_BIN_OK: %JAVA_HOME%
set "JAVA_DIR=%JAVA_HOME%"
goto exec

:javaHomeOk
echo JAVA_HOME_OK: %JAVA_HOME%
set "JAVA_DIR=%JAVA_HOME%\bin"
goto exec

:javaJre8Ok
echo JRE8_OK
set "JAVA_DIR=%ProgramFiles%\Java\jre8\bin"
goto exec

:javaJre7Ok
echo JRE7_OK
set "JAVA_DIR=%ProgramFiles%\Java\jre7\bin"
goto exec

:javaJre6Ok
echo JRE6_OK
set "JAVA_DIR=%ProgramFiles%\Java\jre6\bin"
goto exec

:javaJre8x86Ok
echo JRE8x86_OK
set "JAVA_DIR=%ProgramFiles(x86)%\Java\jre8\bin"
goto exec

:javaJre7x86Ok
echo JRE7x86_OK
set "JAVA_DIR=%ProgramFiles(x86)%\Java\jre7\bin"
goto exec

:javaJre6x86Ok
echo JRE6x86_OK
set "JAVA_DIR=%ProgramFiles(x86)%\Java\jre6\bin"
goto exec

:exec
"%JAVA_DIR%\java.exe" %TCERS_OPTS% %TCERS_EXEC%
if ERRORLEVEL 1 goto erroexec
goto end

:erro
echo ATENCAO: maquina virtual java (jvm/jre) nao encontrada
pause
goto end

:erroexec
echo ATENCAO: erro ao executar programa (dir = %JAVA_DIR%)
pause
goto end

:end
