<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java" extension-element-prefixes="barcode"
	xmlns:cal="xalan://java.util.GregorianCalendar"
	xmlns:exslt="http://exslt.org/common">

	<xsl:output method="xml" encoding="ISO-8859-1" indent="yes" />

	<xsl:decimal-format decimal-separator="," grouping-separator="." />

	<!-- Variveis de ambiente de execuo -->
	<xsl:param name="PATH_IMAGENS" select="'imagens/'" />
	<xsl:param name="PATH_REMESSA" select="'remessa/'" />

	<xsl:variable name="pageWidthInternal" select="'540pt'" />

	<!-- ######### Styles para os textos do documento ######### -->
	<xsl:attribute-set name="bordas">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>

		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<!-- xsl:attribute name="border-top-width">1pt</xsl:attribute> <xsl:attribute 
			name="border-top-style">solid</xsl:attribute> <xsl:attribute name="border-bottom-width">1pt</xsl:attribute> 
			<xsl:attribute name="border-bottom-style">solid</xsl:attribute -->
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasLR">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasL">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasR">
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasB">
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasTB">
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasTBR">
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasAll">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="bordasTableHeader">
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set-->

	<!-- xsl:attribute-set name="bordas2">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordas3">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasUltColuna">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="bordasDireita1pt">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">1pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeftCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRightCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeft">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRight">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titFCinza">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titFCinzaEscuro">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegrito">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titNegritoLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titNegritoRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoBig">
		<xsl:attribute name="font-size">16.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoItalico">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="total">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="totalLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalho">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<!-- <xsl:attribute name="space-after">1mm</xsl:attribute> -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBold">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtLeftShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftShort2">
		<xsl:attribute name="font-size">7.2pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtLeftBig">
		<xsl:attribute name="font-size">11.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtLeftBigCur">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtCenterBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtRightShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRightBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="linhaTotal">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtQuadroTce">
		<xsl:attribute name="font-size">7.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titTabelaHeader">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="padding-top">4pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- xsl:attribute name="background-color">#EEEEEE</xsl:attribute-->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderLeft">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="padding-top">4pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderRight">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding-top">4pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderN2">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<!-- <xsl:attribute name="padding-bottom">2pt</xsl:attribute> -->
		<!-- <xsl:attribute name="vertical-align">middle</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderN2Left">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<!-- <xsl:attribute name="padding-bottom">2pt</xsl:attribute> -->
		<!-- <xsl:attribute name="vertical-align">middle</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderN2Right">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<!-- <xsl:attribute name="padding-bottom">2pt</xsl:attribute> -->
		<!-- <xsl:attribute name="vertical-align">middle</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<!-- ******* Define a configurao da pgina (Folha) ******* -->
				<fo:simple-page-master master-name="default-master"
					page-height="29.6cm" page-width="21cm" margin-top="15pt"
					margin-left="20pt" margin-right="35pt" margin-bottom="15pt">

					<!-- ******* Parte central da pgina (Margens) ******* -->
					<fo:region-body column-count="1" margin-top="1.30in"
						margin-bottom="0.5in" />

					<!-- ******* Cabealho (Margens) ******* -->
					<fo:region-before border-after-style="solid"
						extent="1.30in" margin-bottom="0.2in" />

					<!-- ******* Rodap (Margens) ******* -->
					<fo:region-after border-before-style="solid"
						extent="0.2in" margin-bottom="0.2in" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<!-- Body page -->
			<!-- ******* Corpo da pgina (Contedo) ******* -->
			<fo:page-sequence master-reference="default-master">

				<!-- ******* Definindo o contedo do cabealho ******* -->
				<fo:static-content flow-name="xsl-region-before">
					<xsl:apply-templates select="dc-dvp/Cabecalho" />
				</fo:static-content>

				<!-- ******* Definindo o contedo do rodap ******* -->
				<fo:static-content flow-name="xsl-region-after">

					<!-- ******* Variveis locais ******* -->
					<!-- variveis para obter a data e hora atual -->
					<xsl:variable name="timeZone1"
						select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
					<xsl:variable name="tmp" select="cal:new()" />
					<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />
					<!-- ******* ******* -->

					<fo:table text-align="center" table-layout="fixed">
						<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
						<fo:table-column column-width="115pt" />
						<fo:table-column column-width="126pt" />
						<fo:table-column column-width="115pt" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
									<fo:block />
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtLeft">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="10pt">
									<fo:block xsl:use-attribute-sets="txtCenter">
										P&#225;gina <fo:page-number />
										de <fo:page-number-citation ref-id="last-page" />
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
								<xsl:variable name="tmp" select="cal:new()" />
								<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />

								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtRight">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), cal:getTime())" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<xsl:variable name="temUnidadeNaoRPPS" select="sum(dc-dvp/VariacoesPatrimoniais/VariacoesPatrimoniaisRow/VL_SALDO_PRINCIPAL) > 0" />
				<xsl:variable name="temRPPS" select="sum(dc-dvp/VariacoesPatrimoniais/VariacoesPatrimoniaisRow/VL_SALDO_RPPS) > 0" />

				<!-- ******* Definindo o contedo do corpo da pgina ******* -->
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="7.0pt" font-family="serif">

						<!--xxxxxxxxxxx BLOCO PRINCIPAL xxxxxxxxxxxxx -->
						
						<fo:block xsl:use-attribute-sets="titFCinza" id="DVP_a_0">a. Variaes Patrimoniais</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						<xsl:apply-templates select="dc-dvp/VariacoesPatrimoniais"/>
						
						<xsl:if test="$temUnidadeNaoRPPS and $temRPPS">
							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="DVP_a_1">a.1 Variaes Patrimoniais - 
								<xsl:choose>
									<xsl:when test="dc-dvp/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
										Prefeitura
									</xsl:when>
									<xsl:otherwise>
										Demais Entidades
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-dvp/VariacoesPatrimoniais">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_PRINCIPAL'"/>
							</xsl:apply-templates>
							
							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="DVP_a_2">a.2 Variaes Patrimoniais - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-dvp/VariacoesPatrimoniais">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_RPPS'"/>
							</xsl:apply-templates>
						</xsl:if>
						
						<fo:block break-after="page"/>
						
						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_b_0">b. Notas Explicativas</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						
						<xsl:apply-templates select="dc-dvp/NotasExplicativas"/>
						
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						
						<xsl:apply-templates select="dc-dvp/Assinaturas"/>

						<fo:block id="last-page" />

					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- ########################## #### CABECALHO ########################## -->
	<xsl:template match="Cabecalho">
		<xsl:variable name="periodoFinal">
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 1">
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
			</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
		</xsl:variable>

		<xsl:variable name="tipoRelatorio">
			<xsl:value-of select="CabecalhoRow/TP_RELATORIO" />
		</xsl:variable>

		<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
		<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
		<xsl:variable name="horario" select="substring($dataHora, 12, 8)" />
		<xsl:variable name="dia" select="substring($data, 9, 2)" />
		<xsl:variable name="mes" select="substring($data, 6, 2)" />
		<xsl:variable name="ano" select="substring($data, 1, 4)" />
		<xsl:variable name="hora" select="substring($horario, 1, 2)" />
		<xsl:variable name="minuto" select="substring($horario, 4, 2)" />
		<xsl:variable name="segundo" select="substring($horario, 7, 2)" />

		<fo:block>
			<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
				<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
				<fo:table-column column-width="42pt"/>
				<fo:table-column column-width="442pt"/>
				<fo:table-column column-width="56pt"/>

				<fo:table-body>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block />
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell padding-bottom="3pt">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}" width="50pt" />
							</fo:block>
						</fo:table-cell>

						<fo:table-cell>
							<fo:block padding-bottom="1pt">
								<fo:table table-layout="fixed">
									<fo:table-column column-width="300pt"/>
									<fo:table-column column-width="112pt"/>
									<fo:table-column column-width="0pt"/>

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="15pt" padding-top="1pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="txtCenter">
												ESTADO DO RIO GRANDE DO SUL - TRIBUNAL DE CONTAS DO ESTADO
												</fo:block>
											</fo:table-cell>
										</fo:table-row>

										<fo:table-row>
											<fo:table-cell padding-left="15pt">
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													SIAPC - Sistema de Informa&#231;&#245;es para
													Auditoria e Presta&#231;&#227;o de Contas
												</fo:block>
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													Programa Autenticador de Dados - Vers&#227;o:
													<xsl:value-of select="CabecalhoRow/VERSAO_PAD" />
													<xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
												</fo:block>
											</fo:table-cell>

											<fo:table-cell number-rows-spanned="2" text-align="center">
												<fo:block xsl:use-attribute-sets="txtRight">

													<fo:instream-foreign-object>
														<barcode:barcode xmlns:barcode="http://barcode4j.krysalis.org/ns"
															message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-dc-dvp}">
															<barcode:code128>
																<barcode:height>15mm</barcode:height>
															</barcode:code128>
														</barcode:barcode>
													</fo:instream-foreign-object>

												</fo:block>
											</fo:table-cell>

										</fo:table-row>
										<fo:table-row>
											<fo:table-cell padding-left="60pt" padding-top="5pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="txtLeftBig" font-weight="normal">Demonstrao das Variaes Patrimoniais</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>

						<!-- txtRightShort ? -->
						<fo:table-cell padding-top="5pt" text-align="right">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}"
									width="42pt" />
							</fo:block>
							<fo:block xsl:use-attribute-sets="txtRight">
								<xsl:value-of select="$dia" />
								/
								<xsl:value-of select="$mes" />
								/
								<xsl:value-of select="$ano" />
								-
								<xsl:value-of select="$hora" />
								:
								<xsl:value-of select="$minuto" />
								:
								<xsl:value-of select="$segundo" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block>
								<fo:table text-align="center" table-layout="fixed">
									<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
								
									<fo:table-column column-width="251pt" />
									<fo:table-column column-width="95pt" />
									<fo:table-column column-width="95pt" />
									<fo:table-column column-width="105pt" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="10pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													<xsl:value-of select="CabecalhoRow/NOME" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													ORGO N:
													<xsl:value-of
														select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													CNPJ:
													<xsl:value-of select="CabecalhoRow/CNPJ" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-right="10pt">
												<fo:block xsl:use-attribute-sets="txtRight">
													01/01/<xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
													a
													<xsl:value-of select="$periodoFinal" /><xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- #### FIM - CABE&#199;ALHO #### -->

<!-- #############################################  ############################################# -->


<xsl:template match="VariacoesPatrimoniais">
	<xsl:param name="ELEM_SALDO" select="'VL_SALDO'"/>
	
	<xsl:variable name="vSomaAumentativo">
		<xsl:value-of select="sum(VariacoesPatrimoniaisRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL = 1][../GRUPO_CONTAS_N1 = 4])"/>
	</xsl:variable>
	<xsl:variable name="vSomaDiminutivo">
		<xsl:value-of select="sum(VariacoesPatrimoniaisRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL = 1][../GRUPO_CONTAS_N1 = 3])"/>
	</xsl:variable>
	
	<fo:block>
		<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed" border-collapse="collapse">
			<fo:table-column column-width="356pt" />
			<fo:table-column column-width="184pt" />

			<fo:table-header>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasTBR">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Conta
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasTB">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Valor
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>
			
			<fo:table-body>
				<xsl:for-each select="VariacoesPatrimoniaisRow">
					<fo:table-row>
						<xsl:choose>
							<xsl:when test="NR_NIVEL=1">
								<fo:table-cell xsl:use-attribute-sets="bordasTBR">
									<fo:block xsl:use-attribute-sets="titTabelaHeader">
										<xsl:value-of select="DS_CONTA_BVER"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="bordasTB">
									<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
										<xsl:value-of select="format-number(* [local-name() = $ELEM_SALDO], '#.##0,00')"/>
									</fo:block>
								</fo:table-cell>
							</xsl:when>
							<xsl:when test="NR_NIVEL=2">
								<fo:table-cell xsl:use-attribute-sets="bordasTBR">
									<fo:block xsl:use-attribute-sets="titTabelaHeaderN2Left">
										<xsl:value-of select="DS_CONTA_BVER"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="bordasTB">
									<fo:block xsl:use-attribute-sets="titTabelaHeaderN2Right">
										<xsl:value-of select="format-number(* [local-name() = $ELEM_SALDO], '#.##0,00')"/>
									</fo:block>
								</fo:table-cell>
							</xsl:when>
							<xsl:otherwise>
								<fo:table-cell xsl:use-attribute-sets="bordasTBR">
									<xsl:attribute name="padding-left"><xsl:value-of select="concat( (number(NR_NIVEL)-2 ) * 15,'pt')"/></xsl:attribute>
									<fo:block xsl:use-attribute-sets="txtLeft">
										<xsl:value-of select="DS_CONTA_BVER"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="bordasTB">
									<!-- <xsl:attribute name="padding-right"><xsl:value-of select="concat( (number(NR_NIVEL)-2 ) * 15,'pt')"/></xsl:attribute> -->
									<fo:block xsl:use-attribute-sets="txtRight">
										<xsl:value-of select="format-number(* [local-name() = $ELEM_SALDO], '#.##0,00')"/>
									</fo:block>
								</fo:table-cell>
							</xsl:otherwise>
						</xsl:choose>
					</fo:table-row>
				</xsl:for-each>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasTBR">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							RESULTADO PATRIMONIAL DO PERODO
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasTB">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:value-of select="format-number($vSomaAumentativo - $vSomaDiminutivo, '#.##0,00')"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>


<!-- #############################################  ############################################# -->


<!-- xmlgraphics.apache.org/fop/fo.html#fo-preformat -->
<xsl:template match="NotasExplicativas">

	<xsl:choose>
	<xsl:when test="NotasExplicativasRow/TEXTO != ''">
	<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasAll">
		<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
	
		<fo:table-column column-number="1" />
		<fo:table-body>
			<xsl:for-each select="NotasExplicativasRow">
				<fo:table-row>
					<fo:table-cell border-width="0.5pt" padding-left="5pt">
						<fo:block xsl:use-attribute-sets="txtLeft" white-space-collapse="false">
							<xsl:value-of select="TEXTO" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
		</fo:table-body>
	</fo:table>
	</xsl:when>
	</xsl:choose>
</xsl:template>


<!-- #############################################  ############################################# -->


<xsl:template match="Assinaturas">
	<!-- ************* Variaveis locais ************** -->
	<xsl:variable name="administrador">
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
			Prefeito Municipal
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			Presidente da C&#226;mara Municipal
		</xsl:if>
		<xsl:if
			test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
			Respons&#225;vel
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="anoExercicio" select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO" />
	<!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
	<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
	<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
	<xsl:variable name="dia" select="substring($data, 9, 2)" />
	<xsl:variable name="mes" select="substring($data, 6, 2)" />
	<xsl:variable name="ano" select="substring($data, 1, 4)" />
	<xsl:variable name="mesNome">
		<xsl:if test="$mes='01'">
			Janeiro
		</xsl:if>
		<xsl:if test="$mes='02'">
			Fevereiro
		</xsl:if>
		<xsl:if test="$mes='03'">
			Mar&#231;o
		</xsl:if>
		<xsl:if test="$mes='04'">
			Abril
		</xsl:if>
		<xsl:if test="$mes='05'">
			Maio
		</xsl:if>
		<xsl:if test="$mes='06'">
			Junho
		</xsl:if>
		<xsl:if test="$mes='07'">
			Julho
		</xsl:if>
		<xsl:if test="$mes='08'">
			Agosto
		</xsl:if>
		<xsl:if test="$mes='09'">
			Setembro
		</xsl:if>
		<xsl:if test="$mes='10'">
			Outubro
		</xsl:if>
		<xsl:if test="$mes='11'">
			Novembro
		</xsl:if>
		<xsl:if test="$mes='12'">
			Dezembro
		</xsl:if>
	</xsl:variable>

	<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
	
		<fo:table-column column-number="1" column-width="265pt"/>
		<fo:table-column column-number="2" column-width="8pt"/>
		<fo:table-column column-number="3" column-width="0pt"/>
		<fo:table-column column-number="4" column-width="8pt"/>
		<fo:table-column column-number="5" column-width="265pt"/>

		<fo:table-body>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO" />
						,
						<xsl:value-of select="$dia" />
						de
						<xsl:value-of select="$mesNome" />
						de
						<xsl:value-of select="$ano" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Gestor responsvel pelo perodo de 01/01/<xsl:value-of select="$anoExercicio"/> a 31/12/<xsl:value-of select="$anoExercicio"/> -
						<xsl:value-of select="AssinaturasRow/RESPONSAVEL_PERIODO" /> -
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Responsveis pela entrega dos documentos
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>

			<fo:table-row>
				<fo:table-cell border-width="0.5pt">txtCenter
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/CONTABILISTA" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">Contabilista</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<!-- fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						Respons&#225;vel pelo Controle Interno
					</fo:block-->
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/ADMINISTRADOR" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
		</fo:table-body>
	</fo:table>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template name="FormataNumero">
	<xsl:param name="valor" select="0" />
	<xsl:choose>
		<xsl:when test="string(number($valor))='NaN'">-</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="format-number($valor, '#.##0,00')" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
